/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.workbench.tools.NewModuleWizard;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.sys.Sys;

public final class GradleFileUtil {
    private GradleFileUtil() {
    }

    public static void createEnvironmentGradle(FilePath moduleRoot, String vendor) throws IOException {
        BFileSystem fs = BFileSystem.INSTANCE;
        StringBuffer buf = new StringBuffer();
        buf.append("/*\n");
        buf.append(" * " + NewModuleWizard.getCopyrightStatement(vendor) + "\n");
        buf.append(" */\n");
        buf.append("/* Environment Configuration File */\n");
        buf.append('\n');
        buf.append("// Change niagara_home and niagara_user_home as needed to point to the\n");
        buf.append("// correct path to your desired Niagara install and its associated\n");
        buf.append("// user home\n");
        buf.append("gradle.ext.niagara_dev_home = \"" + fs.pathToLocalFile(moduleRoot).toString().replace("\\", "/") + "\"\n");
        buf.append("gradle.ext.niagara_home = \"" + Sys.getNiagaraHome().toString().replace("\\", "/") + "\"\n");
        buf.append("gradle.ext.niagara_user_home = \"" + Sys.getNiagaraUserHome().toString().replace("\\", "/") + "\"\n");
        BIFile environmentFile = fs.makeFile(moduleRoot.merge("environment.gradle"), null);
        try (OutputStream out = environmentFile.getOutputStream();
             PrintWriter writer = new PrintWriter(out);){
            writer.write(buf.toString());
            writer.flush();
        }
    }
}

