/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.role;

import com.tridium.workbench.fieldeditors.BDialogFE;
import com.tridium.workbench.util.WbUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.baja.naming.SlotPath;
import javax.baja.role.BIRoleService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

public class BRoleFE
extends BDialogFE {
    public static final Type TYPE = Sys.loadType(BRoleFE.class);
    static final Lexicon lex = Lexicon.make(BRoleFE.class);
    private BIRoleService roleService = null;
    private Set<String> currentRoles = null;
    private BUser user = null;
    private BFlowPane pane = new BFlowPane();
    private BCheckList roles = null;
    private BWidget editButton = null;
    private BCheckList editDialogRoles = null;
    private boolean readonly = false;
    private static final int DISPLAY_TOP_ROLES = 10;
    private static final int DISPLAY_ALL_ROLES = -1;

    public Type getType() {
        return TYPE;
    }

    public BRoleFE() {
        this.setContent((BWidget)this.pane);
    }

    public void doSetReadonly(boolean readonly) {
        super.doSetReadonly(readonly);
        this.readonly = readonly;
        this.relayout();
    }

    protected void doLoadValue(BObject v, Context cx) {
        if (cx != null && cx.getFacet("username") != null) {
            BUserService userService = (BUserService)WbUtil.findService((BWidget)this, (Type)BUserService.TYPE);
            BUser bUser = this.user = userService != null ? userService.getUser(((BString)cx.getFacet("username")).getString()) : null;
        }
        if (!(v instanceof BString)) {
            return;
        }
        String rolesValue = ((BString)v).getString();
        this.currentRoles = BUser.splitRoles((String)rolesValue);
        this.roleService = (BIRoleService)WbUtil.findService((BWidget)this, (Type)BIRoleService.TYPE);
        if (this.roleService != null) {
            this.roleService.lease(1, 30000L);
        }
        this.setupView(this.currentRoles, this.roleService);
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        return BString.make((String)BRoleFE.delimitSelected(this.roles));
    }

    private void addCheckList() {
        if (this.roles == null) {
            this.roles = new BCheckList();
            this.roles.setEnabled(!this.readonly);
            this.roles.setController((ListController)new RoleListController());
            this.pane.add(null, (BValue)this.roles);
        }
        this.roles.getSelection().deselectAll();
        this.roles.getModel().removeAllItems();
    }

    private void addEditButton() {
        if (this.editButton == null) {
            this.editButton = this.getEditButton();
            this.getEditButton().computePreferredSize();
            this.pane.add(null, (BValue)this.editButton);
        }
    }

    private void setupView(Set<String> currentRoles, BIRoleService roleService) {
        this.addCheckList();
        BRoleFE.addCurrentRoles(this.roles, currentRoles);
        if (roleService != null && !this.readonly) {
            roleService.lease();
            this.addEditButton();
            BRoleFE.addTopRolesFrom(this.roles, roleService, currentRoles, this.user);
        }
        this.linkTo((BComponent)this.roles, (Slot)BCheckList.actionPerformed, (Slot)setModified);
        this.relayout();
    }

    private static void addCurrentRoles(BCheckList roles, Set<String> currentRoles) {
        int i = 0;
        for (String roleId : currentRoles) {
            roles.getModel().addItem((Object)roleId);
            roles.getSelection().select(i++);
        }
    }

    private static void addTopRolesFrom(BCheckList roles, BIRoleService roleService, Set<String> currentRoles, BUser user) {
        BRoleFE.addRolesFrom(roles, roleService, currentRoles, user, 10);
    }

    private static void addRolesFrom(BCheckList roles, BIRoleService roleService, Set<String> currentRoles, BUser user, int maxRoles) {
        if (roleService == null) {
            return;
        }
        Set allowedRoles = null;
        if (user != null && !user.getPermissions(roleService).isSuperUser()) {
            user.lease();
            allowedRoles = BUser.splitRoles((String)user.getRoles());
        }
        int rolesAdded = 0;
        int maxRolesToAdd = maxRoles - currentRoles.size();
        List availableRoles = roleService.getEnabledRoleIds();
        Iterator it = availableRoles.iterator();
        while (it.hasNext() && (maxRoles == -1 || rolesAdded < maxRolesToAdd)) {
            String role = SlotPath.unescape((String)((String)it.next()));
            if (allowedRoles != null && !allowedRoles.contains(role) || currentRoles.contains(role)) continue;
            roles.getModel().addItem((Object)role);
            roles.getSelection().deselect(roles.getModel().indexOfItem((Object)role));
            ++rolesAdded;
        }
    }

    public void doEditPressed() {
        BEdgePane pane = new BEdgePane();
        this.editDialogRoles = new BCheckList();
        pane.setCenter((BWidget)this.editDialogRoles);
        BRoleFE.addCurrentRoles(this.editDialogRoles, BUser.splitRoles((String)BRoleFE.delimitSelected(this.roles)));
        BRoleFE.addRolesFrom(this.editDialogRoles, this.roleService, BUser.splitRoles((String)BRoleFE.delimitSelected(this.roles)), this.user, -1);
        int retVal = BDialog.open((BWidget)this, (String)lex.get("roleFE.editRoles", "Edit Roles"), (Object)pane, (int)3);
        if (retVal == 1) {
            Set rolesFromEditDialog = BUser.splitRoles((String)BRoleFE.delimitSelected(this.editDialogRoles));
            if (this.currentRoles != null) {
                boolean rolesChanged;
                boolean bl = rolesChanged = !this.currentRoles.containsAll(rolesFromEditDialog) || !rolesFromEditDialog.containsAll(this.currentRoles);
                if (rolesChanged) {
                    this.currentRoles = rolesFromEditDialog;
                    BRoleFE.updateChecklist(this.editDialogRoles, this.roles);
                    BRoleFE.addTopRolesFrom(this.roles, this.roleService, this.currentRoles, this.user);
                    this.setModified();
                    this.relayout();
                }
            }
        }
    }

    private static void updateChecklist(BCheckList source, BCheckList destination) {
        ListModel model = destination.getModel();
        model.removeAllItems();
        Object[] selectedItems = source.getSelectedItems();
        int i = 0;
        for (Object role : selectedItems) {
            model.addItem(role);
            destination.getSelection().select(i++);
        }
    }

    private static String delimitSelected(BCheckList roles) {
        int[] roleIds = roles.getSelection().getItems();
        ListModel roleList = roles.getModel();
        StringBuilder sb = new StringBuilder();
        boolean hasRole = false;
        for (int i = 0; i < roleIds.length; ++i) {
            hasRole = true;
            sb.append(SlotPath.escape((String)roleList.getItem(roleIds[i]).toString())).append(",");
        }
        if (hasRole) {
            sb.deleteCharAt(sb.length() - 1);
        }
        String delimitedRoles = sb.toString();
        return delimitedRoles;
    }

    private class RoleListController
    extends BCheckList.CheckListController {
        private RoleListController() {
        }

        protected void itemReleased(BMouseEvent event, int index) {
            super.itemReleased(event, index);
            BRoleFE.this.setModified();
        }
    }
}

