/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.metadata;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.metadata.BMetadataJob;
import com.tridium.workbench.metadata.MetadataCommands;
import com.tridium.workbench.nav.NavMonitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIPropertySpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BMetadataBrowser
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BMetadataBrowser.class);
    static TypeInfo HISTORY_TYPE = null;
    static Context context = null;
    static final Lexicon lex = Lexicon.make(BMetadataBrowser.class);
    BTreeTable table;
    Model model;
    Array<Node> roots;
    MetadataCommands commands;
    HashMap<Node, String> textCache = new HashMap();
    BJobBar jobBar;
    boolean jobComplete;
    BJob job = null;

    public Type getType() {
        return TYPE;
    }

    public BMetadataBrowser() {
        this.autoRegisterForComponentEvents = false;
        this.roots = new Array(Node.class);
        this.table = new BTreeTable();
        this.model = new Model();
        this.table.setModel((TableModel)this.model);
        this.table.setSelection((TableSelection)new Selection());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setController((TableController)new Controller());
        this.commands = new MetadataCommands(this);
        BGridPane aux = new BGridPane(3);
        aux.add(null, (BValue)new BButton((Command)this.commands.slotAdd));
        aux.add(null, (BValue)new BButton((Command)this.commands.slotEdit));
        aux.add(null, (BValue)new BButton((Command)this.commands.slotRemove));
        BEdgePane pane = new BEdgePane();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        BBorderPane topPane = new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
        pane.setTop((BWidget)topPane);
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setBottom((BWidget)new BBorderPane((BWidget)aux, 5.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)pane);
        try {
            if (HISTORY_TYPE == null) {
                HISTORY_TYPE = BTypeSpec.make((String)"history", (String)"IHistory").getTypeInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this.model);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this.model);
    }

    public BMenu[] getViewMenus() {
        return new BMenu[]{this.commands.buildMenu()};
    }

    public BToolBar getViewToolBar() {
        BToolBar toolbar = new BToolBar();
        toolbar.add(null, (Command)this.commands.slotAdd);
        toolbar.add(null, (Command)this.commands.slotEdit);
        toolbar.add(null, (Command)this.commands.slotRemove);
        return toolbar;
    }

    public void doLoadValue(BObject obj, Context cx) {
        if (cx != null) {
            try {
                String username = null;
                BUser user = cx.getUser();
                if (user != null) {
                    username = user.getUsername();
                } else {
                    BObject o = cx.getFacet("username");
                    if (o instanceof BString) {
                        username = ((BString)o).getString();
                    }
                }
                if (username != null) {
                    BMetadataJob currentJob = null;
                    currentJob = this.findJobInProgress();
                    if (currentJob != null) {
                        currentJob.lease();
                        if (username.equals(currentJob.getUsername())) {
                            this.job = currentJob;
                            this.jobComplete = false;
                            this.jobBar.load(this.job);
                            this.registerForComponentEvents((BComponent)this.job);
                        }
                    }
                }
            }
            catch (Exception username) {
                // empty catch block
            }
        }
        context = cx;
        BComponent comp = (BComponent)obj;
        this.registerForComponentEvents(comp);
        BFoxSession session = (BFoxSession)comp.getSession();
        BINavNode[] spaces = session.getNavChildren();
        for (int i = 0; i < spaces.length; ++i) {
            if (!(spaces[i] instanceof BSpace) || !(spaces[i] instanceof BINavNode) || !(spaces[i] instanceof BIPropertySpace)) continue;
            if (spaces[i] instanceof BComponentSpace) {
                BComponent root = ((BComponentSpace)spaces[i]).getRootComponent();
                this.registerForComponentEvents(root);
                Node node = new Node(this.model, (BINavNode)root);
                this.roots.add((Object)node);
                continue;
            }
            this.addRoot(((BSpace)spaces[i]).getOrdInSession());
        }
        this.commands.updateCommands();
        if (!this.model.needsInitialization()) {
            this.model.updateTreeTable(true);
        }
    }

    private void addRoot(BOrd ord) {
        try {
            BObject obj = ord.get(this.getCurrentValue());
            if (!(obj instanceof BINavNode)) {
                return;
            }
            this.addRoot((BINavNode)obj);
        }
        catch (Exception e) {
            System.out.println("Cannot add root: " + ord);
            e.printStackTrace();
        }
    }

    private void addRoot(BINavNode nav) {
        try {
            this.roots.add((Object)new Node(this.model, nav));
        }
        catch (Exception e) {
            System.out.println("Cannot add root: " + nav.getNavOrd());
            System.out.println("  " + e);
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        BComponent source = event.getSourceComponent();
        if (this.job == source) {
            if (this.job.getJobState().isComplete() && !this.jobComplete) {
                this.jobComplete = true;
                this.jobComplete(this.job);
            }
        } else {
            switch (event.getId()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if ((event.getSlotFlags() & 0x4000) == 0) break;
                    this.updateOnEvent(event);
                    break;
                }
                case 4: {
                    this.updateOnEvent(event);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnEvent(BComponentEvent event) {
        Node node;
        if (this.model != null && (node = this.model.eventToNode(event)) != null) {
            HashMap<Node, String> hashMap = this.textCache;
            synchronized (hashMap) {
                this.textCache.remove((Object)node);
            }
        }
        this.repaint();
    }

    void setJob(BJob job) {
        BJob newJob;
        BJobService jobService = (BJobService)BOrd.make((String)"service:baja:JobService").get(this.getCurrentValue());
        BOrd jobOrd = jobService.submit(job, this.getCurrentContext());
        try {
            jobService.getComponentSpace().sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.job = newJob = (BJob)jobOrd.get((BObject)jobService);
        this.jobComplete = false;
        this.registerForComponentEvents((BComponent)newJob);
        this.jobBar.load(newJob);
        if (newJob != null && newJob.getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            this.jobComplete(newJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jobComplete(BJob job) {
        this.commands.updateCommands();
        HashMap<Node, String> hashMap = this.textCache;
        synchronized (hashMap) {
            this.textCache.clear();
        }
        this.repaint();
    }

    BMetadataJob findJobInProgress() {
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd jobServiceOrd = BOrd.make((BOrd)authority, (String)"service:baja:JobService");
        BJobService jobService = (BJobService)jobServiceOrd.resolve().get();
        jobService.lease();
        BMetadataJob[] jobs = (BMetadataJob[])jobService.getChildren(BMetadataJob.class);
        if (jobs != null) {
            for (int i = 0; i < jobs.length; ++i) {
                if (jobs[i] == null) continue;
                jobs[i].lease();
                if (!jobs[i].isAlive()) continue;
                return jobs[i];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String nodeToString(Node node) {
        String text = null;
        HashMap<Node, String> hashMap = this.textCache;
        synchronized (hashMap) {
            text = this.textCache.get((Object)node);
        }
        if (text != null) {
            return text;
        }
        if (node.nav instanceof BIPropertyContainer) {
            BIPropertyContainer container = this.checkHistory((BIPropertyContainer)node.nav);
            Property[] props = container.getPropertiesArray();
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < props.length; ++i) {
                if ((container.getFlags((Slot)props[i]) & 0x4000) == 0) continue;
                if (!first) {
                    sb.append(" | ");
                }
                first = false;
                sb.append(container.getDisplayName((Slot)props[i], context)).append(":");
                sb.append(container.get(props[i]).toString(context));
            }
            text = sb.toString();
        } else {
            text = lex.getText("metadataBrowser.notApplicable");
        }
        hashMap = this.textCache;
        synchronized (hashMap) {
            this.textCache.put(node, text);
        }
        return text;
    }

    BIPropertyContainer checkHistory(BIPropertyContainer container) {
        if (HISTORY_TYPE != null && container.getType().is(HISTORY_TYPE)) {
            try {
                Class cls = Sys.loadClass((String)"history", (String)"javax.baja.history.BIHistory");
                Method m = cls.getMethod("getConfig", new Class[]{null});
                return (BIPropertyContainer)m.invoke((Object)container, new Object[]{null});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return container;
    }

    BINavNode[] getSelectedNodes() {
        int[] rows = this.table.getSelection().getRows();
        BINavNode[] selected = new BINavNode[rows.length];
        for (int i = 0; i < selected.length; ++i) {
            Node node = (Node)this.model.rowToNode(rows[i]);
            selected[i] = (BINavNode)node.getSubject();
        }
        return selected;
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = BMetadataBrowser.this.commands.buildMenu();
            menu.open((BWidget)BMetadataBrowser.this.table, event.getX(), event.getY());
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            boolean b = BMetadataBrowser.this.table.getSelection().getRows().length > 0;
            String[] allCols = BMetadataBrowser.this.model.getAllColumns();
            if (!b || allCols == null || allCols.length <= 0) {
                return;
            }
            BMetadataBrowser.this.commands.slotEdit.doInvoke();
        }
    }

    class Selection
    extends TreeTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BMetadataBrowser.this.commands.updateCommands();
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        BBrush EXPANDER_BRUSH = BColor.black.toBrush();
        BBrush CONNECTING_BRUSH = BColor.make((int)192, (int)192, (int)192).toBrush();
        BBrush DISABLED = BColor.make((String)"#666").toBrush();

        Renderer() {
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            BBrush fg = g.getBrush();
            if (cell.column == 0) {
                String text;
                BImage icon;
                double y;
                TreeTableTheme theme = Theme.treeTable();
                Node node = (Node)BMetadataBrowser.this.model.rowToNode(cell.row);
                int depth = node.getDepth();
                double x = theme.getIndent(depth);
                if (BMetadataBrowser.this.model.isDepthExpandable(depth)) {
                    if (node.hasChildren()) {
                        int state = node.isExpanded() ? 2 : 1;
                        y = (cell.height - theme.getExpanderHeight()) / 2.0;
                        this.paintExpander(g, theme, x, y, state);
                    }
                    x += theme.getExpanderWidth() + 5.0;
                }
                if ((icon = BMetadataBrowser.this.model.getRowIcon(cell.row)) != null) {
                    y = (cell.height - 16.0) / 2.0;
                    g.drawImage(icon, x, y);
                    x += 18.0;
                }
                if ((text = this.getCellText(cell)) != null && text.length() > 0) {
                    BFont font = Theme.table().getCellFont();
                    g.setBrush(fg);
                    g.setFont(font);
                    g.drawString(text, x, (cell.height + font.getAscent() - font.getDescent()) / 2.0);
                }
            } else {
                Node node = (Node)BMetadataBrowser.this.model.rowToNode(cell.row);
                String text = BMetadataBrowser.this.nodeToString(node);
                if (text != null && text.length() > 0) {
                    BFont font = Theme.table().getCellFont();
                    if (!node.configured() && !fg.equals((Object)this.getSelectionForeground(cell))) {
                        g.setBrush(this.DISABLED);
                    } else {
                        g.setBrush(fg);
                    }
                    g.setFont(font);
                    g.drawString(text, 4.0, (cell.height + font.getAscent() - font.getDescent()) / 2.0);
                }
            }
            this.paintVerticalLine(g, cell);
        }

        private void paintExpander(Graphics g, TreeTableTheme theme, double x, double y, int state) {
            BBrush origBrush = g.getBrush();
            g.setBrush(this.CONNECTING_BRUSH);
            double ew = theme.getExpanderWidth();
            double eh = theme.getExpanderHeight();
            g.strokeLine(x, y, x + ew - 1.0, y);
            g.strokeLine(x, y, x, y + ew - 1.0);
            g.strokeLine(x + ew - 1.0, y, x + ew - 1.0, y + eh - 1.0);
            g.strokeLine(x, y + eh - 1.0, x + ew - 1.0, y + eh - 1.0);
            g.setBrush(this.EXPANDER_BRUSH);
            if (state != 0) {
                g.strokeLine(x + 2.0, y + 4.0, x + 6.0, y + 4.0);
            }
            if (state == 1) {
                g.strokeLine(x + 4.0, y + 2.0, x + 4.0, y + 6.0);
            }
            g.setBrush(origBrush);
        }
    }

    class Node
    extends TreeTableNode {
        BINavNode nav;
        String navOrdRelStr;
        BObject object;
        Node[] kids;
        BImage icon;
        boolean performFullLoad;
        boolean buildChildren;

        Node(Model model, BINavNode nav) {
            super((TreeTableModel)model);
            this.performFullLoad = false;
            this.buildChildren = false;
            this.nav = nav;
            this.init();
        }

        Node(Node parent, BINavNode nav) {
            super((TreeTableNode)parent);
            this.performFullLoad = false;
            this.buildChildren = false;
            this.nav = nav;
            this.init();
        }

        void init() {
            BOrd navOrd = this.nav.getNavOrd();
            BOrd navOrdRel = navOrd.relativizeToSession();
            this.navOrdRelStr = navOrdRel.toString();
            this.icon = BImage.make((BIcon)this.nav.getNavIcon());
        }

        public Object getSubject() {
            return this.nav;
        }

        public Object getValueAt(int col) {
            if (col == 0) {
                return this.nav.getNavDisplayName(null);
            }
            return "";
        }

        public BImage getIcon() {
            return this.icon;
        }

        public boolean hasChildren() {
            if (this.kids == null) {
                return this.nav.hasNavChildren();
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            this.build();
            return this.kids.length;
        }

        public TreeTableNode getChild(int index) {
            this.build();
            return this.kids[index];
        }

        boolean configured() {
            return this.nav instanceof BIPropertyContainer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void build() {
            if (this.buildChildren || this.kids == null) {
                this.buildChildren = false;
                BMetadataBrowser.this.enterBusy();
                try {
                    BINavNode[] n = this.nav.getNavChildren();
                    Array a = new Array(Node.class);
                    Array comps = new Array(BComponent.class);
                    for (int i = 0; i < n.length; ++i) {
                        a.add((Object)new Node(this, n[i]));
                        if (!(n[i] instanceof BComponent)) continue;
                        comps.add((Object)((BComponent)n[i]));
                    }
                    this.kids = (Node[])a.trim();
                    BComponent[] components = (BComponent[])comps.trim();
                    if (components != null && components.length > 0) {
                        BMetadataBrowser.this.registerForComponentEvents(components, 0);
                    }
                }
                finally {
                    BMetadataBrowser.this.exitBusy();
                }
            }
        }

        public void expanded() {
            if (this.performFullLoad) {
                this.performFullLoad = false;
                this.buildChildren = true;
            }
            NavMonitor.touch();
        }
    }

    class Model
    extends TreeTableModel
    implements NavListener {
        Model() {
        }

        public int getRootCount() {
            return BMetadataBrowser.this.roots.size();
        }

        public TreeTableNode getRoot(int index) {
            return (TreeTableNode)BMetadataBrowser.this.roots.get(index);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "";
            }
            return lex.getText("metadataBrowser.metaColumn.label");
        }

        String[] getAllColumns() {
            return this.getAllColumns(true);
        }

        String[] getAllColumns(boolean includeFrozen) {
            ArrayList<String> list = new ArrayList<String>();
            BINavNode[] nodes = BMetadataBrowser.this.getSelectedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof BIPropertyContainer)) continue;
                BIPropertyContainer container = BMetadataBrowser.this.checkHistory((BIPropertyContainer)nodes[i]);
                Property[] props = includeFrozen ? container.getPropertiesArray() : container.getDynamicPropertiesArray();
                for (int j = 0; j < props.length; ++j) {
                    String propName = props[j].getName();
                    if (list.contains(propName) || (container.getFlags((Slot)props[j]) & 0x4000) == 0) continue;
                    list.add(propName);
                }
            }
            Object[] array = list.toArray(new String[list.size()]);
            Arrays.sort(array);
            return array;
        }

        Type getColumnType(String name) {
            BINavNode[] nodes = BMetadataBrowser.this.getSelectedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                try {
                    BIPropertyContainer container;
                    Property prop;
                    if (!(nodes[i] instanceof BIPropertyContainer) || (prop = (container = BMetadataBrowser.this.checkHistory((BIPropertyContainer)nodes[i])).getProperty(name)) == null || (container.getFlags((Slot)prop) & 0x4000) == 0) continue;
                    return container.get(prop).getType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return BString.TYPE;
        }

        public BObject export(int row, int col) {
            if (col == 0) {
                return super.export(row, col);
            }
            Node node = (Node)BMetadataBrowser.this.model.rowToNode(row);
            return BString.make((String)BMetadataBrowser.this.nodeToString(node));
        }

        public void navEvent(NavEvent event) {
            Node parent;
            if (event.getId() == 2 && (parent = this.eventToNode(event)) != null && parent.nav instanceof BComponent) {
                BComponent comp = (BComponent)parent.nav;
                if (comp instanceof BVirtualGateway) {
                    try {
                        comp = ((BVirtualGateway)comp).getVirtualSpace().getRootComponent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded()) {
                    parent.performFullLoad = true;
                }
            }
        }

        Node eventToNode(NavEvent event) {
            BOrd ord = event.getParentOrd();
            if (ord == null) {
                return null;
            }
            String relOrd = ord.relativizeToSession().toString();
            Node node = null;
            for (int j = 0; j < BMetadataBrowser.this.roots.size() && (node = this.findNodeByNavOrd(relOrd, (Node)((Object)BMetadataBrowser.this.roots.get(j)))) == null; ++j) {
            }
            return node;
        }

        Node eventToNode(BComponentEvent event) {
            BComponent comp = event.getSourceComponent();
            if (comp == null) {
                return null;
            }
            BOrd ord = comp.getNavOrd();
            if (ord == null) {
                return null;
            }
            String relOrd = ord.relativizeToSession().toString();
            Node node = null;
            for (int j = 0; j < BMetadataBrowser.this.roots.size() && (node = this.findNodeByNavOrd(relOrd, (Node)((Object)BMetadataBrowser.this.roots.get(j)))) == null; ++j) {
            }
            return node;
        }

        Node findNodeByNavOrd(String ord, Node node) {
            Node[] children;
            if (ord.equals(node.navOrdRelStr)) {
                return node;
            }
            if (ord.startsWith(node.navOrdRelStr) && (children = node.kids) != null) {
                for (int i = 0; i < children.length; ++i) {
                    Node result = this.findNodeByNavOrd(ord, children[i]);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
    }
}

