/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.metadata;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.fieldeditors.BTypeSpecFE;
import com.tridium.workbench.metadata.BMetadataBrowser;
import com.tridium.workbench.metadata.BMetadataJob;
import com.tridium.workbench.util.BFlagConfig;
import javax.baja.data.BIDataValue;
import javax.baja.job.BJob;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BAddDialog
extends BOptionDialog {
    public static final Action typeChanged = BAddDialog.newAction((int)0, null, null);
    public static final Type TYPE = Sys.loadType(BAddDialog.class);
    private static Lexicon lex = Lexicon.make(BMetadataBrowser.class);
    private BTextField name = new BTextField("", 30);
    private BTypeSpecFE type;
    private BWbFieldEditor editor;
    private BCheckBox setIfExists = new BCheckBox(lex.getText("metadataBrowser.setIfExists"));
    private BCheckBox applyDescendants = new BCheckBox(lex.getText("metadataBrowser.applyDescendants"));
    private BFlagConfig flagEditor;
    private BWbFieldEditor facetsEditor;
    private BBorderPane content;

    public void typeChanged() {
        this.invoke(typeChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static void open(BMetadataBrowser editor) {
        if (editor.findJobInProgress() != null) {
            BDialog.error((BWidget)editor, (String)lex.getText("metadataBrowser.commandFail"), (Object)lex.getText("metadataBrowser.jobAlreadyRunning"));
            return;
        }
        BAddDialog dlg = new BAddDialog(editor);
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        if (dlg.getResult() == 1) {
            try {
                if (!SlotPath.isValidName((String)dlg.name.getText())) {
                    BDialog.error((BWidget)editor, (String)lex.getText("metadataBrowser.commands.slotAdd.label"), (Object)lex.getText("metadataBrowser.invalidName"));
                } else {
                    String name = dlg.name.getText();
                    BValue value = (BValue)dlg.editor.saveValue();
                    boolean set = dlg.setIfExists.isSelected();
                    boolean applyDescendants = dlg.applyDescendants.isSelected();
                    int flags = dlg.flagEditor.save();
                    BFacets facets = (BFacets)dlg.facetsEditor.saveValue();
                    BINavNode[] nodes = editor.getSelectedNodes();
                    BMetadataJob metaJob = new BMetadataJob(0, nodes, name, value, set, applyDescendants, flags, facets, editor.getCurrentContext());
                    editor.setJob((BJob)metaJob);
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)editor, (String)lex.getText("metadataBrowser.commandFail"), (Object)lex.getText("metadataBrowser.addFail"), (Throwable)e);
            }
        }
    }

    private BAddDialog(BMetadataBrowser parent) {
        super((BWidget)parent, lex.getText("metadataBrowser.commands.slotAdd.label"), (BWidget)new BNullWidget(), 3, null, null);
        BFacets facets = BFacets.make((String)"allowNull", (BIDataValue)BBoolean.FALSE);
        facets = BFacets.make((BFacets)facets, (String)"showAbstract", (BIDataValue)BBoolean.FALSE);
        this.type = new BTypeSpecFE();
        this.linkTo("link", (BComponent)this.type, (Slot)BTypeSpecFE.pluginModified, (Slot)typeChanged);
        this.type.loadValue((BObject)BString.TYPE.getTypeSpec(), (Context)facets);
        this.setIfExists.setSelected(true);
        this.applyDescendants.setSelected(false);
        this.editor = this.make(BString.TYPE);
        this.flagEditor = new BFlagConfig(null, null);
        this.flagEditor.load(16384);
        this.facetsEditor = BWbFieldEditor.makeFor((BObject)BFacets.NULL);
        this.facetsEditor.loadValue((BObject)BFacets.NULL);
        BGridPane flagInner = new BGridPane(2);
        flagInner.setHalign(BHalign.left);
        flagInner.add(null, (BValue)new BLabel(lex.getText("metadataBrowser.flags")));
        flagInner.add(null, (BValue)this.flagEditor);
        flagInner.add(null, (BValue)new BLabel(lex.getText("metadataBrowser.facets")));
        flagInner.add(null, (BValue)this.facetsEditor);
        BGridPane edGrid = new BGridPane(1);
        edGrid.setValign(BValign.top);
        edGrid.setHalign(BHalign.left);
        this.content = new BBorderPane((BWidget)this.editor, 0.0, 0.0, 0.0, 0.0);
        edGrid.add(null, (BValue)this.content);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)new BLabel(lex.getText("metadataBrowser.newName")));
        grid.add(null, (BValue)this.name);
        grid.add(null, (BValue)new BLabel(lex.getText("metadataBrowser.newType")));
        grid.add(null, (BValue)this.type);
        BGridPane grid2 = new BGridPane(1);
        grid2.setHalign(BHalign.left);
        grid2.add(null, (BValue)grid);
        grid2.add(null, (BValue)this.setIfExists);
        grid2.add(null, (BValue)this.applyDescendants);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)grid2, 0.0, 0.0, 10.0, 0.0));
        edge.setCenter((BWidget)new BBorderPane((BWidget)edGrid, lex.getText("metadataBrowser.newValue")));
        edge.setBottom((BWidget)flagInner);
        this.setContent((BWidget)new BBorderPane((BWidget)edge, 10.0, 10.0, 10.0, 10.0));
    }

    private BWbFieldEditor make(Type type) {
        BObject prop = type.getInstance();
        BWbFieldEditor fe = BWbFieldEditor.makeFor((BObject)prop);
        fe.loadValue(prop);
        return fe;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double pw = Math.max(500.0, this.getPreferredWidth());
        double ph = Math.max(300.0, this.getPreferredHeight());
        this.setPreferredSize(pw, ph);
    }

    public void doTypeChanged() {
        try {
            BObject obj = ((BTypeSpec)this.type.saveValue()).getInstance();
            this.editor = this.make(obj.getType());
            this.content.setContent((BWidget)this.editor);
            this.computePreferredSize();
            this.setSize(this.getPreferredWidth(), this.getPreferredHeight());
            this.setBoundsCenteredOnOwner();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

