/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors.facets;

import com.tridium.workbench.fieldeditors.BDialogFE;
import com.tridium.workbench.fieldeditors.facets.BFacetsEditor;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BFlowPane;

public class BFacetsFE
extends BDialogFE {
    public static final Type TYPE = Sys.loadType(BFacetsFE.class);
    private BFacets facets;
    private BLabel label;
    private BMruButton history = new BMruButton("facetsFE");
    private static final int MAX_LENGTH = 50;

    public Type getType() {
        return TYPE;
    }

    public BFacetsFE() {
        this.history.setMruController((BMruButton.MruController)new MruController());
        this.history.setButtonStyle(BButtonStyle.toolBar);
        BFlowPane pane = new BFlowPane();
        this.label = new BLabel();
        pane.add(null, (BValue)this.label);
        pane.add(null, (BValue)this.getEditButton());
        pane.add(null, (BValue)this.history);
        this.setContent((BWidget)pane);
    }

    protected void doSetReadonly(boolean readonly) {
        this.history.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject facetsValue, Context cx) {
        this.facets = (BFacets)facetsValue;
        BFacets temporaryFacets = BFacets.makeRemove((BFacets)this.facets, (String)"radix");
        String facetsString = this.facets.toString((Context)temporaryFacets);
        if (facetsString.length() > 50) {
            this.label.setText(facetsString.substring(0, 50) + "...");
        } else {
            this.label.setText(facetsString);
        }
    }

    protected BObject doSaveValue(BObject facetsValue, Context cx) throws Exception {
        try {
            this.history.getMruOptions().save(this.facets.encodeToString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.facets;
    }

    public void doEditPressed() {
        try {
            BFacets temp = BFacetsEditor.open((BWidget)this, this.facets, this.isReadonly());
            if (temp != null) {
                this.loadValue((BObject)temp, this.getCurrentContext());
                this.setModified();
            }
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)"Error", (Object)"Error", (Throwable)e);
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public String toDisplayString(String value) {
            try {
                return BFacets.make((String)value).toString(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return value;
            }
        }

        public void select(String value) {
            try {
                BFacetsFE.this.loadValue((BObject)BFacets.make((String)value), BFacetsFE.this.getCurrentContext());
                BFacetsFE.this.setModified();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

