/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BStopEditor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

public class BGradientEditor
extends BEdgePane {
    public static final Action updateSwatch = BGradientEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BGradientEditor.class);
    private static BImage newIcon = BImage.make((String)"module://icons/x16/new.png");
    private static BImage dupIcon = BImage.make((String)"module://icons/x16/duplicate.png");
    private static BImage saveIcon = BImage.make((String)"module://icons/x16/save.png");
    private static BImage saveAsIcon = BImage.make((String)"module://icons/x16/saveAs.png");
    private static BImage removeIcon = BImage.make((String)"module://icons/x16/delete.png");
    private static BImage linIcon = BImage.make((String)"module://wbutil/com/tridium/workbench/colorchooser/icons/linear.png");
    private static BImage radIcon = BImage.make((String)"module://wbutil/com/tridium/workbench/colorchooser/icons/radial.png");
    private static Lexicon lexicon = Lexicon.make((String)"wbutil");
    private static BBrush defaultBrush = BBrush.make((String)"linearGradient(stop(0% #ff0000) stop(100% #000080))");
    private BBrush brush;
    private BStopEditor stopEditor;
    private BBrushSwatch swatch;
    private LinearCommand linCommand;
    private RadialCommand radCommand;
    private BTextField centerX;
    private BTextField centerY;
    private BTextField focalX;
    private BTextField focalY;
    private BTextField radius;
    private BTextField angle;

    public void updateSwatch() {
        this.invoke(updateSwatch, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BBrush openInDialog(BWidget owner, BBrush brush) {
        BGradientEditor editor = new BGradientEditor(brush);
        if (1 == BDialog.open((BWidget)owner, (String)BGradientEditor.getText("gradientEditor"), (Object)new BBorderPane((BWidget)editor), (int)3)) {
            return editor.swatch.getBrush();
        }
        return null;
    }

    public BGradientEditor() {
        this(BBrush.NULL);
    }

    public BGradientEditor(BBrush b) {
        this.brush = b.isNull() ? defaultBrush : b;
        BBrush.Gradient paint = (BBrush.Gradient)this.brush.getPaint();
        this.linCommand = new LinearCommand((BWidget)this);
        BToggleButton bLin = new BToggleButton((Command)this.linCommand);
        this.radCommand = new RadialCommand((BWidget)this);
        BToggleButton bRad = new BToggleButton((Command)this.radCommand);
        bLin.setPadding(BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0));
        bRad.setPadding(BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0));
        BGridPane styles = new BGridPane(2);
        styles.setColumnGap(-1.0);
        styles.add(null, (BValue)bLin);
        styles.add(null, (BValue)bRad);
        BGridPane pos1 = new BGridPane(3);
        pos1.add(null, (BValue)new BLabel(BGradientEditor.getText("centerX")));
        this.centerX = new BTextField("50", 6);
        pos1.add(null, (BValue)this.centerX);
        pos1.add(null, (BValue)new BLabel("%"));
        pos1.add(null, (BValue)new BLabel(BGradientEditor.getText("centerY")));
        this.centerY = new BTextField("50", 6);
        pos1.add(null, (BValue)this.centerY);
        pos1.add(null, (BValue)new BLabel("%"));
        pos1.add(null, (BValue)new BLabel(BGradientEditor.getText("radius")));
        this.radius = new BTextField("50", 6);
        pos1.add(null, (BValue)this.radius);
        pos1.add(null, (BValue)new BLabel("%"));
        BGridPane pos2 = new BGridPane(3);
        pos2.add(null, (BValue)new BLabel(BGradientEditor.getText("focalX")));
        this.focalX = new BTextField("50", 6);
        pos2.add(null, (BValue)this.focalX);
        pos2.add(null, (BValue)new BLabel("%"));
        pos2.add(null, (BValue)new BLabel(BGradientEditor.getText("focalY")));
        this.focalY = new BTextField("50", 6);
        pos2.add(null, (BValue)this.focalY);
        pos2.add(null, (BValue)new BLabel("%"));
        pos2.add(null, (BValue)new BLabel(BGradientEditor.getText("angle")));
        this.angle = new BTextField("0", 6);
        pos2.add(null, (BValue)this.angle);
        BGridPane pos = new BGridPane(2);
        pos.setColumnGap(20.0);
        pos.add(null, (BValue)pos1);
        pos.add(null, (BValue)pos2);
        this.swatch = new BBrushSwatch(this.brush);
        this.swatch.setPreferredSize(80.0, 80.0);
        BGridPane top = new BGridPane(3);
        top.setRowAlign(BValign.top);
        top.setColumnGap(20.0);
        top.add(null, (BValue)this.swatch);
        top.add(null, (BValue)pos);
        top.add(null, (BValue)styles);
        BGridPane content = new BGridPane(1);
        content.setColumnAlign(BHalign.fill);
        content.setStretchColumn(0);
        content.setRowGap(20.0);
        content.add(null, (BValue)top);
        this.stopEditor = new BStopEditor(paint.getStops());
        content.add(null, (BValue)this.stopEditor);
        this.setCenter((BWidget)content);
        this.linkTo((BComponent)this.centerX, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.centerY, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.focalX, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.focalY, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.radius, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.angle, (Slot)BTextField.textModified, (Slot)updateSwatch);
        this.linkTo((BComponent)this.stopEditor, (Slot)BStopEditor.setModified, (Slot)updateSwatch);
        if (paint instanceof BBrush.LinearGradient) {
            this.angle.setText(Double.toString(((BBrush.LinearGradient)paint).getAngle()));
            this.radCommand.setSelected(false);
            this.linCommand.setSelected(true);
            this.radCommand.invoke();
            this.linCommand.invoke();
        } else {
            BBrush.RadialGradient r = (BBrush.RadialGradient)paint;
            this.centerX.setText(Double.toString(r.getCenter().x));
            this.centerY.setText(Double.toString(r.getCenter().y));
            this.focalX.setText(Double.toString(r.getFocal().x));
            this.focalY.setText(Double.toString(r.getFocal().y));
            this.radius.setText(Double.toString(r.getRadius()));
            this.radCommand.setSelected(true);
            this.linCommand.setSelected(false);
            this.linCommand.invoke();
            this.radCommand.invoke();
        }
    }

    public static double round(double v) {
        long tmp = Math.round(v *= 100.0);
        return (double)tmp / 100.0;
    }

    public static double stringToDouble(String s) {
        double v = 0.0;
        try {
            v = Double.parseDouble(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public void doUpdateSwatch() {
        if (this.linCommand.isSelected()) {
            double ang = BGradientEditor.stringToDouble(this.angle.getText());
            this.brush = BBrush.makeLinearGradient((BBrush.Stop[])this.stopEditor.getStops(), (int)1, (double)ang);
        } else {
            double cx = BGradientEditor.stringToDouble(this.centerX.getText());
            double cy = BGradientEditor.stringToDouble(this.centerY.getText());
            double fx = BGradientEditor.stringToDouble(this.focalX.getText());
            double fy = BGradientEditor.stringToDouble(this.focalY.getText());
            double r = BGradientEditor.stringToDouble(this.radius.getText());
            this.brush = BBrush.makeRadialGradient((BBrush.Stop[])this.stopEditor.getStops(), (int)1, (IPoint)new Point(cx, cy), (double)r, (IPoint)new Point(fx, fy));
        }
        this.swatch.setBrush(this.brush);
        this.swatch.repaint();
    }

    private static String getText(String attr) {
        return lexicon.getText("gradientEditor." + attr);
    }

    class RemoveCommand
    extends Command {
        RemoveCommand(BWidget owner) {
            super(owner, BGradientEditor.getText("remove"));
        }

        public BImage getIcon() {
            return removeIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class SaveAsCommand
    extends Command {
        SaveAsCommand(BWidget owner) {
            super(owner, BGradientEditor.getText("saveAs"));
        }

        public BImage getIcon() {
            return saveAsIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class SaveCommand
    extends Command {
        SaveCommand(BWidget owner) {
            super(owner, BGradientEditor.getText("save"));
        }

        public BImage getIcon() {
            return saveIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class DuplicateCommand
    extends Command {
        DuplicateCommand(BWidget owner) {
            super(owner, BGradientEditor.getText("duplicate"));
        }

        public BImage getIcon() {
            return dupIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class NewCommand
    extends Command {
        NewCommand(BWidget owner) {
            super(owner, BGradientEditor.getText("new"));
        }

        public BImage getIcon() {
            return newIcon;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class RadialCommand
    extends ToggleCommand {
        RadialCommand(BWidget owner) {
            super(owner, null);
        }

        public BImage getIcon() {
            return radIcon;
        }

        public CommandArtifact doInvoke() {
            if (!this.isSelected() && !BGradientEditor.this.linCommand.isSelected()) {
                this.setSelected(true);
            } else if (this.isSelected()) {
                BGradientEditor.this.centerX.setEnabled(true);
                BGradientEditor.this.centerY.setEnabled(true);
                BGradientEditor.this.focalX.setEnabled(true);
                BGradientEditor.this.focalY.setEnabled(true);
                BGradientEditor.this.radius.setEnabled(true);
                BGradientEditor.this.angle.setEnabled(false);
                BGradientEditor.this.centerX.requestFocus();
                BGradientEditor.this.linCommand.setSelected(false);
                BGradientEditor.this.updateSwatch();
            }
            return null;
        }
    }

    class LinearCommand
    extends ToggleCommand {
        LinearCommand(BWidget owner) {
            super(owner, null);
        }

        public BImage getIcon() {
            return linIcon;
        }

        public CommandArtifact doInvoke() {
            if (!this.isSelected() && !BGradientEditor.this.radCommand.isSelected()) {
                this.setSelected(true);
            } else if (this.isSelected()) {
                BGradientEditor.this.centerX.setEnabled(false);
                BGradientEditor.this.centerY.setEnabled(false);
                BGradientEditor.this.focalX.setEnabled(false);
                BGradientEditor.this.focalY.setEnabled(false);
                BGradientEditor.this.radius.setEnabled(false);
                BGradientEditor.this.angle.setEnabled(true);
                BGradientEditor.this.angle.requestFocus();
                BGradientEditor.this.radCommand.setSelected(false);
                BGradientEditor.this.updateSwatch();
            }
            return null;
        }
    }
}

