/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public class BBrushSwatch
extends BWidget {
    public static final Type TYPE = Sys.loadType(BBrushSwatch.class);
    private static int boxSize = 4;
    private static BColor lightColor = BColor.white;
    private static BColor darkColor = BColor.make((int)0xCCCCCC);
    private BBrush brush;
    private BImage background;
    private Controller controller = new Controller();

    public Type getType() {
        return TYPE;
    }

    public BBrushSwatch() {
        this(BBrush.NULL);
    }

    public BBrushSwatch(BBrush brush) {
        this.setBrush(brush);
        this.setPreferredSize(64.0, 64.0);
    }

    public void stopped() throws Exception {
        if (this.background != null) {
            this.background.dispose();
        }
    }

    public void computePreferredSize() {
    }

    public void doLayout(BWidget[] children) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.background == null || this.background.getWidth() != w || this.background.getHeight() != h) {
            if (this.background != null) {
                this.background.dispose();
            }
            this.background = BBrushSwatch.createBackground(w, h);
        }
    }

    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.drawImage(this.background, 0.0, 0.0);
        if (!this.brush.isNull()) {
            g.setBrush(this.brush);
            g.fillRect(0.0, 0.0, w - 1.0, h - 1.0);
        }
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush brush) {
        this.brush = brush;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller c) {
        this.controller = c;
        c.swatch = this;
    }

    public static BImage createBackground(double width, double height) {
        BImage background = BImage.make((double)width, (double)height);
        Graphics g = background.getGraphics();
        g.setBrush(lightColor);
        g.fillRect(0.0, 0.0, width, height);
        g.setBrush(darkColor);
        int j = 0;
        while ((double)j < height) {
            int start;
            int i = start = j / boxSize % 2 == 0 ? 0 : boxSize;
            while ((double)i < width) {
                g.fillRect((double)i, (double)j, (double)boxSize, (double)boxSize);
                i += boxSize * 2;
            }
            j += boxSize;
        }
        return background;
    }

    public void mousePressed(BMouseEvent event) {
        this.controller.mousePressed(event);
    }

    public void mouseReleased(BMouseEvent event) {
        this.controller.mouseReleased(event);
    }

    public void mouseEntered(BMouseEvent event) {
        this.controller.mouseEntered(event);
    }

    public void mouseExited(BMouseEvent event) {
        this.controller.mouseExited(event);
    }

    public void mouseMoved(BMouseEvent event) {
        this.controller.mouseMoved(event);
    }

    public void mouseDragged(BMouseEvent event) {
        this.controller.mouseDragged(event);
    }

    public void mousePulsed(BMouseEvent event) {
        this.controller.mousePulsed(event);
    }

    public static class Controller {
        public BBrushSwatch swatch;

        public void mousePressed(BMouseEvent event) {
        }

        public void mouseReleased(BMouseEvent event) {
        }

        public void mouseEntered(BMouseEvent event) {
        }

        public void mouseExited(BMouseEvent event) {
        }

        public void mouseMoved(BMouseEvent event) {
        }

        public void mouseDragged(BMouseEvent event) {
        }

        public void mousePulsed(BMouseEvent event) {
        }
    }
}

