/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celleditors;

import com.tridium.workbench.util.FloatingPointHelper;
import javax.baja.sys.BDouble;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.celleditor.BTextFieldCE;

public class BDoubleCE
extends BTextFieldCE {
    public static final Type TYPE = Sys.loadType(BDoubleCE.class);
    private FloatingPointHelper helper;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.helper = FloatingPointHelper.makeDouble((Context)cx);
        super.doLoadValue(value, cx);
    }

    protected String valueToString(BObject value, Context cx) {
        return this.helper.format(((BNumber)value).getDouble());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String text = this.getTextField().getText();
        if (text.isEmpty()) {
            return BDouble.DEFAULT;
        }
        try {
            double d = this.helper.parseAndValidate(text);
            if (Double.isNaN(d)) {
                d = 0.0;
            }
            return BDouble.make((double)d);
        }
        catch (CannotSaveException e) {
            System.out.println("BDoubleCE: CannotSaveException (" + e.getMessage() + ')');
            return value;
        }
    }
}

