/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.category;

import com.tridium.workbench.category.BCategoryCheckList;
import javax.baja.category.BAbstractCategory;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryMode;
import javax.baja.category.BCategoryService;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class Category {
    static final Lexicon lex = Lexicon.make(BCategoryCheckList.class);
    public int index;
    public String display;
    public BAbstractCategory category;
    public BCategoryMode mode = BCategoryMode.union;

    public static Result load(BWbShell shell) {
        return Category.load(shell, 8);
    }

    public static Result load(BWbShell shell, int size) {
        if (size < 8) {
            size = 9;
        }
        Result result = new Result();
        result.categories = new Category[size];
        try {
            int i;
            BObject base = shell.getActiveOrdTarget().get();
            result.service = (BCategoryService)BOrd.make((String)"service:baja:CategoryService").get(base);
            result.service.lease(1);
            BCategory[] cats = result.service.getCategories();
            int max = 0;
            for (i = 0; i < cats.length; ++i) {
                max = Math.max(cats[i].getIndex(), max);
            }
            if (max >= result.categories.length) {
                result.categories = new Category[max + 1];
            }
            for (i = 0; i < cats.length; ++i) {
                BCategory cat = cats[i];
                if (!cat.getStatus().isOk()) continue;
                int index = cat.getIndex();
                result.categories[index] = new Category(index, (BAbstractCategory)cat);
            }
        }
        catch (Exception e) {
            result.service = null;
        }
        for (int i = 1; i < result.categories.length; ++i) {
            if (result.categories[i] != null) continue;
            result.categories[i] = new Category(i, null);
        }
        return result;
    }

    public Category(int index, BAbstractCategory category) {
        this.index = index;
        this.category = category;
        if (category == null) {
            this.display = lex.getText("category.generic", new Object[]{String.valueOf(index)});
        } else {
            this.display = category.getDisplayName(null);
            if (category.getType().is(BCategory.TYPE)) {
                this.mode = ((BCategory)category).getMode();
            }
        }
    }

    public static class Result {
        public BCategoryService service;
        public Category[] categories;
    }
}

