/*
 * Decompiled with CFR 0.152.
 */
package javax.bajax.analytics.time;

import com.tridiumx.analytics.time.TimeBinding;
import com.tridiumx.analytics.util.Utils;
import java.time.Instant;
import java.time.ZoneId;
import java.time.zone.ZoneOffsetTransition;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.time.Interval;

public final class BInterval
extends BFrozenEnum
implements Interval {
    public static final int NONE = 0;
    public static final int SECOND = 1;
    public static final int FIVE_SECONDS = 2;
    public static final int TEN_SECONDS = 3;
    public static final int FIFTEEN_SECONDS = 4;
    public static final int THIRTY_SECONDS = 5;
    public static final int MINUTE = 6;
    public static final int FIVE_MINUTES = 7;
    public static final int TEN_MINUTES = 8;
    public static final int FIFTEEN_MINUTES = 9;
    public static final int TWENTY_MINUTES = 10;
    public static final int THIRTY_MINUTES = 11;
    public static final int HOUR = 12;
    public static final int TWO_HOURS = 13;
    public static final int THREE_HOURS = 14;
    public static final int FOUR_HOURS = 15;
    public static final int SIX_HOURS = 16;
    public static final int TWELVE_HOURS = 17;
    public static final int DAY = 18;
    public static final int WEEK = 19;
    public static final int MONTH = 20;
    public static final int QUARTER = 21;
    public static final int YEAR = 22;
    public static final BInterval none = new BInterval(0);
    public static final BInterval second = new BInterval(1);
    public static final BInterval fiveSeconds = new BInterval(2);
    public static final BInterval tenSeconds = new BInterval(3);
    public static final BInterval fifteenSeconds = new BInterval(4);
    public static final BInterval thirtySeconds = new BInterval(5);
    public static final BInterval minute = new BInterval(6);
    public static final BInterval fiveMinutes = new BInterval(7);
    public static final BInterval tenMinutes = new BInterval(8);
    public static final BInterval fifteenMinutes = new BInterval(9);
    public static final BInterval twentyMinutes = new BInterval(10);
    public static final BInterval thirtyMinutes = new BInterval(11);
    public static final BInterval hour = new BInterval(12);
    public static final BInterval twoHours = new BInterval(13);
    public static final BInterval threeHours = new BInterval(14);
    public static final BInterval fourHours = new BInterval(15);
    public static final BInterval sixHours = new BInterval(16);
    public static final BInterval twelveHours = new BInterval(17);
    public static final BInterval day = new BInterval(18);
    public static final BInterval week = new BInterval(19);
    public static final BInterval month = new BInterval(20);
    public static final BInterval quarter = new BInterval(21);
    public static final BInterval year = new BInterval(22);
    public static final BInterval DEFAULT = none;
    public static final Type TYPE = Sys.loadType(BInterval.class);
    private ZoneId zoneId = ZoneId.of(TimeBinding.getTimeZone().getID());

    public static BInterval make(int ordinal) {
        return (BInterval)none.getRange().get(ordinal, false);
    }

    public static BInterval make(String tag) {
        return (BInterval)none.getRange().get(tag);
    }

    private BInterval(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public int count(long start, long end) {
        if (start < 0L || end < 0L) {
            return -1;
        }
        long delta = end - start;
        int type = this.getOrdinal();
        switch (type) {
            case 0: {
                return (int)delta;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return (int)(delta / this.millis());
            }
        }
        int ret = 0;
        if (start < end) {
            while (start < end) {
                ++ret;
                start = this.next(start);
            }
        } else {
            while (end < start) {
                ++ret;
                end = this.next(end);
            }
        }
        return ret;
    }

    @Override
    public long millis() {
        switch (this.getOrdinal()) {
            case 0: {
                return 1L;
            }
            case 1: {
                return 1000L;
            }
            case 2: {
                return 5000L;
            }
            case 3: {
                return 10000L;
            }
            case 4: {
                return 15000L;
            }
            case 5: {
                return 30000L;
            }
            case 6: {
                return 60000L;
            }
            case 7: {
                return 300000L;
            }
            case 8: {
                return 600000L;
            }
            case 9: {
                return 900000L;
            }
            case 10: {
                return 1200000L;
            }
            case 11: {
                return 1800000L;
            }
            case 12: {
                return 3600000L;
            }
            case 13: {
                return 0x6DDD00L;
            }
            case 14: {
                return 10800000L;
            }
            case 15: {
                return 14400000L;
            }
            case 16: {
                return 21600000L;
            }
            case 17: {
                return 43200000L;
            }
            case 18: {
                return 86400000L;
            }
            case 19: {
                return 604800000L;
            }
            case 20: {
                return 2592000000L;
            }
            case 21: {
                return 7776000000L;
            }
            case 22: {
                return 31104000000L;
            }
        }
        throw new IllegalStateException(Utils.lex("unknownInterval") + ": " + this.getOrdinal());
    }

    private int adjustH(long ts, int hours) {
        Instant ins = Instant.ofEpochMilli(ts);
        ZoneOffsetTransition zoneOffsetTransition = this.zoneId.getRules().nextTransition(ins);
        if (this.zoneId.getRules().nextTransition(ins) != null) {
            long nextChange = zoneOffsetTransition.toEpochSecond();
            boolean isDST = this.zoneId.getRules().isDaylightSavings(ins);
            long calcNextInterval = ts + (long)hours * 3600000L;
            if (!isDST && calcNextInterval / 1000L >= nextChange) {
                if ((calcNextInterval -= 3600000L) / 1000L >= nextChange) {
                    return hours - 1;
                }
                return 2 * hours - 1;
            }
            if (isDST && calcNextInterval / 1000L >= nextChange) {
                return hours + 1;
            }
        }
        return hours;
    }

    @Override
    public long next(long timestamp) {
        long ts = timestamp;
        switch (this.getOrdinal()) {
            case 0: {
                return ts + 1L;
            }
            case 1: {
                return ts + 1000L;
            }
            case 2: {
                return ts + 5000L;
            }
            case 3: {
                return ts + 10000L;
            }
            case 4: {
                return ts + 15000L;
            }
            case 5: {
                return ts + 30000L;
            }
            case 6: {
                return ts + 60000L;
            }
            case 7: {
                return ts + 300000L;
            }
            case 8: {
                return ts + 600000L;
            }
            case 9: {
                return ts + 900000L;
            }
            case 10: {
                return ts + 1200000L;
            }
            case 11: {
                return ts + 1800000L;
            }
            case 12: {
                return TimeBinding.addHours(1, ts);
            }
            case 13: {
                return TimeBinding.addHours(this.adjustH(ts, 2), ts);
            }
            case 14: {
                return TimeBinding.addHours(this.adjustH(ts, 3), ts);
            }
            case 15: {
                return TimeBinding.addHours(this.adjustH(ts, 4), ts);
            }
            case 16: {
                return TimeBinding.addHours(this.adjustH(ts, 6), ts);
            }
            case 17: {
                return TimeBinding.addHours(this.adjustH(ts, 12), ts);
            }
            case 18: {
                return TimeBinding.addDays(1, ts);
            }
            case 19: {
                return TimeBinding.addWeeks(1, ts);
            }
            case 20: {
                return TimeBinding.addMonths(1, ts);
            }
            case 21: {
                return TimeBinding.addMonths(3, ts);
            }
            case 22: {
                return TimeBinding.addYears(1, ts);
            }
        }
        throw new IllegalStateException(Utils.lex("unknownInterval") + ": " + this.getOrdinal());
    }

    public long previous(long timestamp) {
        long ts = timestamp;
        switch (this.getOrdinal()) {
            case 0: {
                return ts - 1L;
            }
            case 1: {
                return ts - 1000L;
            }
            case 2: {
                return ts - 5000L;
            }
            case 3: {
                return ts - 10000L;
            }
            case 4: {
                return ts - 15000L;
            }
            case 5: {
                return ts - 30000L;
            }
            case 6: {
                return ts - 60000L;
            }
            case 7: {
                return ts - 300000L;
            }
            case 8: {
                return ts - 600000L;
            }
            case 9: {
                return ts - 900000L;
            }
            case 10: {
                return ts - 1200000L;
            }
            case 11: {
                return ts - 1800000L;
            }
            case 12: {
                return TimeBinding.addHours(-1, ts);
            }
            case 13: {
                return TimeBinding.addHours(-2, ts);
            }
            case 14: {
                return TimeBinding.addHours(-3, ts);
            }
            case 15: {
                return TimeBinding.addHours(-4, ts);
            }
            case 16: {
                return TimeBinding.addHours(-6, ts);
            }
            case 17: {
                return TimeBinding.addHours(-12, ts);
            }
            case 18: {
                return TimeBinding.addDays(-1, ts);
            }
            case 19: {
                return TimeBinding.addWeeks(-1, ts);
            }
            case 20: {
                return TimeBinding.addMonths(-1, ts);
            }
            case 21: {
                return TimeBinding.addMonths(-3, ts);
            }
            case 22: {
                return TimeBinding.addYears(-1, ts);
            }
        }
        throw new IllegalStateException(Utils.lex("unknownInterval") + ": " + this.getOrdinal());
    }
}

