/*
 * Decompiled with CFR 0.152.
 */
package javax.bajax.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.trend.AbstractTrend;
import com.tridiumx.analytics.trend.IntervalTrend;
import com.tridiumx.analytics.util.Utils;
import java.util.logging.Level;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.Interval;

public abstract class BlockTrend
extends AbstractTrend {
    private static final int NULL_TS = -1;
    private long timestamp = -1L;
    private Source[] sources;

    private BlockTrend() {
    }

    public BlockTrend(AlgorithmBlock block, AnalyticContext cx) {
        super(cx);
        int len = block.getInputCount();
        this.sources = new Source[len];
        AlgorithmBlock[] inputs = new AlgorithmBlock[len];
        for (int i = 0; i < len; ++i) {
            AlgorithmBlock input;
            inputs[i] = input = block.getInput(i);
            if (input != null) {
                for (int j = 0; j < i; ++j) {
                    if (input != inputs[j]) continue;
                    this.sources[i] = new ProxySource(this.sources[j]);
                    break;
                }
            }
            if (this.sources[i] != null) continue;
            this.sources[i] = input == null ? new ValueSource(block.getInputDefault(i, cx)) : (input.hasTrend(cx) ? new TrendSource(input.getTrend(cx)) : new ValueSource(input.getValue(cx)));
        }
        this.init();
    }

    public boolean advance() {
        long last = this.timestamp;
        long latest = -1L;
        boolean done = false;
        while (!done) {
            done = true;
            int len = this.sources.length;
            for (int i = 0; i < len; ++i) {
                if (this.sources[i].isTrend()) {
                    AnalyticValue val = this.sources[i].getValue();
                    if (val == null) {
                        return false;
                    }
                    long cur = val.getTimestamp();
                    if (latest == -1L) {
                        latest = cur;
                    }
                    while (cur == last || cur < latest) {
                        if (!this.sources[i].next()) {
                            return false;
                        }
                        val = this.sources[i].getValue();
                        cur = val.getTimestamp();
                    }
                    if (cur <= latest) continue;
                    latest = cur;
                    if (i <= 0) continue;
                    done = false;
                    continue;
                }
                if (this.sources[i].isProxy()) continue;
                this.sources[i].getValue().setTimestamp(latest);
            }
        }
        this.timestamp = latest;
        return this.timestamp != -1L;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AnalyticValue getValue(int idx) {
        return this.sources[idx].getValue();
    }

    private void init() {
        int i;
        int length = this.sources.length;
        Object ivl = null;
        for (i = 0; i < length; ++i) {
            if (!this.sources[i].isTrend()) continue;
            Interval tivl = this.sources[i].getTrend().getContext().getInterval(true);
            if (ivl == null) {
                ivl = tivl;
                continue;
            }
            if (tivl == null || tivl.getOrdinal() <= ivl.getOrdinal()) continue;
            ivl = tivl;
        }
        if (ivl == null) {
            return;
        }
        if (!ivl.equals(this.getContext().getInterval(true))) {
            AnalyticContextWrapper cx = new AnalyticContextWrapper(this.getContext());
            cx.setInterval((Interval)ivl);
            this.setContext(cx);
        }
        for (i = 0; i < length; ++i) {
            if (!this.sources[i].isTrend()) continue;
            if (!ivl.equals(this.sources[i].getTrend().getContext().getInterval(true))) {
                AnalyticContextWrapper cx = new AnalyticContextWrapper(this.sources[i].getTrend().getContext());
                cx.setInterval((Interval)ivl);
                this.sources[i].setTrend(new IntervalTrend(this.sources[i].getTrend(), cx));
            }
            this.sources[i].next();
        }
    }

    @Override
    public void close() {
        try {
            if (this.sources != null) {
                for (int i = 0; i < this.sources.length; ++i) {
                    if (this.sources[i] == null || this.sources[i].getTrend() == null) continue;
                    this.sources[i].getTrend().close();
                }
            }
        }
        catch (Exception e) {
            Utils.log().log(Level.SEVERE, "Some objects could not be closed. There may be potential impact on memory. Try to restart the station if facing memory leak issues. Error: " + e.getMessage());
        }
    }

    private static class ValueSource
    implements Source {
        private AnalyticValue value;

        ValueSource(AnalyticValue value) {
            this.value = value;
        }

        @Override
        public AnalyticTrend getTrend() {
            throw new IllegalStateException(Utils.lex("notTrend"));
        }

        @Override
        public AnalyticValue getValue() {
            return this.value;
        }

        @Override
        public boolean isProxy() {
            return false;
        }

        @Override
        public boolean isTrend() {
            return false;
        }

        @Override
        public boolean next() {
            throw new IllegalStateException(Utils.lex("notTrend"));
        }

        @Override
        public void setTrend(AnalyticTrend trend) {
            throw new IllegalStateException(Utils.lex("notTrend"));
        }
    }

    private static class TrendSource
    implements Source {
        private AnalyticTrend trend;
        private AnalyticValue value;

        TrendSource(AnalyticTrend trend) {
            this.trend = trend;
        }

        @Override
        public AnalyticTrend getTrend() {
            return this.trend;
        }

        @Override
        public AnalyticValue getValue() {
            return this.value;
        }

        @Override
        public boolean isProxy() {
            return false;
        }

        @Override
        public boolean isTrend() {
            return true;
        }

        @Override
        public boolean next() {
            if (this.trend.hasNext()) {
                this.value = this.trend.next();
                return true;
            }
            this.value = null;
            return false;
        }

        @Override
        public void setTrend(AnalyticTrend trend) {
            this.trend = trend;
        }
    }

    private static class ProxySource
    implements Source {
        private Source source;

        ProxySource(Source source) {
            this.source = source;
        }

        @Override
        public AnalyticTrend getTrend() {
            throw new IllegalStateException(Utils.lex("notTrend"));
        }

        @Override
        public AnalyticValue getValue() {
            return this.source.getValue();
        }

        @Override
        public boolean isProxy() {
            return true;
        }

        @Override
        public boolean isTrend() {
            return false;
        }

        @Override
        public boolean next() {
            throw new IllegalStateException(Utils.lex("notTrend"));
        }

        @Override
        public void setTrend(AnalyticTrend trend) {
            throw new IllegalStateException(Utils.lex("notTrend"));
        }
    }

    private static interface Source {
        public AnalyticTrend getTrend();

        public AnalyticValue getValue();

        public boolean isProxy();

        public boolean isTrend();

        public boolean next();

        public void setTrend(AnalyticTrend var1);
    }
}

