/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.aon.Aobj;
import com.tridiumx.analytics.aon.Atypes;
import com.tridiumx.analytics.util.MessageException;
import com.tridiumx.analytics.util.StringUtils;
import com.tridiumx.analytics.ws.ApiMessage;
import com.tridiumx.analytics.ws.BNaServlet;
import com.tridiumx.analytics.ws.Encoder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import javax.baja.naming.OrdTarget;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.util.BTypeSpec;

class InvokeMessage
extends ApiMessage
implements Atypes {
    public InvokeMessage(Amap request, Context cx) {
        super(request, cx);
    }

    @Override
    protected Amap doGetResponse() {
        BValue res;
        Amap map = this.getRequest().copy().toMap();
        String node = this.getRequiredString(map, "node");
        String action = this.getRequiredString(map, "action");
        OrdTarget ot = this.resolveForInvoke(node);
        BComponent comp = ot.getComponent();
        Action act = comp.getAction(action);
        if (act == null) {
            return BNaServlet.makeError(map, "clientError", "Unknown action: " + action, null);
        }
        Aobj parms = map.get("parameter");
        BValue arg = Encoder.getActionParameter(comp, act);
        BFacets facets = comp.getSlotFacets((Slot)act);
        if (arg != null && parms != null) {
            try {
                arg = parms.isMap() ? InvokeMessage.decode(parms.copy().toMap(), arg.newCopy(true), facets) : InvokeMessage.decode(parms.toString(), arg.newCopy(true), facets);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if ((res = comp.invoke(act, arg, this.getContext())) != null) {
            if (res instanceof BSimple) {
                Encoder.encodeGraph(map.putMap("result"), (BSimple)res, facets);
            } else if (res instanceof BComplex) {
                Encoder.encodeGraph(map.putMap("result"), (BComplex)res, facets);
            }
        }
        return map;
    }

    private static BValue decode(Amap map, BValue obj, BFacets facets) throws Exception {
        BValue val;
        Aobj slot;
        String name;
        if (obj == null) {
            return InvokeMessage.decode(map, facets);
        }
        if (obj instanceof BComplex) {
            BComplex cpx = (BComplex)obj;
            SlotCursor cur = cpx.getProperties();
            while (cur.next()) {
                Property p = cur.property();
                name = p.getName();
                slot = map.get(name);
                if (slot == null) continue;
                map.remove(name);
                try {
                    BFacets fcts = BFacets.make((BFacets)facets, (BFacets)cpx.getSlotFacets((Slot)cur.property()));
                    val = cur.get().asValue().newCopy(true);
                    val = slot.isMap() ? InvokeMessage.decode(slot.toMap(), val, fcts) : InvokeMessage.decode(slot.toString(), val, fcts);
                    if (val == null) continue;
                    cpx.set(name, val);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        if (obj instanceof BComponent) {
            BComponent comp = (BComponent)obj;
            Iterator<String> it = map.iterator();
            while (it.hasNext()) {
                try {
                    name = it.next();
                    slot = map.get(name);
                    val = InvokeMessage.decode(slot, facets);
                    if (val == null) continue;
                    comp.add(name, val);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        return obj;
    }

    private static BValue decode(Aobj arg, BFacets facets) throws Exception {
        if (arg.isMap()) {
            BTypeSpec spec2;
            BValue proto = null;
            Amap map = arg.toMap();
            String type = map.get("typespec", null);
            if (type != null) {
                try {
                    spec2 = BTypeSpec.make((String)type);
                    proto = (BValue)spec2.getResolvedType().getInstance();
                }
                catch (Exception spec2) {
                    // empty catch block
                }
            }
            if (proto == null && (type = map.get("type", null)) != null) {
                try {
                    spec2 = BTypeSpec.make((String)type);
                    proto = (BValue)spec2.getResolvedType().getInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (proto == null) {
                    try {
                        proto = (BValue)Class.forName(type).newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (proto == null && (type = map.get("class", null)) != null) {
                try {
                    proto = (BValue)Class.forName(type).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (proto != null) {
                return InvokeMessage.decode(map, proto, facets);
            }
            return null;
        }
        switch (arg.getTypeCode()) {
            case 0: {
                return BBoolean.make((boolean)arg.toBoolean());
            }
            case 1: {
                return BDouble.make((double)arg.toDouble());
            }
            case 2: {
                return BInteger.make((int)arg.toInt());
            }
            case 4: {
                return BLong.make((long)arg.toLong());
            }
            case 7: {
                return BString.make((String)arg.toString());
            }
        }
        return null;
    }

    private static BValue decode(String val, BValue proto, BFacets facets) throws Exception {
        if (proto instanceof BStatusValue) {
            return InvokeMessage.decodeStatusValue(val, (BStatusValue)proto, facets);
        }
        if (val == null) {
            if (proto instanceof BSimple) {
                return proto;
            }
            return null;
        }
        Class<?> c = proto.getClass();
        if (val.equalsIgnoreCase("null")) {
            Object ret;
            Field f2;
            try {
                f2 = c.getField("null");
                if (f2 != null && Modifier.isPublic(f2.getModifiers()) && (ret = f2.get(proto)) != null) {
                    return (BValue)ret;
                }
            }
            catch (Exception f2) {
                // empty catch block
            }
            try {
                f2 = c.getField("NULL");
                if (f2 != null && Modifier.isPublic(f2.getModifiers()) && (ret = f2.get(proto)) != null) {
                    return (BValue)ret;
                }
            }
            catch (Exception f3) {}
        } else {
            Object ret;
            try {
                Method m = c.getMethod("make", String.class);
                if (m != null && (ret = m.invoke((Object)proto, val)) != null) {
                    return (BValue)ret;
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            try {
                Constructor<?> init = c.getConstructor(String.class);
                if (init != null && (ret = init.newInstance(val)) != null) {
                    return (BValue)ret;
                }
            }
            catch (Exception init) {
                // empty catch block
            }
        }
        if (proto instanceof BEnum) {
            BEnum ret = InvokeMessage.decodeEnum(val, facets);
            if (ret == null) {
                ret = InvokeMessage.decodeEnum(val, ((BEnum)proto).getEnumFacets());
            }
            if (ret != null) {
                if (proto instanceof BDynamicEnum) {
                    ret = BDynamicEnum.make((BEnum)ret);
                }
                return ret;
            }
        }
        if (proto instanceof BBoolean) {
            String txt = facets.gets("trueText", null);
            if (txt != null && val.equalsIgnoreCase(txt)) {
                return BBoolean.TRUE;
            }
            txt = facets.gets("falseText", null);
            if (txt != null && val.equalsIgnoreCase(txt)) {
                return BBoolean.FALSE;
            }
        }
        if (proto instanceof BSimple) {
            return (BValue)((BSimple)proto).decodeFromString(val);
        }
        throw new MessageException("Could not decode: " + val);
    }

    private static BEnum decodeEnum(String val, BFacets facets) {
        BEnumRange r = (BEnumRange)facets.get("range");
        if (r != null) {
            BEnum e = null;
            int[] ints = r.getOrdinals();
            int i = ints.length;
            while (--i >= 0) {
                e = r.get(ints[i]);
                if (!e.getDisplayTag(null).equals(val)) continue;
                return e;
            }
            if (r.isTag(val)) {
                return r.get(val);
            }
            i = ints.length;
            while (--i >= 0) {
                e = r.get(ints[i]);
                if (e.getDisplayTag(null).equalsIgnoreCase(val)) {
                    return e;
                }
                if (!e.getTag().equalsIgnoreCase(val)) continue;
                return e;
            }
        }
        try {
            return BDynamicEnum.make((int)Integer.parseInt(val));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static BStatusValue decodeStatusValue(String val, BStatusValue proto, BFacets facets) {
        if (val == null || val.equalsIgnoreCase("null")) {
            BStatusValue b = (BStatusValue)proto.newCopy(true);
            b.setStatus(BStatus.nullStatus);
            return b;
        }
        if (proto instanceof BStatusBoolean) {
            if (val.equalsIgnoreCase("true")) {
                return new BStatusBoolean(true);
            }
            if (val.equalsIgnoreCase("false")) {
                return new BStatusBoolean(false);
            }
            String txt = facets.gets("trueText", null);
            if (txt != null && val.equalsIgnoreCase(txt)) {
                return new BStatusBoolean(true);
            }
            txt = facets.gets("falseText", null);
            if (txt != null && val.equalsIgnoreCase(txt)) {
                return new BStatusBoolean(false);
            }
            throw new IllegalArgumentException("Could not parse boolean: " + val);
        }
        if (proto instanceof BStatusNumeric) {
            double v;
            double d = Double.parseDouble(val = StringUtils.getNumber(val));
            if (d < (v = facets.getd("min", Double.MIN_VALUE))) {
                throw new IllegalArgumentException(d + " is less than " + v);
            }
            v = facets.getd("max", Double.MAX_VALUE);
            if (d > v) {
                throw new IllegalArgumentException(d + " is greater than " + v);
            }
            return new BStatusNumeric(d);
        }
        if (proto instanceof BStatusEnum) {
            BEnum e = InvokeMessage.decodeEnum(val, facets);
            if (e == null) {
                throw new IllegalArgumentException("Unrecognized enum tag: " + val);
            }
            if (((BStatusEnum)proto).getEnum() instanceof BDynamicEnum) {
                e = BDynamicEnum.make((BEnum)e);
            }
            return new BStatusEnum(e);
        }
        return new BStatusString(val);
    }
}

