/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import com.tridium.data.BDataTable;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.hier.BHierNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BHierarchySpace;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.HierarchyQuery;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combiner;

public class Utils {
    public static final List<String> STATUS_LIST = Arrays.asList("active", "Active", "on", "On", "true", "True", "1");
    public static final BIcon iconAlert = BIcon.std((String)"warning.png");
    public static final BIcon iconAlgorithm = BIcon.std((String)"gears.png");
    public static final BIcon iconDefinition = BIcon.std((String)"library.png");
    public static final BIcon iconPoller = BIcon.std((String)"clock.png");
    private static final double EPSILON = 1.0E-6;
    public static final BFacets timeFacets = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    private static BHierarchyService hierSvc;
    private static Lexicon lex;
    private static Logger log;

    public static int countToTrue(AnalyticTrend trend) {
        boolean curVal = false;
        boolean lastVal = false;
        int count = 0;
        while (trend.hasNext()) {
            AnalyticValue val = trend.next();
            curVal = false;
            if (val.toBoolean() && Values.isValid(val.getStatus())) {
                curVal = true;
            }
            if (curVal && !lastVal) {
                ++count;
            }
            lastVal = curVal;
        }
        return count;
    }

    public static BOrd getNodeOrd(BObject node) {
        if (node instanceof BINavNode) {
            return Utils.getNodeOrd((BINavNode)node);
        }
        return BOrd.NULL;
    }

    public static final boolean hasOperatorRead(BINavNode node, Context cx) {
        try {
            if (cx == null || cx.getUser() == null) {
                return true;
            }
            BComponent tgt = null;
            if (node instanceof BLevelElem) {
                tgt = ((BLevelElem)node).getTargetComponent();
            } else if (node instanceof BHierNode) {
                tgt = ((BHierNode)node).getTarget();
            }
            if (tgt != null) {
                node = tgt;
            }
            if (!(node instanceof BIProtected)) {
                return true;
            }
            BPermissions p = ((BIProtected)node).getPermissions(cx);
            if (p.has(1)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static final BINavNode[] filter(BINavNode[] nodes, Context cx) {
        try {
            if (cx == null || cx.getUser() == null) {
                return nodes;
            }
            ArrayList<BINavNode> acc = new ArrayList<BINavNode>(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                BPermissions p;
                BINavNode node = nodes[i];
                BComponent tgt = null;
                if (node instanceof BLevelElem) {
                    tgt = ((BLevelElem)node).getTargetComponent();
                } else if (node instanceof BHierNode) {
                    tgt = ((BHierNode)node).getTarget();
                }
                if (tgt != null) {
                    node = tgt;
                }
                if (node instanceof BIProtected && !(p = ((BIProtected)node).getPermissions(cx)).has(1)) continue;
                acc.add(nodes[i]);
            }
            return acc.toArray(new BINavNode[acc.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return nodes;
        }
    }

    public static BOrd getNodeOrd(BINavNode node) {
        BOrd ord = null;
        if (node instanceof BLevelElem && !(ord = ((BLevelElem)node).getHierarchyOrd()).isNull()) {
            return ord;
        }
        if (node instanceof BHierNode && !(ord = node.getNavOrd()).isNull()) {
            return ord;
        }
        if (node instanceof BHierarchySpace && !(ord = ((BHierarchySpace)node).getOrdInSession()).isNull()) {
            return ord;
        }
        if (node instanceof BComponent && !(ord = node.getNavOrd().relativizeToSession()).isNull()) {
            return ord;
        }
        return node.getNavOrd();
    }

    public static BINavNode getProxyTarget(BINavNode node) {
        BComponent tmp;
        if (node instanceof BLevelElem && (tmp = ((BLevelElem)node).getTargetComponent()) != null) {
            return tmp;
        }
        if (node instanceof BHierNode && (tmp = ((BHierNode)node).getTarget()) != null) {
            return tmp;
        }
        return node;
    }

    public static boolean isEnded(long ts, long end) {
        if (end < 0L) {
            return false;
        }
        return ts >= end;
    }

    public static boolean isProxyNode(BObject node) {
        if (node instanceof BLevelElem) {
            return true;
        }
        return node instanceof BHierNode;
    }

    public static String lex(String key) {
        String ret = lex.getText(key);
        if (ret == null || ret.length() == 0 || ret.equals(key)) {
            int idx = key.lastIndexOf(46);
            if (idx > 0) {
                key = key.substring(++idx);
            }
            return TextUtil.toFriendly((String)key);
        }
        return ret;
    }

    public static String lex(String key, Object[] args) {
        String ret = lex.getText(key, args);
        if (ret == null || ret.length() == 0 || ret.equals(key)) {
            int idx = key.lastIndexOf(46);
            if (idx > 0) {
                key = key.substring(++idx);
            }
            return TextUtil.toFriendly((String)key);
        }
        return ret;
    }

    public static Logger log() {
        return log;
    }

    public static AnalyticValue rollup(AnalyticTrend trend) {
        AnalyticValue val;
        long end = trend.getContext().getEndTime();
        Combiner rollup = trend.getContext().getRollup(true).makeCombiner();
        while (trend.hasNext() && !Utils.isEnded((val = trend.next()).getTimestamp(), end)) {
            rollup.update(val);
        }
        return rollup.getValue();
    }

    public static BINavNode resolveNode(OrdTarget ot) {
        BObject ret = ot.get();
        try {
            OrdQuery[] q = ot.getOrdQueries();
            if (q == null || q.length == 0) {
                return (BINavNode)ret;
            }
            OrdQuery query = q[q.length - 1];
            if (query.getScheme().equals("hierarchy")) {
                if (ret instanceof BLevelElem) {
                    return (BINavNode)ret;
                }
                if (ret instanceof BHierarchySpace) {
                    return (BINavNode)ret;
                }
                BLevelElem e = Utils.resolveElem(query.getBody());
                if (e != null) {
                    return e;
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return (BINavNode)ret;
    }

    public static String resolveNode(OrdTarget ot, String refScheme) {
        OrdQuery targetQuery = null;
        try {
            OrdQuery[] qList;
            for (OrdQuery q : qList = ot.getOrdQueries()) {
                if (refScheme.equals(q.getScheme())) break;
                targetQuery = q;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (targetQuery != null) {
            return targetQuery.toString();
        }
        throw new IllegalArgumentException("Base improper for analytic ord scheme : " + refScheme);
    }

    public static BINavNode resolveNode(String str, BObject base) {
        BOrd o = BOrd.make((String)str);
        if (base == null) {
            base = Sys.getStation();
        }
        OrdTarget ot = o.resolve(base);
        return Utils.resolveNode(ot);
    }

    public static long runtimeMillis(AnalyticTrend trend) {
        AnalyticValue val;
        long curTs;
        boolean curVal = false;
        long lastTs = -1L;
        boolean lastVal = false;
        long runtime = 0L;
        long end = trend.getContext().getEndTime();
        while (trend.hasNext() && (curTs = (val = trend.next()).getTimestamp()) <= end) {
            curVal = false;
            if (val.toBoolean() && Values.isValid(val.getStatus())) {
                curVal = true;
            }
            if (lastTs > 0L && lastVal) {
                runtime += curTs - lastTs;
            }
            lastTs = curTs;
            lastVal = curVal;
        }
        return runtime;
    }

    private static BLevelElem resolveElem(String path) {
        if (hierSvc == null) {
            hierSvc = (BHierarchyService)Sys.getService((Type)BHierarchyService.TYPE);
        }
        return hierSvc.resolveHierarchyLevelElem(new HierarchyQuery(path));
    }

    public static final String prepareDebugMessage(String origin, String data, String node, String alg, String user) {
        StringBuilder debugTrace = new StringBuilder();
        if (origin != null && !origin.isEmpty()) {
            debugTrace.append("\norigin - " + origin.trim());
        }
        if (data != null && !data.isEmpty()) {
            debugTrace.append("\ndata - " + data);
        }
        if (node != null && !node.isEmpty()) {
            debugTrace.append("\nnode - " + node);
        }
        if (alg != null && !alg.isEmpty()) {
            debugTrace.append("\nalgorithm - " + alg);
        }
        if (user != null && !user.isEmpty()) {
            debugTrace.append("\nuser - " + user);
        }
        if (debugTrace.length() > 0) {
            debugTrace.append("\n");
        }
        debugTrace.trimToSize();
        return debugTrace.toString();
    }

    public static BFacets adjustUnits(AnalyticContext cx, BUnit unit, BFacets facets) {
        if (facets != null) {
            if (unit != null && unit.isNull()) {
                facets = BFacets.makeRemove((BFacets)facets, (String)"units");
            } else if (cx.getAggregation(false) == BCombination.count) {
                facets = BFacets.makeRemove((BFacets)facets, (String)"units");
            } else if (cx.getRollup(false) == BCombination.count) {
                facets = BFacets.makeRemove((BFacets)facets, (String)"units");
            }
        }
        return facets;
    }

    public static BObject dummyTable(BDataTable ret, BFacets facets) {
        ret.addColumn("timestamp", "Timestamp", BAbsTime.DEFAULT.getType(), 0, timeFacets);
        BDouble bval = BDouble.DEFAULT;
        ret.addColumn("value", "Value", bval.toDataValue().getType(), 0, facets);
        ret.addColumn("status", "Status", BStatus.ok.toDataValue().getType(), 0, BFacets.NULL);
        return ret;
    }

    public static boolean isEqualTo(double doubleValue1, double doubleValue2) {
        return Math.abs(doubleValue1 - doubleValue2) < 1.0E-6;
    }

    public static boolean isEqualTo(double doubleValue1, double doubleValue2, double toleranceValue) {
        return Math.abs(doubleValue1 - doubleValue2) < toleranceValue;
    }

    static {
        lex = Lexicon.make(Utils.class);
        log = Logger.getLogger("analytics");
    }
}

