/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.algorithm.outlier.BRawDataFilter;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.trend.AbstractTrend;
import com.tridiumx.analytics.trend.AbstractTrendWrapper;
import com.tridiumx.analytics.trend.StatusFilterTrend;
import java.util.logging.Logger;
import javax.baja.history.BRolloverValue;
import javax.baja.sys.BRelTime;
import javax.bajax.analytics.data.AnalyticValue;

public class RawDataFilterTrend
extends AbstractTrendWrapper {
    public static final Logger logger = Logger.getLogger("RawDataFilter");
    private BRolloverValue highLimit;
    private BRolloverValue lowLimit;
    private boolean highLimitUnspecified;
    private boolean lowLimitUnspecified;
    private static boolean warningLogged = false;
    private double highLimitValue;
    private double lowLimitValue;
    protected AnalyticValue row;

    public RawDataFilterTrend(AbstractTrend trend) {
        super(trend);
        if (trend.getContext() != null) {
            BRawDataFilter rawDataFilter = trend.getContext().getRawDataFilter();
            this.highLimit = rawDataFilter.getHighLimit();
            this.lowLimit = rawDataFilter.getLowLimit();
            this.highLimitUnspecified = this.highLimit.getUnspecified();
            this.lowLimitUnspecified = this.lowLimit.getUnspecified();
            if (!this.highLimitUnspecified) {
                this.highLimitValue = this.highLimit.getValue();
            }
            if (!this.lowLimitUnspecified) {
                this.lowLimitValue = this.lowLimit.getValue();
            }
            if (!this.highLimitUnspecified && !this.lowLimitUnspecified && this.highLimitValue < this.lowLimitValue) {
                logger.warning("High Limit value of the Raw Data Filter is less than the Low Limit value. Change the limits for correct data ");
            }
        }
    }

    @Override
    protected AnalyticValue getNext() {
        if (!this.trend.hasNext()) {
            return null;
        }
        this.row = this.trend.next();
        if (!(this.row instanceof NumericValue)) {
            if (!warningLogged) {
                logger.warning("Raw Data Filter can only be applied to Numeric values");
                warningLogged = true;
            }
            return this.row;
        }
        double rowValue = this.row.toNumeric();
        while (this.row != null && !Values.isValidRange(rowValue, this.highLimitUnspecified, this.lowLimitUnspecified, this.highLimitValue, this.lowLimitValue)) {
            this.row = null;
            if (!this.trend.hasNext()) break;
            this.row = this.trend.next();
            rowValue = this.row.toNumeric();
        }
        return this.row;
    }

    public BRelTime getInterval() {
        return ((StatusFilterTrend)this.trend).getInterval();
    }
}

