/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.data.UnitConverter;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.time.TimeZoneConverter;
import com.tridiumx.analytics.trend.AbstractTrend;
import com.tridiumx.analytics.util.Histories;
import com.tridiumx.analytics.util.Utils;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BCovHistoryExt;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.tag.Entity;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticValue;

public class NiagaraTrend
extends AbstractTrend {
    private static final BDouble one = BDouble.make((double)1.0);
    private static final byte skipBits = 6;
    private AnalyticValue afterPre;
    private AnalyticValue cache;
    private AnalyticNumeric cacheNumeric;
    private Column colVal;
    private Column colSts;
    private Column colTf;
    private Column colTs;
    private TableCursor<BHistoryRecord> cursor;
    private BIHistory history;
    private boolean isCount = false;
    private long lastTimestamp = -1L;
    private AnalyticValue preRecord;
    private TimeZoneConverter tzConvert;
    private UnitConverter unitConvert;
    private int yieldCount;

    public NiagaraTrend(BHistoryId history, AnalyticContext cx) {
        this(Histories.getHistory(history, cx), cx);
    }

    public NiagaraTrend(BIHistory history, AnalyticContext cx) {
        super(cx);
        try {
            BUnit unit;
            BFacets facets;
            cx = new AnalyticContextWrapper(cx);
            this.history = history;
            TimeZoneConverter startConvert = null;
            if (cx.getNormalizeTime()) {
                TimeZone local = TimeZone.getDefault();
                cx.setTimeZone(local);
                BTimeZone btz = history.getConfig().getTimeZone();
                if (btz != null) {
                    TimeZone tz = btz.getJavaTimeZone();
                    this.tzConvert = TimeZoneConverter.make(tz, local);
                    startConvert = TimeZoneConverter.make(local, tz);
                }
            }
            if ((facets = (BFacets)history.getConfig().get("valueFacets")) != null && (unit = (BUnit)facets.get("units")) != null) {
                this.unitConvert = UnitConverter.make(unit, cx.getUnit(true));
            }
            HistoryDatabaseConnection db = Histories.getDbConnection(cx);
            BAbsTime bstart = null;
            BAbsTime bendTime = null;
            long start = cx.getStartTime();
            long end = cx.getEndTime();
            if (startConvert != null) {
                start = startConvert.convert(start);
                end = startConvert.convert(end);
            }
            if (start > 0L) {
                bstart = BAbsTime.make((long)start);
            }
            if (end > 0L) {
                bendTime = BAbsTime.make((long)end);
            }
            BITable table = db.timeQuery(history, bstart, bendTime);
            ColumnList list = table.getColumns();
            this.colVal = list.get("value");
            this.colSts = list.get("status");
            this.colTs = list.get("timestamp");
            this.colTf = list.get("trendFlags");
            this.cursor = table.cursor();
            if (this.isCov()) {
                this.tryCovStart(start);
            }
            this.isCount = cx.getAggregation(true).getOrdinal() == 2;
        }
        catch (Exception x) {
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new RuntimeException(x);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
            if (this.history != null) {
                this.history.close();
                this.history = null;
            }
        }
        catch (Exception e) {
            Utils.log().log(Level.SEVERE, "Some objects could not be closed. There may be potential impact on memory. Try to restart the station if facing memory leak issues. Error: " + e.getMessage());
        }
        super.finalize();
    }

    public boolean isCov() {
        BHistoryConfig cfg;
        BFacets facets;
        Predicate<Entity> test = BAnalyticService.getInstance().getCovTest();
        if (test != null) {
            BINavNode nav = this.cx.getNode();
            if (nav instanceof Entity && test.test((Entity)nav)) {
                return true;
            }
            if (test.test((Entity)this.history.getConfig())) {
                return true;
            }
        }
        if ((facets = (BFacets)(cfg = this.history.getConfig()).get("valueFacets")) != null && facets.getb("useDelta", false)) {
            return true;
        }
        if (cfg.getInterval().isIrregular()) {
            try {
                BObject o = cfg.getSourceHandle().get((BObject)Sys.getStation());
                if (o instanceof BCovHistoryExt) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public BRelTime getInterval() {
        BHistoryConfig cfg = this.history.getConfig();
        if (!cfg.getInterval().isIrregular()) {
            return cfg.getInterval().getInterval();
        }
        return BRelTime.DEFAULT;
    }

    public boolean isTotalized() {
        Predicate<Entity> test = BAnalyticService.getInstance().getTotalizationTest();
        if (test != null && !test.toString().isEmpty()) {
            BINavNode nav = this.cx.getNode();
            if (nav instanceof Entity && test.test((Entity)nav)) {
                return true;
            }
            if (test.test((Entity)this.history.getConfig())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected AnalyticValue getNext() {
        if (this.preRecord != null) {
            AnalyticValue tmp = this.preRecord;
            this.preRecord = null;
            return tmp;
        }
        if (this.afterPre != null) {
            AnalyticValue tmp = this.afterPre;
            this.afterPre = null;
            return tmp;
        }
        if (this.cursor == null) {
            return null;
        }
        try {
            BAbsTime ts = null;
            int statusBits = 0;
            long timestamp = 0L;
            BIObject value = null;
            while (this.cursor.next()) {
                BTrendFlags flags;
                byte bits;
                if (++this.yieldCount % 100 == 0) {
                    Thread.yield();
                }
                ts = (BAbsTime)this.cursor.cell(this.colTs);
                timestamp = ts.getMillis();
                if (this.lastTimestamp >= 0L && timestamp < this.lastTimestamp || this.colTf != null && ((bits = (flags = (BTrendFlags)this.cursor.cell(this.colTf)).getBits()) & 6) != 0) continue;
                if (this.tzConvert != null) {
                    timestamp = this.tzConvert.convert(timestamp);
                }
                this.lastTimestamp = timestamp;
                value = this.cursor.cell(this.colVal);
                if (this.colSts != null) {
                    statusBits |= Values.getStatusBits(this.cursor.cell(this.colSts));
                }
                if (this.cache == null) {
                    this.cache = Values.make(value);
                    if (this.cache instanceof AnalyticNumeric) {
                        this.cacheNumeric = (AnalyticNumeric)this.cache;
                    }
                }
                if (this.isCount) {
                    this.cache.setValue(one);
                } else if (this.unitConvert != null) {
                    if (this.cacheNumeric != null) {
                        this.cacheNumeric.setValue(this.unitConvert.convert(Values.getNumeric(value)));
                    } else {
                        double d = this.unitConvert.convert(Values.getNumeric(value));
                        this.cache.setValue(BDouble.make((double)d));
                    }
                } else {
                    this.cache.setValue(value);
                }
                this.cache.setTimestamp(timestamp);
                this.cache.setStatus(statusBits);
                return this.cache;
            }
        }
        catch (Exception x) {
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new RuntimeException(x);
        }
        return null;
    }

    public AnalyticValue getPreRecord() {
        try {
            BTrendRecord rec = (BTrendRecord)HistoryCursor.extractPreRecord((BFacets)this.cursor.getContext().getFacets());
            return this.getAnalyticRecord(rec);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private AnalyticValue getAnalyticRecord(BTrendRecord rec) {
        if (rec == null) {
            return null;
        }
        if ((rec.getTrendFlags().getBits() & 6) != 0) {
            return null;
        }
        AnalyticValue ret = AnalyticValue.make(rec);
        if (this.tzConvert != null) {
            ret.setTimestamp(this.tzConvert.convert(ret.getTimestamp()));
        }
        if (this.unitConvert != null) {
            ret.setValue(BDouble.make((double)this.unitConvert.convert(ret.toNumeric())));
        }
        return ret;
    }

    public AnalyticValue getPostRecord() {
        try {
            BTrendRecord rec = (BTrendRecord)HistoryCursor.extractPostRecord((BFacets)this.cursor.getContext().getFacets());
            return this.getAnalyticRecord(rec);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getHistoryName() {
        String histName = "--unknown--";
        if (this.history != null) {
            histName = this.history.getConfig().getHistoryName();
        }
        return histName;
    }

    private NiagaraTrend tryCovStart(long start) {
        if (this.cursor == null) {
            return this;
        }
        this.afterPre = this.getNext();
        if (this.afterPre != null) {
            if (this.afterPre.getTimestamp() > start) {
                this.preRecord = this.getPreRecord();
                if (this.preRecord == null) {
                    return this;
                }
                if (this.preRecord.getTimestamp() < start) {
                    this.preRecord.setTimestamp(start);
                }
            }
        } else {
            this.preRecord = this.getPreRecord();
            if (this.preRecord == null) {
                return this;
            }
            if (this.preRecord.getTimestamp() < start) {
                this.preRecord.setTimestamp(start);
            }
        }
        return this;
    }
}

