/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.time;

import com.tridiumx.analytics.time.Duration;
import com.tridiumx.analytics.util.Utils;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.bajax.analytics.AnalyticConstants;

public class TimeBinding
implements AnalyticConstants {
    private static final int[] daysInMonth = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int SUN = 1;
    public static final int MON = 2;
    public static final int TUE = 3;
    public static final int WED = 4;
    public static final int THU = 5;
    public static final int FRI = 6;
    public static final int SAT = 7;
    public static final int JAN = 1;
    public static final int FEB = 2;
    public static final int MAR = 3;
    public static final int APR = 4;
    public static final int MAY = 5;
    public static final int JUN = 6;
    public static final int JUL = 7;
    public static final int AUG = 8;
    public static final int SEP = 9;
    public static final int OCT = 10;
    public static final int NOV = 11;
    public static final int DEC = 12;
    private static final int MS_MN = 60000;
    private static final int MS_HR = 3600000;
    public static final long NULL = 0L;
    private static ThreadLocal<CalendarCache> cache = new ThreadLocal<CalendarCache>(){

        @Override
        protected synchronized CalendarCache initialValue() {
            return new CalendarCache();
        }
    };

    public static GregorianCalendar get() {
        CalendarCache cc = cache.get();
        return cc.get();
    }

    public static GregorianCalendar get(long ts) {
        CalendarCache cc = cache.get();
        return cc.get(ts);
    }

    public static long make(int year, int month, int day) {
        GregorianCalendar c = TimeBinding.get();
        TimeZone tz = c.getTimeZone();
        c.clear();
        c.setTimeZone(tz);
        c.set(year, month, day);
        return c.getTimeInMillis();
    }

    public static long make(int yr, int mo, int day, int hr) {
        GregorianCalendar c = TimeBinding.get();
        TimeZone tz = c.getTimeZone();
        c.clear();
        c.setTimeZone(tz);
        c.set(yr, mo, day, hr, 0);
        return c.getTimeInMillis();
    }

    public static long make(int yr, int mo, int day, int hr, int mn) {
        GregorianCalendar c = TimeBinding.get();
        TimeZone tz = c.getTimeZone();
        c.clear();
        c.setTimeZone(tz);
        c.set(yr, mo, day, hr, mn);
        return c.getTimeInMillis();
    }

    public static long make(int yr, int mo, int day, int hr, int mn, int s) {
        GregorianCalendar c = TimeBinding.get();
        TimeZone tz = c.getTimeZone();
        c.clear();
        c.setTimeZone(tz);
        c.set(yr, mo, day, hr, mn, s);
        return c.getTimeInMillis();
    }

    public static Calendar make(String s) {
        char[] c = s.toCharArray();
        try {
            char sign;
            int i = 0;
            int year = (c[i++] - 48) * 1000 + (c[i++] - 48) * 100 + (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '-') {
                throw new Exception();
            }
            int mon = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '-') {
                throw new Exception();
            }
            int day = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != 'T') {
                throw new Exception();
            }
            int hour = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int min = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int sec = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            int ms = 0;
            if (c.length > i && c[i] == '.') {
                int n = ++i;
                ms = (c[n] - 48) * 100;
                if ('0' <= c[++i] && c[i] <= '9') {
                    ms += (c[i++] - 48) * 10;
                }
                if ('0' <= c[i] && c[i] <= '9') {
                    ms += (c[i++] - 48) * 1;
                }
                while (i < c.length && '0' <= c[i] && c[i] <= '9') {
                    ++i;
                }
            }
            int tzOff = 0;
            if ((sign = c[i++]) != 'Z') {
                if (sign != '+' && sign != '-') {
                    throw new Exception();
                }
                int hrOff = c[i++] - 48;
                if (i < c.length && c[i] != ':') {
                    hrOff = hrOff * 10 + c[i++] - 48;
                }
                int minOff = 0;
                if (i < c.length) {
                    if (c[i++] != ':') {
                        throw new Exception();
                    }
                    minOff = 10 * (c[i++] - 48) + c[i++] - 48;
                }
                tzOff = hrOff * 3600000 + minOff * 60000;
                if (sign == '-') {
                    tzOff *= -1;
                }
            }
            GregorianCalendar cal = TimeBinding.get();
            cal.set(year, mon - 1, day, hour, min, sec);
            cal.set(14, ms);
            ((Calendar)cal).setTimeZone(new SimpleTimeZone(tzOff, "Offset"));
            return cal;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(Utils.lex("invalidTime") + ": " + s);
        }
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static int getDay(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(5);
    }

    public static int getHour12(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(10);
    }

    public static int getHour24(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(11);
    }

    public static int getMillisecond(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(14);
    }

    public static int getMinute(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(12);
    }

    public static int getMonth(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(2) + 1;
    }

    public static int getSecond(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(13);
    }

    public static TimeZone getTimeZone() {
        GregorianCalendar c = TimeBinding.get();
        return ((Calendar)c).getTimeZone();
    }

    public static int getYear(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(1);
    }

    public static long setDay(int arg, long ts) {
        if (arg < 0 || arg > 31) {
            throw new IllegalArgumentException("Invalid day: " + arg);
        }
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(5, arg);
        return c.getTimeInMillis();
    }

    public static long setHour(int arg, long ts) {
        if (arg < 0 || arg > 23) {
            throw new IllegalArgumentException("Invalid hour: " + arg);
        }
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(11, arg);
        return c.getTimeInMillis();
    }

    public static long setMillisecond(int arg, long ts) {
        if (arg < 0 || arg > 999) {
            throw new IllegalArgumentException("Invalid millisecond: " + arg);
        }
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(14, arg);
        return c.getTimeInMillis();
    }

    public static long setMinute(int arg, long ts) {
        if (arg < 0 || arg > 59) {
            throw new IllegalArgumentException("Invalid minute: " + arg);
        }
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(12, arg);
        return c.getTimeInMillis();
    }

    public static long setMonth(int arg, long ts) {
        if (arg < 1 || arg > 12) {
            throw new IllegalArgumentException("Invalid month: " + arg);
        }
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(2, arg - 1);
        return c.getTimeInMillis();
    }

    public static long setSecond(int arg, long ts) {
        if (arg < 0 || arg > 59) {
            throw new IllegalArgumentException("Invalid second: " + arg);
        }
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(13, arg);
        return c.getTimeInMillis();
    }

    public static long setYear(int arg, long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(1, arg);
        return c.getTimeInMillis();
    }

    public static long add(Duration d, long ts) {
        if (d == null) {
            return ts;
        }
        if (d.isNegative()) {
            return TimeBinding.subtract(d, ts);
        }
        GregorianCalendar c = TimeBinding.get(ts);
        if (d.getYears() > 0) {
            c.add(1, d.getYears());
        }
        if (d.getMonths() > 0) {
            c.add(2, d.getMonths());
        }
        if (d.getDays() > 0) {
            c.add(5, d.getDays());
        }
        if (d.getHours() > 0) {
            c.add(10, d.getHours());
        }
        if (d.getMinutes() > 0) {
            c.add(12, d.getMinutes());
        }
        if (d.getSeconds() > 0) {
            c.add(13, d.getSeconds());
        }
        if (d.getMillis() > 0) {
            c.add(14, d.getMillis());
        }
        return c.getTimeInMillis();
    }

    public static long addDays(int arg, long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.add(5, arg);
        return c.getTimeInMillis();
    }

    public static long addHours(int arg, long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.add(11, arg);
        return c.getTimeInMillis();
    }

    public static long addMinutes(int arg, long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.add(12, arg);
        return c.getTimeInMillis();
    }

    public static long addMillis(int arg, long ts) {
        return ts + (long)arg;
    }

    public static long addMonths(int arg, long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.add(2, arg);
        return c.getTimeInMillis();
    }

    public static long addSeconds(int arg, long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.add(13, arg);
        return c.getTimeInMillis();
    }

    public static long addWeeks(int arg, long ts) {
        return TimeBinding.addDays(arg * 7, ts);
    }

    public static long addYears(int arg, long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.add(1, arg);
        return c.getTimeInMillis();
    }

    public static long alignDay(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long alignHour(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long alignMinute(long ts) {
        return ts - ts % 60000L;
    }

    public static long alignMonth(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long alignSecond(long ts) {
        return ts - ts % 1000L;
    }

    public static long alignWeek(long ts) {
        int dow = TimeBinding.getDayOfWeek(ts = TimeBinding.alignDay(ts));
        int off = 1 - dow;
        if (off == 0) {
            return ts;
        }
        return TimeBinding.addDays(off, ts);
    }

    public static long alignYear(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(2, 0);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long alignQuarter(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.set(2, c.get(2) / 3 * 3);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long fromJavaTime(long javaTime) {
        return javaTime;
    }

    public static int getDaysInMonth(long ts) {
        return TimeBinding.getDaysInMonth(TimeBinding.getYear(ts), TimeBinding.getMonth(ts));
    }

    public static int getDaysInMonth(int year, int month) {
        if (month == 2) {
            return TimeBinding.isLeapYear(year) ? 29 : 28;
        }
        return daysInMonth[month];
    }

    public static int getDaysInYear(long ts) {
        return TimeBinding.getDaysInYear(TimeBinding.getYear(ts));
    }

    public static int getDaysInYear(int year) {
        return TimeBinding.isLeapYear(year) ? 366 : 365;
    }

    public static int getDayOfWeek(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(7);
    }

    public static int getDayOfYear(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(6);
    }

    public static int getTimeOfDay(long ts) {
        return TimeBinding.getHour24(ts) * 3600000 + TimeBinding.getMinute(ts) * 60000 + TimeBinding.getSecond(ts) * 1000 + TimeBinding.getMillisecond(ts);
    }

    public static int getWeekOfMonth(long ts) {
        ts = TimeBinding.getWeekStart(ts);
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(4);
    }

    public static int getWeekOfYear(long ts) {
        ts = TimeBinding.getWeekStart(ts);
        GregorianCalendar c = TimeBinding.get(ts);
        return c.get(3);
    }

    public static long getWeekStart(long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        c.getTimeInMillis();
        int day = c.get(7);
        int start = c.getFirstDayOfWeek();
        if (day == start) {
            return ts;
        }
        long ret = TimeBinding.addDays(start - day, ts);
        return ret;
    }

    public static boolean isLeapDay(long ts) {
        return TimeBinding.getMonth(ts) == 2 && TimeBinding.getDay(ts) == 29;
    }

    public static boolean isLeapYear(int year) {
        if (year >= 1582) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    public static boolean isSameDay(long t1, long t2) {
        if (Math.abs(t1 - t2) > 86460000L) {
            return false;
        }
        return TimeBinding.getDay(t1) == TimeBinding.getDay(t2);
    }

    public static String prettyDuration(long ms) {
        return TimeBinding.prettyDuration(ms, new StringBuilder()).toString();
    }

    public static StringBuilder prettyDuration(long ms, StringBuilder buf) {
        int val;
        if (ms < 60000L) {
            buf.append(ms).append("ms");
            return buf;
        }
        long orig = ms;
        if (orig >= 3600000L) {
            val = (int)(ms / 3600000L);
            if (val > 0) {
                buf.append(val).append('h');
            }
            ms %= 3600000L;
        }
        if (orig >= 60000L) {
            val = (int)(ms / 60000L);
            if (val > 0) {
                buf.append(val).append('m');
            }
            ms %= 60000L;
        }
        int s = (int)(ms / 1000L);
        if (ms % 1000L > 500L) {
            ++s;
        }
        if (s > 0) {
            buf.append(s).append('s');
        }
        return buf;
    }

    public static String toString(long ts) {
        StringBuilder buf = new StringBuilder(30);
        TimeBinding.toString(ts, buf);
        return buf.toString();
    }

    public static void toString(long ts, StringBuilder s) {
        GregorianCalendar cal = TimeBinding.get(ts);
        cal.getTimeInMillis();
        int tmp = cal.get(1);
        s.append(tmp).append('-');
        tmp = cal.get(2) + 1;
        if (tmp < 10) {
            s.append('0');
        }
        s.append(tmp).append('-');
        tmp = cal.get(5);
        if (tmp < 10) {
            s.append('0');
        }
        s.append(tmp).append('T');
        tmp = cal.get(11);
        if (tmp < 10) {
            s.append('0');
        }
        s.append(tmp).append(':');
        tmp = cal.get(12);
        if (tmp < 10) {
            s.append('0');
        }
        s.append(tmp).append(':');
        tmp = cal.get(13);
        if (tmp < 10) {
            s.append('0');
        }
        s.append(tmp).append('.');
        tmp = cal.get(14);
        if (tmp < 10) {
            s.append('0');
        }
        if (tmp < 100) {
            s.append('0');
        }
        s.append(tmp);
        int offset = cal.getTimeZone().getOffset(ts);
        if (offset == 0) {
            s.append('Z');
        } else {
            int hrOff = Math.abs(offset / 3600000);
            int minOff = Math.abs(offset % 3600000 / 60000);
            if (offset < 0) {
                s.append('-');
            } else {
                s.append('+');
            }
            if (hrOff < 10) {
                s.append('0');
            }
            s.append(hrOff);
            s.append(':');
            if (minOff < 10) {
                s.append('0');
            }
            s.append(minOff);
        }
    }

    private static long subtract(Duration d, long ts) {
        GregorianCalendar c = TimeBinding.get(ts);
        if (d.getYears() > 0) {
            c.add(1, -d.getYears());
        }
        if (d.getMonths() > 0) {
            c.add(2, -d.getMonths());
        }
        if (d.getDays() > 0) {
            c.add(5, -d.getDays());
        }
        if (d.getHours() > 0) {
            c.add(10, -d.getHours());
        }
        if (d.getMinutes() > 0) {
            c.add(12, -d.getMinutes());
        }
        if (d.getSeconds() > 0) {
            c.add(13, -d.getSeconds());
        }
        if (d.getMillis() > 0) {
            c.add(14, -d.getMillis());
        }
        return c.getTimeInMillis();
    }

    public static final class CalendarCache {
        GregorianCalendar cal1 = new GregorianCalendar();
        GregorianCalendar cal2 = null;
        GregorianCalendar cal3 = null;
        TimeZone tz = TimeZone.getDefault();

        public GregorianCalendar get() {
            if (this.cal3 != null) {
                return this.cal3;
            }
            if (this.cal2 != null) {
                return this.cal2;
            }
            return this.cal1;
        }

        public GregorianCalendar get(long ts) {
            if (ts == this.cal1.getTimeInMillis()) {
                this.cal1.setTimeZone(this.tz);
                return this.cal1;
            }
            if (this.cal2 == null) {
                this.cal2 = new GregorianCalendar();
                this.cal2.setTimeZone(this.tz);
                this.cal2.setTimeInMillis(ts);
            }
            if (ts == this.cal2.getTimeInMillis()) {
                this.cal2.setTimeZone(this.tz);
                GregorianCalendar ret = this.cal2;
                this.cal2 = this.cal1;
                this.cal1 = ret;
                return ret;
            }
            if (this.cal3 == null) {
                this.cal3 = new GregorianCalendar();
                this.cal3.setTimeZone(this.tz);
                this.cal3.setTimeInMillis(ts);
            }
            if (ts != this.cal3.getTimeInMillis()) {
                this.cal3.setTimeInMillis(ts);
            }
            GregorianCalendar tmp = this.cal3;
            this.cal3.setTimeZone(this.tz);
            this.cal3 = this.cal2;
            this.cal2 = tmp;
            return tmp;
        }
    }
}

