/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.report;

import com.tridium.json.JSONObject;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.report.BAnalyticReport;
import com.tridiumx.analytics.report.BAnalyticReportParam;
import com.tridiumx.analytics.util.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperty(name="defaultFolder", type="baja:Folder", defaultValue="new BFolder()")
@NiagaraActions(value={@NiagaraAction(name="createNewReport", parameterType="analytics:AnalyticReportParam", defaultValue="new BAnalyticReportParam()", flags=4), @NiagaraAction(name="deleteReport", parameterType="analytics:AnalyticReportParam", defaultValue="new BAnalyticReportParam()", flags=4)})
public class BAnalyticReportFolder
extends BFolder {
    public static final Property defaultFolder = BAnalyticReportFolder.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Action createNewReport = BAnalyticReportFolder.newAction((int)4, (BValue)new BAnalyticReportParam(), null);
    public static final Action deleteReport = BAnalyticReportFolder.newAction((int)4, (BValue)new BAnalyticReportParam(), null);
    public static final Type TYPE = Sys.loadType(BAnalyticReportFolder.class);
    private static final String REPORT_FILES = "ReportFiles";

    public BFolder getDefaultFolder() {
        return (BFolder)this.get(defaultFolder);
    }

    public void setDefaultFolder(BFolder v) {
        this.set(defaultFolder, (BValue)v, null);
    }

    public void createNewReport(BAnalyticReportParam parameter) {
        this.invoke(createNewReport, (BValue)parameter, null);
    }

    public void deleteReport(BAnalyticReportParam parameter) {
        this.invoke(deleteReport, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
    }

    public void doCreateNewReport(final BAnalyticReportParam param) {
        final BDirectory d = (BDirectory)BOrd.make((String)"file:^").get();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String reportName = param.getRepName().trim();
                BFolder f = (BFolder)BAnalyticReportFolder.this.get(param.getLocation().getTag());
                if (f.get(SlotPath.escape((String)reportName)) != null) {
                    throw new BajaRuntimeException("Report with name " + reportName + " already exists in folder : " + f.getNavName());
                }
                BIFile file = null;
                OutputStream stream = null;
                try {
                    String repname = reportName.replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
                    file = d.getFileSpace().makeFile(d.getFilePath().merge(BAnalyticReportFolder.REPORT_FILES).merge(param.getLocation().getTag()).merge(new StringBuffer(repname).append("_").append(System.currentTimeMillis()).append(".json").toString()));
                    BOrd filePath = param.getFilePath();
                    if (filePath == null || filePath.isNull()) {
                        JSONObject root = BAnalyticReportFolder.this.getDefaultJSONObject();
                        String json = root.toString();
                        stream = file.getOutputStream();
                        stream.write(json.getBytes());
                    } else if (file != null) {
                        BIFile src = (BIFile)param.getFilePath().get();
                        BajaFileUtil.pipe((BIFile)src, (BIFile)file);
                    }
                }
                catch (IOException e) {
                    throw new BajaRuntimeException("Error during file IO : " + e.getMessage());
                }
                catch (Exception e) {
                    throw new BajaRuntimeException("Error creating analytic report " + e.getMessage());
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            Utils.log().severe("Error closing file stream " + e.getMessage());
                        }
                    }
                }
                BAnalyticReport report = new BAnalyticReport();
                report.setRepName(reportName);
                report.setDescription(param.getDescription());
                report.setLocation(param.getLocation());
                report.setFilePath(file.getOrdInSpace());
                report.setReportType(param.getReportType());
                report.setLastUpdated(BAbsTime.now());
                BAnalyticReportFolder.this.lease();
                f.add(SlotPath.escape((String)reportName), (BValue)report);
                return null;
            }
        });
    }

    public void doDeleteReport(BAnalyticReportParam parameter) {
        BFolder repFolder = (BFolder)this.get(parameter.getLocation().getTag());
        if (repFolder == null) {
            throw new BajaRuntimeException("Report folder not found");
        }
        repFolder.lease();
        BAnalyticReport toDelete = (BAnalyticReport)repFolder.get(parameter.getRepName());
        if (toDelete == null) {
            throw new BajaRuntimeException("Report " + parameter.getRepName() + " not found");
        }
        BOrd fileOrd = toDelete.getFilePath();
        if (fileOrd != null && !fileOrd.isNull()) {
            BIFile file = (BIFile)toDelete.getFilePath().get();
            try {
                file.delete();
            }
            catch (IOException e) {
                Utils.log().warning("Failed to delete config file. Cause : " + e.getLocalizedMessage());
            }
        }
        repFolder.remove(parameter.getRepName());
    }

    public static BDynamicEnum getAvailableFolders() {
        BAnalyticService service = BAnalyticService.getInstance();
        try {
            BAnalyticReportFolder f = service.getReports();
            f.lease();
            BFolder[] folders = (BFolder[])f.getChildren(BFolder.class);
            ArrayList<String> folderList = new ArrayList<String>();
            for (BFolder folder : folders) {
                folderList.add(folder.getName());
            }
            String[] fArray = folderList.toArray(new String[0]);
            return BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])fArray));
        }
        catch (Exception ex) {
            return BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{"defaultFolder"}));
        }
    }

    protected JSONObject getDefaultJSONObject() {
        JSONObject root = new JSONObject();
        JSONObject typeObj = new JSONObject();
        typeObj.put("value", (Object)"report");
        root.append("type", (Object)typeObj);
        JSONObject nodeObj = new JSONObject();
        typeObj.put("value", (Object)new JSONObject());
        root.append("node", (Object)nodeObj);
        JSONObject trObj = new JSONObject();
        JSONObject trDetails = new JSONObject();
        trDetails.put("tr", (Object)"today");
        trDetails.put("dow", (Object)"0x7F");
        trObj.put("value", (Object)trDetails);
        root.put("timeRange", (Object)trObj);
        JSONObject unitsObj = new JSONObject();
        unitsObj.put("value", (Object)"null;;;;");
        unitsObj.put("req", true);
        root.put("units", (Object)unitsObj);
        JSONObject dataFilterObj = new JSONObject();
        dataFilterObj.put("req", false);
        root.put("dataFilter", (Object)dataFilterObj);
        JSONObject baselineObj = new JSONObject();
        dataFilterObj.put("req", false);
        root.put("baseline", (Object)baselineObj);
        JSONObject normalizationObj = new JSONObject();
        normalizationObj.put("req", false);
        root.put("normalization", (Object)normalizationObj);
        JSONObject colorRangeObj = new JSONObject();
        JSONObject colorDtls = new JSONObject();
        colorDtls.put("minColor", (Object)"blue");
        colorDtls.put("avgColor", (Object)"white");
        colorDtls.put("maxColor", (Object)"red");
        colorRangeObj.put("req", true);
        colorRangeObj.put("value", (Object)colorDtls);
        root.put("colorRange", (Object)colorRangeObj);
        return root;
    }
}

