/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.point;

import com.tridiumx.analytics.Analytics;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.hier.BHierNode;
import com.tridiumx.analytics.poll.AnalyticConfigurable;
import com.tridiumx.analytics.poll.BAnalyticPoller;
import com.tridiumx.analytics.util.BOptionalSimple;
import com.tridiumx.analytics.util.Utils;
import java.util.logging.Level;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combination;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.BInterval;
import javax.bajax.analytics.time.Interval;
import javax.bajax.analytics.time.TimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="baja:Status", defaultValue="BStatus.ok", flags=11), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=11), @NiagaraProperty(name="node", type="String", defaultValue="slot:../..", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"analytics:NodeFe\")")}), @NiagaraProperty(name="data", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"analytics:DataFe\")")}), @NiagaraProperty(name="dataFilter", type="String", defaultValue=""), @NiagaraProperty(name="timeRange", type="baja:OptionalSimple", defaultValue="new BOptionalSimple(false,BAnalyticTimeRange.today)"), @NiagaraProperty(name="rollup", type="baja:OptionalSimple", defaultValue="new BOptionalSimple(false,BCombination.first)"), @NiagaraProperty(name="interval", type="baja:OptionalSimple", defaultValue="new BOptionalSimple(false,BInterval.fifteenMinutes)"), @NiagaraProperty(name="aggregation", type="baja:OptionalSimple", defaultValue="new BOptionalSimple(false,BCombination.first)"), @NiagaraProperty(name="totalize", type="baja:OptionalSimple", defaultValue="new BOptionalSimple(false,BBoolean.TRUE)"), @NiagaraProperty(name="nodeCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="poller", type="String", defaultValue="Default", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"analytics:PollerFe\")")}), @NiagaraProperty(name="lastPoll", type="baja:AbsTime", defaultValue="BAbsTime.NULL", flags=3, facets={@Facet(name="BFacets.SHOW_TIME_ZONE", value="BBoolean.FALSE"), @Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.TRUE")}), @NiagaraProperty(name="missingDataStrategy", type="analytics:MissingDataStrategy", defaultValue="new BMissingDataStrategy()")})
@NiagaraAction(name="poll")
public class BAnalyticProxyExt
extends BAbstractProxyExt
implements AnalyticConfigurable,
AnalyticConstants {
    public static final Property enabled = BAnalyticProxyExt.newProperty((int)0, (boolean)true, null);
    public static final Property status = BAnalyticProxyExt.newProperty((int)11, (BValue)BStatus.ok, null);
    public static final Property faultCause = BAnalyticProxyExt.newProperty((int)11, (String)"", null);
    public static final Property node = BAnalyticProxyExt.newProperty((int)0, (String)"slot:../..", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:NodeFe")));
    public static final Property data = BAnalyticProxyExt.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:DataFe")));
    public static final Property dataFilter = BAnalyticProxyExt.newProperty((int)0, (String)"", null);
    public static final Property timeRange = BAnalyticProxyExt.newProperty((int)0, (BValue)new BOptionalSimple(false, BAnalyticTimeRange.today), null);
    public static final Property rollup = BAnalyticProxyExt.newProperty((int)0, (BValue)new BOptionalSimple(false, (BSimple)BCombination.first), null);
    public static final Property interval = BAnalyticProxyExt.newProperty((int)0, (BValue)new BOptionalSimple(false, (BSimple)BInterval.fifteenMinutes), null);
    public static final Property aggregation = BAnalyticProxyExt.newProperty((int)0, (BValue)new BOptionalSimple(false, (BSimple)BCombination.first), null);
    public static final Property totalize = BAnalyticProxyExt.newProperty((int)0, (BValue)new BOptionalSimple(false, (BSimple)BBoolean.TRUE), null);
    public static final Property nodeCount = BAnalyticProxyExt.newProperty((int)3, (int)0, null);
    public static final Property poller = BAnalyticProxyExt.newProperty((int)0, (String)"Default", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:PollerFe")));
    public static final Property lastPoll = BAnalyticProxyExt.newProperty((int)3, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)));
    public static final Property missingDataStrategy = BAnalyticProxyExt.newProperty((int)0, (BValue)new BMissingDataStrategy(), null);
    public static final Action poll = BAnalyticProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAnalyticProxyExt.class);
    private static int inoperational = 87;
    private AnalyticValue cache;
    private Id id;
    private BAnalyticPoller lastPoller;
    private BUnit unit;
    private int valueType;
    private int nodeCountTemp = 0;
    private BINavNode navNode;

    @Override
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getNode() {
        return this.getString(node);
    }

    public void setNode(String v) {
        this.setString(node, v, null);
    }

    public String getData() {
        return this.getString(data);
    }

    public void setData(String v) {
        this.setString(data, v, null);
    }

    public String getDataFilter() {
        return this.getString(dataFilter);
    }

    public void setDataFilter(String v) {
        this.setString(dataFilter, v, null);
    }

    public BOptionalSimple getTimeRange() {
        return (BOptionalSimple)this.get(timeRange);
    }

    public void setTimeRange(BOptionalSimple v) {
        this.set(timeRange, (BValue)v, null);
    }

    public BOptionalSimple getRollup() {
        return (BOptionalSimple)this.get(rollup);
    }

    public void setRollup(BOptionalSimple v) {
        this.set(rollup, (BValue)v, null);
    }

    public BOptionalSimple getInterval() {
        return (BOptionalSimple)this.get(interval);
    }

    public void setInterval(BOptionalSimple v) {
        this.set(interval, (BValue)v, null);
    }

    public BOptionalSimple getAggregation() {
        return (BOptionalSimple)this.get(aggregation);
    }

    public void setAggregation(BOptionalSimple v) {
        this.set(aggregation, (BValue)v, null);
    }

    public BOptionalSimple getTotalize() {
        return (BOptionalSimple)this.get(totalize);
    }

    public void setTotalize(BOptionalSimple v) {
        this.set(totalize, (BValue)v, null);
    }

    public int getNodeCount() {
        return this.getInt(nodeCount);
    }

    public void setNodeCount(int v) {
        this.setInt(nodeCount, v, null);
    }

    public String getPoller() {
        return this.getString(poller);
    }

    public void setPoller(String v) {
        this.setString(poller, v, null);
    }

    public BAbsTime getLastPoll() {
        return (BAbsTime)this.get(lastPoll);
    }

    public void setLastPoll(BAbsTime v) {
        this.set(lastPoll, (BValue)v, null);
    }

    public BMissingDataStrategy getMissingDataStrategy() {
        return (BMissingDataStrategy)this.get(missingDataStrategy);
    }

    public void setMissingDataStrategy(BMissingDataStrategy v) {
        this.set(missingDataStrategy, (BValue)v, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() throws Exception {
        this.syncWithPoller();
        this.updateConfig();
        super.atSteadyState();
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p.equals(enabled) || p.equals(data) || p.equals(node)) {
                this.id = null;
                this.updateConfig();
            }
            if (p.equals(poller)) {
                this.syncWithPoller();
                this.updateConfig();
            }
        }
        super.changed(p, cx);
    }

    public void doPoll() {
        BAnalyticService.getInstance().enqueue(this);
    }

    public Id getDataId() {
        if (this.id == null) {
            this.id = Id.newId((String)this.getData());
        }
        return this.id;
    }

    public void onExecute(BStatusValue working, Context cx) {
        if (!this.getParentPoint().isWritablePoint()) {
            this.updateValue(working);
        }
        super.onExecute(working, cx);
    }

    public void pointFacetsChanged() {
        BControlPoint pt = (BControlPoint)this.getParent();
        BFacets f = pt.getFacets();
        this.unit = (BUnit)f.get("units");
        super.pointFacetsChanged();
    }

    @Override
    public void run() {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.isOperational()) {
            this.updateConfig();
            if (!this.isOperational()) {
                return;
            }
        }
        AnalyticContext cx = new AnalyticContext();
        BINavNode navNode = (BINavNode)BOrd.make((String)this.getNode()).get((BObject)this);
        if (navNode instanceof BHierNode) {
            BOrd hierarchyOrd = ((BLevelElem)((BHierNode)navNode).getHierarchyNode()).getHierarchyOrd();
            this.lease();
            this.setNode(hierarchyOrd.encodeToString());
        }
        cx.setNode(this.getNavNode(false));
        cx.setData(this.getDataId());
        TimeRange tr = null;
        Interval inter = null;
        if (this.getTimeRange().getHasValue()) {
            tr = (TimeRange)this.getTimeRange().getValue();
            cx.setTimeRange(tr);
        }
        if (this.getInterval().getHasValue()) {
            inter = (Interval)this.getInterval().getValue();
            cx.setInterval(inter);
        }
        if (this.getAggregation().getHasValue()) {
            cx.setAggregation((Combination)this.getAggregation().getValue());
        }
        if (this.getRollup().getHasValue()) {
            cx.setRollup((Combination)this.getRollup().getValue());
        }
        if (this.getDataFilter().length() > 0) {
            cx.setDataFilter(this.getDataFilter());
        }
        if (this.getTotalize().getHasValue()) {
            cx.setHisTotEnabled(!((BBoolean)this.getTotalize().getValue()).getBoolean());
        }
        cx.setUnit(this.unit);
        BMissingDataStrategy mds = this.getMissingDataStrategy();
        if (mds.getEnabled()) {
            cx.setMissingDataStrategy(mds);
        }
        boolean equal = true;
        if (Utils.log().isLoggable(Level.FINER)) {
            BAnalyticService.RequestContext.getReqAnalyticContext().set(cx);
            BAnalyticService.RequestContext.getReqOrigin().set("AnalyticProxyExt:" + this.getParentComponent().getNavOrd());
        }
        AnalyticValue val = tr != null ? Analytics.getRollup(cx) : Analytics.getValue(cx);
        if (this.cache == null) {
            this.cache = val.newCopy();
            equal = false;
        } else {
            equal = this.cache.statusValueEquals(val);
            this.cache.copy(val);
        }
        this.setLastPoll(Clock.time());
        if (!equal) {
            BControlPoint pt = this.getParentPoint();
            if (pt.isWritablePoint()) {
                BStatusValue sv = (BStatusValue)pt.get("in16");
                this.updateValue(sv);
            } else {
                this.executePoint();
            }
        }
    }

    public void started() throws Exception {
        BControlPoint pt = (BControlPoint)this.getParent();
        this.valueType = pt instanceof BNumericPoint ? 2 : (pt instanceof BBooleanPoint ? 0 : (pt instanceof BEnumPoint ? 1 : 3));
        BFacets f = pt.getFacets();
        this.unit = (BUnit)f.get("units");
        super.started();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void stopped() throws Exception {
        this.syncWithPoller();
        super.stopped();
    }

    protected void configOk() {
        this.updateConfig(0, null);
    }

    protected void configFault(String reason) {
        this.updateConfig(2, reason);
    }

    protected boolean isOperational() {
        if ((this.getStatus().getBits() & inoperational) != 0) {
            return false;
        }
        try {
            return BAnalyticService.getInstance().isOperational();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void updateConfig() {
        BAnalyticService svc;
        int bits;
        StringBuilder fc = new StringBuilder();
        int n = bits = this.getEnabled() ? 0 : 1;
        if (!this.getEnabled()) {
            bits = 1;
        }
        if ((svc = BAnalyticService.getInstance()).getPoller(this.getPoller()) == null) {
            bits |= 2;
            if (svc.isFatalFault()) {
                fc.append(Utils.lex("subscription.expired"));
            } else {
                fc.append(Utils.lex("invalidPoller"));
            }
        }
        if (this.getData().length() == 0) {
            fc.append(" | ").append(Utils.lex("missingDataId"));
            bits |= 2;
        }
        try {
            this.navNode = this.getNavNode(true);
        }
        catch (Exception x) {
            fc.append(" | ").append(Utils.lex("invalidNode"));
            bits |= 2;
        }
        this.updateConfig(bits, fc.toString());
    }

    public void findTargets() {
        try {
            this.nodeCountTemp = 0;
            BINavNode tempNode = this.getNavNode(false);
            if (tempNode instanceof BINavNode) {
                if (Utils.log().isLoggable(Level.FINER)) {
                    BAnalyticService.RequestContext.getReqAnalyticContext().set(new AnalyticContext().setNode(tempNode));
                    BAnalyticService.RequestContext.getReqOrigin().set("analyticProxyExt:" + this.getName());
                }
                this.tryMonitor(tempNode);
                this.setNodeCount(this.nodeCountTemp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateConfig(int bits, String faultCause) {
        if (this.getStatus().getBits() != bits) {
            this.setStatus(BStatus.make((int)bits));
        }
        if (faultCause == null || faultCause.length() == 0) {
            if (this.getFaultCause().length() > 0) {
                this.setFaultCause("");
            }
        } else if (!this.getFaultCause().equals(faultCause)) {
            this.setFaultCause(faultCause);
            if ((bits & 2) != 0) {
                Utils.log().severe(() -> this.toPathString() + ": " + faultCause);
            }
        }
    }

    private void syncWithPoller() {
        if (this.lastPoller != null) {
            this.lastPoller.unregister(this);
            this.lastPoller = null;
        }
        if (this.isRunning()) {
            BAnalyticPoller poller = BAnalyticService.getInstance().getPoller(this.getPoller());
            poller.register(this);
            this.lastPoller = poller;
        }
    }

    private void updateValue(BStatusValue working) {
        int status = this.getStatus().getBits();
        if (this.isOperational() && this.cache != null) {
            switch (this.valueType) {
                case 2: {
                    double d = this.cache.toNumeric();
                    if (Utils.isEqualTo(d, ((BStatusNumeric)working).getValue())) break;
                    working.setValueValue((BValue)BDouble.make((double)d));
                    break;
                }
                case 0: {
                    boolean b = this.cache.toBoolean();
                    if (b == ((BStatusBoolean)working).getValue()) break;
                    working.setValueValue((BValue)BBoolean.make((boolean)b));
                    break;
                }
                case 1: {
                    int i = this.cache.toEnum();
                    if (i == ((BStatusEnum)working).getValue().getOrdinal()) break;
                    working.setValueValue((BValue)BDynamicEnum.make((int)i));
                    break;
                }
                default: {
                    String s = this.cache.toString();
                    if (s.equals(((BStatusString)working).getValue())) break;
                    working.setValueValue((BValue)BString.make((String)s));
                }
            }
            status |= this.cache.getStatus();
        }
        if (status != working.getStatus().getBits()) {
            working.setStatus(BStatus.make((int)status));
        }
    }

    private void tryMonitor(BINavNode node) {
        BINavNode orig2 = node;
        node = Utils.getProxyTarget(node);
        if (!BAnalyticService.getInstance().isValidNodeType(node)) {
            return;
        }
        BINavNode[] kids = orig2.getNavChildren();
        if (kids != null && kids.length > 0) {
            for (BINavNode orig2 : kids) {
                NodeInfo info;
                if (!(node instanceof BINavNode) || (info = NodeInfo.get(orig2, true)) == null || info.getAnalyticDataSource(this.getDataId(), true, null) == null) continue;
                ++this.nodeCountTemp;
            }
        }
    }

    private BINavNode getNavNode(boolean update) {
        if (this.navNode == null || update) {
            this.navNode = Utils.resolveNode(BOrd.make((String)this.getNode()).resolve((BObject)this));
        }
        return this.navNode;
    }
}

