/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridiumx.analytics.Analytics;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.naming.BAbstractTrendResolver;
import com.tridiumx.analytics.naming.BAnalyticOrdScheme;
import com.tridiumx.analytics.naming.BAnalyticTrendResolver;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;

public class BTrendOrdScheme
extends BAnalyticOrdScheme
implements AnalyticConstants {
    public static final BTrendOrdScheme INSTANCE = new BTrendOrdScheme();
    public static final Type TYPE = Sys.loadType(BTrendOrdScheme.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    private BTrendOrdScheme() {
        super("analyticTrend");
    }

    protected BTrendOrdScheme(String scheme) {
        super(scheme);
    }

    @Override
    protected BObject resolve(AnalyticContext cx) {
        int currPrio = Thread.currentThread().getPriority();
        try {
            if (Sys.isStation()) {
                Thread.currentThread().setPriority(BAnalyticService.getInstance().getThreadPriority());
            }
            AnalyticTrend trend = Analytics.getTrend(cx);
            BAbstractTrendResolver bAbstractTrendResolver = this.getResolver(cx, trend);
            return bAbstractTrendResolver;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            Thread.currentThread().setPriority(currPrio);
        }
    }

    @Override
    protected BAbstractTrendResolver getResolver(AnalyticContext cx, AnalyticTrend trend) {
        return new BAnalyticTrendResolver(trend, cx);
    }
}

