/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridium.data.BDataTable;
import com.tridiumx.analytics.Analytics;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.missingdata.BAggregationStrategy;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.combine.TrendCombiner;
import com.tridiumx.analytics.naming.BAbstractTrendResolver;
import com.tridiumx.analytics.naming.BAnalyticOrdScheme;
import com.tridiumx.analytics.naming.BAnalyticSingleValueResolver;
import com.tridiumx.analytics.trend.AbstractTrend;
import com.tridiumx.analytics.trend.AggregateTrend;
import com.tridiumx.analytics.trend.EmptyTrend;
import com.tridiumx.analytics.trend.IgnoredAggregateTrend;
import com.tridiumx.analytics.util.Strings;
import com.tridiumx.analytics.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.MultiAnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class BMultiWebRollupOrdScheme
extends BAnalyticOrdScheme
implements AnalyticConstants {
    public static final BMultiWebRollupOrdScheme INSTANCE = new BMultiWebRollupOrdScheme();
    public static final Type TYPE = Sys.loadType(BMultiWebRollupOrdScheme.class);
    private static Pattern pattern = Pattern.compile("multiOrd=\\[.*\\]");

    @Override
    public Type getType() {
        return TYPE;
    }

    private BMultiWebRollupOrdScheme() {
        super("analyticMultiRollup");
    }

    @Override
    public AnalyticContext getAnalyticContext(OrdTarget base, Map<String, String> args) {
        return MultiAnalyticContext.make(args, (Context)base);
    }

    public List<AnalyticContext> getOrds(AnalyticContext cx) {
        MultiAnalyticContext mcx = (MultiAnalyticContext)cx;
        return mcx.getMultiParams().stream().filter(Objects::nonNull).map(args -> AnalyticContext.make(args, mcx, Optional.of(mcx))).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> parseQuery(OrdQuery query) {
        String qBody = query.getBody();
        String multiOrd = "";
        Matcher m = pattern.matcher(qBody);
        if (m.find()) {
            multiOrd = qBody.substring(m.start() + 10, m.end() - 1);
            qBody = m.replaceFirst("");
        }
        Map<String, String> map = Strings.decodeQueryString(qBody);
        map.put("multiOrd", multiOrd);
        return map;
    }

    @Override
    protected BObject resolve(AnalyticContext cx) {
        int currPrio = Thread.currentThread().getPriority();
        BDataTable ret = new BDataTable();
        try {
            BMissingDataStrategy mds;
            BAggregationStrategy aggregationStrategy;
            boolean ignoreMissingPoint;
            List<AnalyticTrend> wrappedTrendList;
            if (Sys.isStation()) {
                Thread.currentThread().setPriority(BAnalyticService.getInstance().getThreadPriority());
            }
            BUnit unit = cx.getUnit(false);
            MultiAnalyticContext mcx = (MultiAnalyticContext)cx;
            List<AnalyticContext> roots = this.getOrds(cx);
            List<CompletableFuture> trendFutures = roots.stream().map(cxt -> Analytics.getRollupAsync(cxt)).collect(Collectors.toList());
            CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(trendFutures.toArray(new CompletableFuture[trendFutures.size()]));
            CompletionStage allDone = allDoneFuture.thenApply(f -> trendFutures.stream().map(fu -> (Optional)fu.join()).filter(tr -> tr.isPresent()).map(tr -> (AnalyticValue)tr.get()).collect(Collectors.toList()));
            List resolvdAValueList = (List)((CompletableFuture)allDone).get();
            if (roots.size() > 0) {
                cx.setUnit(roots.get(0).getUnit(false));
            }
            AbstractTrend trend = (wrappedTrendList = resolvdAValueList.stream().map(tr -> new SingleValueTrend(cx, (AnalyticValue)tr)).collect(Collectors.toList())).size() == 0 ? new EmptyTrend(cx) : (!mcx.getAggMode() ? new AggregateTrend(wrappedTrendList, new TrendCombiner()) : ((ignoreMissingPoint = BAggregationStrategy.ignorePoint.equals((Object)(aggregationStrategy = (mds = mcx.getMissingDataStrategy(true)).getAggregationStrategy()))) ? new IgnoredAggregateTrend(wrappedTrendList, mcx.getAgg(true).makeCombiner()) : new AggregateTrend(wrappedTrendList, mcx.getAgg(true).makeCombiner())));
            List<BFacets> trendFacets = wrappedTrendList.stream().map(tr -> Utils.adjustUnits(tr.getContext(), tr.getContext().getUnit(false), tr.getContext().getFacets())).collect(Collectors.toList());
            BAnalyticSingleValueResolver bAnalyticSingleValueResolver = new BAnalyticSingleValueResolver(trend, mcx, trendFacets);
            return bAnalyticSingleValueResolver;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            Thread.currentThread().setPriority(currPrio);
        }
    }

    @Override
    protected BAbstractTrendResolver getResolver(AnalyticContext cx, AnalyticTrend trend) {
        return null;
    }

    private class SingleValueTrend
    extends AbstractTrend {
        private AnalyticValue inVal;
        private boolean flag;

        public SingleValueTrend(AnalyticContext cx, AnalyticValue val) {
            super(cx);
            this.inVal = null;
            this.flag = false;
            this.inVal = val.newCopy();
            this.inVal.setTimestamp(cx.getStartTime());
        }

        @Override
        protected AnalyticValue getNext() {
            if (this.flag || this.inVal.getStatus() == 64) {
                return null;
            }
            this.flag = true;
            return this.inVal;
        }
    }
}

