/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.naming.AnalyticTrendCursor;
import com.tridiumx.analytics.naming.BAnalyticTrendRecord;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.MultiAnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class AnalyticMultiTrendCursor
extends AnalyticTrendCursor {
    public AnalyticMultiTrendCursor(BITable<BAnalyticTrendRecord> series, AnalyticTrend trend, BFacets facets) {
        super(series, trend, facets, trend.getContext());
    }

    public AnalyticMultiTrendCursor(BITable<BAnalyticTrendRecord> series, AnalyticTrend trend, List<BFacets> facets, MultiAnalyticContext mcx) {
        super(series, trend, facets.size() > 0 ? facets.get(0) : mcx.getFacets(), mcx);
    }

    @Override
    protected boolean advanceCursor() {
        MultiAnalyticContext mcx = (MultiAnalyticContext)this.context;
        if (mcx.getAggMode()) {
            return super.advanceCursor();
        }
        if (this.isFirstRecord && this.aVal != null) {
            this.isFirstRecord = false;
            return true;
        }
        if (this.trend.hasNext()) {
            AnalyticValue temp = this.trend.next();
            this.aVal = new BAnalyticTrendRecord();
            int counter = 1;
            this.aVal.setTimestamp(BAbsTime.make((long)temp.getTimestamp()));
            List tempValueList = (List)temp.getValue();
            for (AnalyticValue v : tempValueList) {
                this.aVal.add("value" + counter, (BValue)Values.getSimple(v));
                this.aVal.add("status" + counter, (BValue)BStatus.make((int)temp.getStatus()));
                this.aVal.add("tf" + counter, (BValue)((AbstractAnalyticValue)temp).getTrendFlags());
                ++counter;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void init(BFacets facets, AnalyticValue temp) {
        if (this.context == null || !(this.context instanceof MultiAnalyticContext)) {
            return;
        }
        MultiAnalyticContext mcx = (MultiAnalyticContext)this.context;
        if (!mcx.getAggMode()) {
            BAbsTime time = BAbsTime.make((long)temp.getTimestamp());
            BTimeZone timeZone = time.getTimeZone();
            this.aVal = new BAnalyticTrendRecord();
            this.aVal.setTimestamp(time);
            this.aVal.setStatus(BStatus.make((int)temp.getStatus()));
            this.aVal.setTrendFlags(((AbstractAnalyticValue)temp).getTrendFlags());
            this.aVal.setFacets(this.aVal.getSlot("timestamp"), BFacets.make((String)"TimeZone", (BIDataValue)timeZone));
            BUnit inUnit = (BUnit)facets.get("units");
            int counter = 1;
            List<AnalyticContext> contextList = this.getNodeContextList(mcx);
            List tempValueList = (List)temp.getValue();
            for (AnalyticValue val : tempValueList) {
                String v = "value" + counter;
                this.aVal.add(v, (BValue)Values.getSimple(val));
                BFacets bFacets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"units", (BIDataValue)(inUnit == null ? BUnit.NULL : inUnit), (String)"precision", (BIDataValue)BInteger.make((int)2)));
                BString seriesName = contextList.get(counter - 1).getSeriesName();
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"seriesName", (BIDataValue)seriesName));
                this.aVal.setFacets(this.aVal.getSlot(v), bFacets);
                this.aVal.add("status" + counter, (BValue)BStatus.make((int)temp.getStatus()));
                this.aVal.add("tf" + counter, (BValue)((AbstractAnalyticValue)temp).getTrendFlags());
                ++counter;
            }
        } else {
            super.init(facets, temp);
        }
    }

    List<AnalyticContext> getNodeContextList(AnalyticContext cx) {
        MultiAnalyticContext mcx = (MultiAnalyticContext)cx;
        return mcx.getMultiParams().stream().filter(Objects::nonNull).map(args -> AnalyticContext.make(args, mcx, Optional.of(mcx))).collect(Collectors.toList());
    }
}

