/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.algorithm.outlier.BRawDataFilter;
import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.data.UnitConverter;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.data.substitute.KNNAnalyticTrend;
import com.tridiumx.analytics.trend.AbstractTrend;
import com.tridiumx.analytics.trend.DeltaTrend;
import com.tridiumx.analytics.trend.EmptyTrend;
import com.tridiumx.analytics.trend.FilteredNiagaraTrend;
import com.tridiumx.analytics.trend.IntervalTrend;
import com.tridiumx.analytics.trend.LIAnalyticTrend;
import com.tridiumx.analytics.trend.NiagaraTrend;
import com.tridiumx.analytics.trend.OneCountTrend;
import com.tridiumx.analytics.trend.RawDataFilterTrend;
import com.tridiumx.analytics.trend.StatusFilterTrend;
import com.tridiumx.analytics.util.Histories;
import com.tridiumx.analytics.util.Tagging;
import com.tridiumx.analytics.util.Utils;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.control.BControlPoint;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Taggable;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class NavDataSource
implements AnalyticConstants,
AnalyticDataSource {
    private static final Id hsUnit = Id.newId((String)"hs:unit");
    private static final Id nHistory = Id.newId((String)"n:history");
    private static final BDouble one = BDouble.make((double)1.0);
    private Boolean hasTrend;
    private BIHistory history;
    private BINavNode node;
    private BUnit unit;

    public NavDataSource(BINavNode node) {
        this.node = node;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        if (!this.isDataFilterApplicable(cx = new AnalyticContextWrapper(cx).setNode(this.node))) {
            return null;
        }
        BIHistory his = this.getHistory(cx);
        if (his == null) {
            String warning = Utils.lex("dataSourceHasNoHistory") + ": " + this.node.getNavOrd().toString(null);
            Utils.log().warning(warning);
            return new EmptyTrend(cx);
        }
        BMissingDataStrategy strategy = cx.getMissingDataStrategy(true);
        NiagaraTrend nt = new NiagaraTrend(his, cx);
        AnalyticTrend ret = this.getFinalRawTrend(strategy, nt, cx);
        if (cx.getHisTotEnabled() && nt.isTotalized() && cx.getAggregation(true).getOrdinal() != 2) {
            ret = new DeltaTrend(ret);
        }
        if (cx.getInterval(true).getOrdinal() != 0) {
            int intpAlgOrdinal;
            IntervalTrend analyticTrend = new IntervalTrend(ret, cx).setCov(nt.isCov());
            ret = analyticTrend;
            if (strategy != null && strategy.getEnabled() && (intpAlgOrdinal = strategy.getInterpolationAlgorithm().getOrdinal()) == 2) {
                ret = new KNNAnalyticTrend(analyticTrend, strategy, cx.getDowInclusion());
            }
        }
        if (cx.getAggregation(true).getOrdinal() == 2) {
            return new OneCountTrend(ret);
        }
        return ret;
    }

    private boolean isDataFilterApplicable(AnalyticContext cx) {
        Predicate<Entity> filter = cx.getDataFilter();
        if (filter != null && this.node instanceof Entity && !filter.test((Entity)this.node)) {
            Utils.log().warning("DataFilter: " + filter.toString() + " does not match for the tags on: " + this.node.getNavOrd());
            return false;
        }
        return true;
    }

    private FilteredNiagaraTrend getFinalRawTrend(BMissingDataStrategy strategy, NiagaraTrend nt, AnalyticContext cx) {
        AbstractTrend finalRawTrend = null;
        AbstractTrend statusFilterTrend = null;
        AbstractTrend rawDataFilterTrend = null;
        statusFilterTrend = cx.getStatusFilter() != null ? new StatusFilterTrend(nt) : nt;
        BRawDataFilter rawDataFilter = cx.getRawDataFilter();
        rawDataFilterTrend = rawDataFilter != null && (!rawDataFilter.getHighLimit().getUnspecified() || !rawDataFilter.getLowLimit().getUnspecified()) ? new RawDataFilterTrend(statusFilterTrend) : statusFilterTrend;
        if (strategy != null && strategy.getEnabled() && this.applyLinearInterpolation(strategy)) {
            finalRawTrend = new LIAnalyticTrend(rawDataFilterTrend, strategy);
        }
        if (finalRawTrend == null) {
            finalRawTrend = rawDataFilterTrend;
        }
        FilteredNiagaraTrend filteredTrend = new FilteredNiagaraTrend(finalRawTrend);
        return filteredTrend;
    }

    private boolean applyLinearInterpolation(BMissingDataStrategy strategy) {
        return strategy.getInterpolationAlgorithm().getOrdinal() == 1;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        Predicate<Entity> filter = (cx = new AnalyticContextWrapper(cx).setNode(this.node)).getDataFilter();
        if (filter != null && this.node instanceof Entity && !filter.test((Entity)this.node)) {
            return null;
        }
        if (this.node instanceof BComponent) {
            cx.subscribe(this.node);
        }
        AnalyticValue ret = null;
        if (this.node instanceof BIHistory) {
            if (this.history == null) {
                this.history = (BIHistory)this.node;
            }
            ret = Values.make(Histories.getDbConnection(cx).getLastRecord(this.history));
        } else {
            ret = Values.make(this.node);
        }
        if (cx.getAggregation(true).getOrdinal() != 2) {
            UnitConverter converter = UnitConverter.make(this.getUnit(cx), cx.getUnit(true));
            if (converter != null) {
                double d = converter.convert(ret.toNumeric());
                if (ret instanceof AnalyticNumeric) {
                    ((AnalyticNumeric)ret).setValue(d);
                } else {
                    ret.setValue(BDouble.make((double)d));
                }
            }
        } else {
            ret.setValue(one);
        }
        ret.setTimestamp(System.currentTimeMillis());
        return ret;
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        Predicate<Entity> filter = cx.getDataFilter();
        if (filter != null && this.node instanceof Entity && !filter.test((Entity)this.node)) {
            return false;
        }
        if (this.hasTrend == null) {
            this.hasTrend = this.getHistory(cx) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.hasTrend;
    }

    private BIHistory getHistory(AnalyticContext cx) {
        Optional<BIHistory> hid;
        if (this.history == null && this.node instanceof Taggable && (hid = ((Taggable)this.node).tags().get(nHistory).map(p -> BHistoryId.make((String)BFormat.format((String)p.toString(null), (Object)this.node, (Context)cx))).map(p -> Histories.getHistory(p, cx))) != null && hid.isPresent()) {
            this.history = hid.get();
        }
        if (this.history == null && this.node instanceof BIHistory) {
            this.history = (BIHistory)this.node;
        } else if (this.node instanceof BHistoryExt) {
            this.history = ((BHistoryExt)this.node).getHistory();
        } else if (this.node.hasNavChildren()) {
            BINavNode[] kids = this.node.getNavChildren();
            if (cx != null) {
                kids = Utils.filter(kids, cx.getBase());
            }
            int len = kids.length;
            for (int i = 0; i < len; ++i) {
                if (!(kids[i] instanceof BHistoryExt)) continue;
                this.history = ((BHistoryExt)kids[i]).getHistory();
                break;
            }
        }
        if (this.history != null && (cx == null || this.history.getPermissions(cx.getBase()).hasOperatorRead())) {
            return this.history;
        }
        return null;
    }

    private BUnit getUnit(AnalyticContext cx) {
        BFacets facets;
        if (this.unit != null) {
            return this.unit;
        }
        this.unit = Tagging.valueOf((Object)this.node, hsUnit).orElse(null);
        if (this.unit != null) {
            return this.unit;
        }
        this.unit = Tagging.valueOf((Object)this.getHistory(cx), hsUnit).orElse(null);
        if (this.unit != null) {
            return this.unit;
        }
        if (this.node instanceof BControlPoint) {
            this.unit = (BUnit)((BControlPoint)this.node).getFacets().get("units");
        }
        if (this.unit != null) {
            return this.unit;
        }
        if (this.history != null && (facets = (BFacets)this.history.getConfig().get("valueFacets")) != null) {
            this.unit = (BUnit)facets.get("units");
        }
        if (this.unit != null) {
            return this.unit;
        }
        if (this.node instanceof BComponent) {
            BComponent comp = (BComponent)this.node;
            BFacets facets2 = (BFacets)comp.get("facets");
            if (facets2 != null) {
                this.unit = (BUnit)facets2.get("units");
            }
            if (this.unit != null) {
                return this.unit;
            }
            facets2 = null;
            Property p = comp.getPropertyInParent();
            if (p != null) {
                facets2 = comp.getParent().getSlotFacets((Slot)p);
            }
            if (facets2 != null) {
                this.unit = (BUnit)facets2.get("units");
            }
            if (this.unit != null) {
                return this.unit;
            }
        }
        return null;
    }
}

