/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.algorithm.missingdata.BAggregationStrategy;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.data.AlgorithmDataSource;
import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.trend.AggregateTrend;
import com.tridiumx.analytics.trend.EmptyTrend;
import com.tridiumx.analytics.trend.IgnoredAggregateTrend;
import java.util.ArrayList;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.Combiner;

public class AggregateDataSource
implements AnalyticConstants,
AnalyticDataSource {
    private ArrayList<AnalyticDataSource> sources;

    public AggregateDataSource(ArrayList<AnalyticDataSource> sources) {
        this.sources = sources;
    }

    public ArrayList<AnalyticDataSource> getSources() {
        return this.sources;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        ArrayList<AnalyticTrend> trends = new ArrayList<AnalyticTrend>();
        BMissingDataStrategy mds = cx.getMissingDataStrategy(true);
        int len = this.sources.size();
        for (int i = 0; i < len; ++i) {
            AnalyticTrend trend;
            AnalyticDataSource src = this.sources.get(i);
            if (!src.hasTrend(cx) && !this.isAlgDSWithoutTrend(src, cx) || (trend = src.getTrend(cx)) == null) continue;
            trends.add(trend);
        }
        if (trends.size() == 0) {
            return new EmptyTrend(cx);
        }
        boolean ignoreMissingPoint = false;
        if (mds != null && mds.getEnabled()) {
            BAggregationStrategy aggregationStrategy = mds.getAggregationStrategy();
            ignoreMissingPoint = BAggregationStrategy.ignorePoint.equals((Object)aggregationStrategy);
        }
        if (ignoreMissingPoint) {
            return new IgnoredAggregateTrend(trends);
        }
        return new AggregateTrend(trends);
    }

    private boolean isAlgDSWithoutTrend(AnalyticDataSource source, AnalyticContext cx) {
        if (source instanceof AlgorithmDataSource) {
            return !source.hasTrend(cx);
        }
        return false;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        Combiner combiner = cx.getAggregation(true).makeCombiner();
        int len = this.sources.size();
        for (int i = 0; i < len; ++i) {
            AnalyticValue val = this.sources.get(i).getValue(cx);
            if (val == null) continue;
            combiner.update(val);
        }
        return combiner.getValue();
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        int len = this.sources.size();
        for (int i = 0; i < len; ++i) {
            if (!this.sources.get(i).hasTrend(cx)) continue;
            return true;
        }
        return false;
    }

    public boolean isNull() {
        if (this.sources == null) {
            return true;
        }
        return this.sources.size() == 0;
    }
}

