/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.aon;

import com.tridiumx.analytics.aon.Alist;
import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.aon.Aobj;
import com.tridiumx.analytics.aon.Aon;
import com.tridiumx.analytics.aon.AonReader;
import com.tridiumx.analytics.aon.Atypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Iterator;

class AonIo
implements Atypes {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    AonIo() {
    }

    public static Aobj read(Aon.Factory fac, InputStream in, String charset) throws IOException {
        AonReader pbr = new AonReader(in, charset);
        return AonIo.readValue(fac, pbr, new StringBuffer());
    }

    public static Aobj read(Aon.Factory fac, Reader in) throws IOException {
        AonReader pbr = new AonReader(in);
        return AonIo.readValue(fac, pbr, new StringBuffer());
    }

    public static Aobj read(Aon.Factory fac, String in) throws IOException {
        AonReader pbr = new AonReader(in.toCharArray());
        return AonIo.readValue(fac, pbr, new StringBuffer());
    }

    public static void write(Aobj obj, PrintWriter out, boolean minify) {
        AonIo.write(obj, out, minify, 0);
        if (!minify) {
            out.println();
        }
        out.flush();
    }

    public static void write(String s, PrintWriter out) {
        out.print('\"');
        int len = s.length();
        block8: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    out.write(92);
                    out.write(ch);
                    continue block8;
                }
                case '\b': {
                    out.write(92);
                    out.write(98);
                    continue block8;
                }
                case '\f': {
                    out.write(92);
                    out.write(102);
                    continue block8;
                }
                case '\n': {
                    out.write(92);
                    out.write(110);
                    continue block8;
                }
                case '\r': {
                    out.write(92);
                    out.write(114);
                    continue block8;
                }
                case '\t': {
                    out.write(92);
                    out.write(116);
                    continue block8;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        AonIo.writeUnicode(ch, out);
                        continue block8;
                    }
                    out.write(ch);
                }
            }
        }
        out.print('\"');
    }

    private static Aobj readList(Aon.Factory fac, AonReader in, StringBuffer buf) throws IOException {
        Alist ret = fac.makeList();
        int ch = 91;
        while (ch != 93) {
            Aobj val = AonIo.readValue(fac, in, buf);
            if (val != null) {
                ret.add(val);
            }
            ch = AonIo.readNextClue(in);
        }
        return ret;
    }

    private static Aobj readMap(Aon.Factory fac, AonReader in, StringBuffer buf) throws IOException {
        Amap ret = fac.makeMap();
        char ch = AonIo.readNextClue(in);
        Aobj val = null;
        String name = null;
        while (ch != '}') {
            if (ch != '\"') {
                throw new IOException("Expecting first quote of name but got: " + ch);
            }
            AonIo.readString(in, buf);
            name = buf.toString();
            ch = AonIo.readNextClue(in);
            if (ch != ':') {
                throw new IOException("Expecting pair separator ':' but got: " + ch);
            }
            val = AonIo.readValue(fac, in, buf);
            ret.put(name, val);
            ch = AonIo.readNextClue(in);
            if (ch != ',') continue;
            ch = AonIo.readNextClue(in);
        }
        return ret;
    }

    private static char readNextClue(AonReader in) throws IOException {
        int ch = in.read();
        while (ch >= 0) {
            switch (ch) {
                case 34: 
                case 44: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 91: 
                case 93: 
                case 102: 
                case 110: 
                case 116: 
                case 123: 
                case 125: {
                    return (char)ch;
                }
            }
            ch = in.read();
        }
        return (char)ch;
    }

    private static Aobj readNumber(char clue, Aon.Factory fac, AonReader in, StringBuffer buf) throws IOException {
        buf.setLength(0);
        char ch = clue;
        boolean hasDecimal = false;
        boolean hasMore = true;
        block4: while (hasMore) {
            switch (ch) {
                case '.': 
                case 'E': 
                case 'e': {
                    hasDecimal = true;
                }
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    buf.append(ch);
                    ch = (char)in.read();
                    continue block4;
                }
            }
            in.unread();
            hasMore = false;
        }
        if (hasDecimal) {
            return fac.make(Double.parseDouble(buf.toString()));
        }
        long l = Long.parseLong(buf.toString());
        if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
            return fac.make((int)l);
        }
        return fac.make(l);
    }

    private static void readString(AonReader in, StringBuffer buf) throws IOException {
        buf.setLength(0);
        char ch = (char)in.read();
        while (ch != '\"') {
            if (ch == '\\') {
                ch = (char)in.read();
                switch (ch) {
                    case 'u': {
                        ch = AonIo.readUnicode(in);
                        break;
                    }
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case '\"': 
                    case '/': 
                    case '\\': {
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected escape: \\" + ch);
                    }
                }
            }
            buf.append(ch);
            ch = (char)in.read();
        }
    }

    private static char readUnicode(AonReader in) throws IOException {
        int ret = 0;
        block5: for (int i = 0; i < 4; ++i) {
            int ch = in.read();
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    ret = (ret << 4) + ch - 48;
                    continue block5;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    ret = (ret << 4) + (ch - 97) + 10;
                    continue block5;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    ret = (ret << 4) + (ch - 65) + 10;
                    continue block5;
                }
                default: {
                    throw new IOException("Illegal character in unicode escape: " + (char)ch);
                }
            }
        }
        return (char)ret;
    }

    private static Aobj readValue(Aon.Factory fac, AonReader in, StringBuffer buf) throws IOException {
        char ch = AonIo.readNextClue(in);
        switch (ch) {
            case '[': {
                return AonIo.readList(fac, in, buf);
            }
            case '{': {
                return AonIo.readMap(fac, in, buf);
            }
            case '\"': {
                AonIo.readString(in, buf);
                String str = buf.toString();
                if (str.length() > 0 && str.charAt(0) == '\u001b') {
                    if (str.equals("\u001bNaN")) {
                        return fac.make(Double.NaN);
                    }
                    if (str.equals("\u001b-Infinity")) {
                        return fac.make(Double.NEGATIVE_INFINITY);
                    }
                    if (str.equals("\u001bInfinity")) {
                        return fac.make(Double.POSITIVE_INFINITY);
                    }
                }
                return fac.make(str);
            }
            case 't': {
                AonIo.validate(in.read(), 'r');
                AonIo.validate(in.read(), 'u');
                AonIo.validate(in.read(), 'e');
                return fac.make(true);
            }
            case 'f': {
                AonIo.validate(in.read(), 'a');
                AonIo.validate(in.read(), 'l');
                AonIo.validate(in.read(), 's');
                AonIo.validate(in.read(), 'e');
                return fac.make(false);
            }
            case 'n': {
                AonIo.validate(in.read(), 'u');
                AonIo.validate(in.read(), 'l');
                AonIo.validate(in.read(), 'l');
                return Aon.makeNull();
            }
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return AonIo.readNumber(ch, fac, in, buf);
            }
        }
        in.unread();
        return null;
    }

    private static void validate(int ch1, char ch2) throws IOException {
        char ch = (char)ch1;
        if (ch != ch2) {
            throw new IOException("Expecting " + ch2 + ", but got " + ch);
        }
    }

    private static void write(Aobj obj, PrintWriter out, boolean minify, int indent) {
        switch (obj.getTypeCode()) {
            case 0: {
                out.print(obj.toBoolean());
                break;
            }
            case 1: {
                double d = obj.toDouble();
                if (Double.isInfinite(d)) {
                    if (d < 0.0) {
                        AonIo.write("\u001b-Infinity", out);
                        break;
                    }
                    AonIo.write("\u001bInfinity", out);
                    break;
                }
                if (Double.isNaN(d)) {
                    AonIo.write("\u001bNaN", out);
                    break;
                }
                out.print(d);
                break;
            }
            case 2: {
                out.print(obj.toInt());
                break;
            }
            case 3: {
                out.print('[');
                boolean first = true;
                indent += 2;
                Iterator<Aobj> listIt = obj.toList().iterator();
                while (listIt.hasNext()) {
                    Aobj o = listIt.next();
                    if (first) {
                        first = false;
                        if (!minify) {
                            out.println();
                        }
                    } else {
                        out.print(',');
                        if (!minify) {
                            out.println();
                        }
                    }
                    if (!minify) {
                        AonIo.writeIndent(indent, out);
                    }
                    AonIo.write(o, out, minify, indent);
                }
                if (!minify) {
                    out.println();
                    AonIo.writeIndent(indent - 2, out);
                }
                out.print(']');
                break;
            }
            case 4: {
                out.print(obj.toLong());
                break;
            }
            case 5: {
                out.print('{');
                indent += 2;
                boolean begin = true;
                Amap map = obj.toMap();
                Iterator<String> mapIt = map.iterator();
                while (mapIt.hasNext()) {
                    if (!begin) {
                        out.print(',');
                    } else {
                        begin = false;
                    }
                    if (!minify) {
                        out.println();
                        AonIo.writeIndent(indent, out);
                    }
                    String key = mapIt.next();
                    AonIo.write(key, out);
                    if (minify) {
                        out.print(':');
                    } else {
                        out.print(" : ");
                    }
                    AonIo.write(map.get(key), out, minify, indent);
                }
                if (!minify) {
                    out.println();
                    AonIo.writeIndent(indent - 2, out);
                }
                out.print('}');
                break;
            }
            case 6: {
                out.print(obj.toString());
                break;
            }
            case 7: {
                AonIo.write(obj.toString(), out);
            }
        }
    }

    private static void writeIndent(int indent, PrintWriter out) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
    }

    private static void writeUnicode(char ch, PrintWriter out) {
        out.write(92);
        out.write(117);
        out.write(HEX[ch >>> 12 & 0xF]);
        out.write(HEX[ch >>> 8 & 0xF]);
        out.write(HEX[ch >>> 4 & 0xF]);
        out.write(HEX[ch & 0xF]);
    }
}

