/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.algorithm.BDataSourceBlock;
import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.util.Utils;
import java.util.logging.Level;
import javax.baja.nav.BINavNode;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;

public class BValueTagDataSourceBlock
extends BDataSourceBlock {
    public static final Type TYPE = Sys.loadType(BValueTagDataSourceBlock.class);
    private AnalyticContext cx = new AnalyticContext().setHistory(false);

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        Slot hisTot = this.getSlot("hisTotalization");
        this.setFlags(hisTot, hisTot.getDefaultFlags() ^ 4);
    }

    @Override
    public boolean isAvailable(BINavNode node) {
        Id id = this.getDataId();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(id, true, this.cx);
        if (source != null) {
            return true;
        }
        AlgorithmBlock fb = this.getInput(0);
        if (fb != null) {
            return fb.isAvailable(node);
        }
        if (Utils.log().isLoggable(Level.FINER)) {
            BINavNode parent = this.getNavParent();
            String debugTrace = BValueTagDataSourceBlock.prepareLogMessage(node, this.getDataId(), parent);
            if (debugTrace != null && !debugTrace.isEmpty()) {
                BAnalyticService.RequestContext.getReqMessages().get().add(debugTrace);
            }
        }
        return false;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        if (cx != null) {
            cx.setHistory(false);
        }
        return super.getTrend(cx);
    }

    @Override
    protected AnalyticContext prepare(AnalyticContext cx) {
        AnalyticContext ret = super.prepare(cx);
        ret.setHistory(false);
        return ret;
    }
}

