/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BUniMathOperator
extends BFrozenEnum {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int CEIL = 3;
    public static final int COS = 4;
    public static final int EXP = 5;
    public static final int FLOOR = 6;
    public static final int LOG = 7;
    public static final int NEGATE = 8;
    public static final int ROUND = 9;
    public static final int SIN = 10;
    public static final int SQRT = 11;
    public static final int TAN = 12;
    public static final int TO_DEGREES = 13;
    public static final int TO_RADIANS = 14;
    public static final BUniMathOperator abs = new BUniMathOperator(0);
    public static final BUniMathOperator acos = new BUniMathOperator(1);
    public static final BUniMathOperator asin = new BUniMathOperator(2);
    public static final BUniMathOperator ceil = new BUniMathOperator(3);
    public static final BUniMathOperator cos = new BUniMathOperator(4);
    public static final BUniMathOperator exp = new BUniMathOperator(5);
    public static final BUniMathOperator floor = new BUniMathOperator(6);
    public static final BUniMathOperator log = new BUniMathOperator(7);
    public static final BUniMathOperator negate = new BUniMathOperator(8);
    public static final BUniMathOperator round = new BUniMathOperator(9);
    public static final BUniMathOperator sin = new BUniMathOperator(10);
    public static final BUniMathOperator sqrt = new BUniMathOperator(11);
    public static final BUniMathOperator tan = new BUniMathOperator(12);
    public static final BUniMathOperator toDegrees = new BUniMathOperator(13);
    public static final BUniMathOperator toRadians = new BUniMathOperator(14);
    public static final BUniMathOperator DEFAULT = abs;
    public static final Type TYPE = Sys.loadType(BUniMathOperator.class);

    public static BUniMathOperator make(int ordinal) {
        return (BUniMathOperator)abs.getRange().get(ordinal, false);
    }

    public static BUniMathOperator make(String tag) {
        return (BUniMathOperator)abs.getRange().get(tag);
    }

    private BUniMathOperator(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public double evaluate(double val) {
        double res = val;
        switch (this.getOrdinal()) {
            case 0: {
                res = Math.abs(val);
                break;
            }
            case 1: {
                res = Math.acos(val);
                break;
            }
            case 2: {
                res = Math.asin(val);
                break;
            }
            case 3: {
                res = Math.ceil(val);
                break;
            }
            case 4: {
                res = Math.cos(val);
                break;
            }
            case 5: {
                res = Math.exp(val);
                break;
            }
            case 6: {
                res = Math.floor(val);
                break;
            }
            case 7: {
                res = Math.log(val);
                break;
            }
            case 8: {
                res = -val;
                break;
            }
            case 9: {
                res = Math.rint(val);
                break;
            }
            case 10: {
                res = Math.sin(val);
                break;
            }
            case 11: {
                res = Math.sqrt(val);
                break;
            }
            case 12: {
                res = Math.tan(val);
                break;
            }
            case 13: {
                res = Math.toDegrees(val);
                break;
            }
            case 14: {
                res = Math.toRadians(val);
            }
        }
        return res;
    }
}

