/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.algorithm.BTimeRangePart;
import com.tridiumx.analytics.algorithm.BTimeUnit;
import com.tridiumx.analytics.time.TimeBinding;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BAnalyticTimeRange;

public class BTimeRangeOffsetBlock
extends BOutputBlock {
    public static final Property in = BTimeRangeOffsetBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property quantity = BTimeRangeOffsetBlock.newProperty((int)8, (int)-1, null);
    public static final Property timeUnit = BTimeRangeOffsetBlock.newProperty((int)8, (BValue)BTimeUnit.years, null);
    public static final Property timeRangePart = BTimeRangeOffsetBlock.newProperty((int)8, (BValue)BTimeRangePart.both, null);
    public static final Type TYPE = Sys.loadType(BTimeRangeOffsetBlock.class);

    public BBlockPin getIn() {
        return (BBlockPin)this.get(in);
    }

    public void setIn(BBlockPin v) {
        this.set(in, (BValue)v, null);
    }

    public int getQuantity() {
        return this.getInt(quantity);
    }

    public void setQuantity(int v) {
        this.setInt(quantity, v, null);
    }

    public BTimeUnit getTimeUnit() {
        return (BTimeUnit)this.get(timeUnit);
    }

    public void setTimeUnit(BTimeUnit v) {
        this.set(timeUnit, (BValue)v, null);
    }

    public BTimeRangePart getTimeRangePart() {
        return (BTimeRangePart)this.get(timeRangePart);
    }

    public void setTimeRangePart(BTimeRangePart v) {
        this.set(timeRangePart, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        return this.getInput(0).getValue(this.prepareContext(cx));
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        AnalyticContext cxInner = this.prepareContext(cx);
        AnalyticTrend trend = this.getInput(0).getTrend(cxInner);
        trend.setContext(cxInner);
        return trend;
    }

    private long adjust(long time, int qty) {
        if (time <= 0L) {
            return time;
        }
        switch (this.getTimeUnit().getOrdinal()) {
            case 0: {
                return TimeBinding.addSeconds(qty, time);
            }
            case 1: {
                return TimeBinding.addMinutes(qty, time);
            }
            case 2: {
                return TimeBinding.addHours(qty, time);
            }
            case 3: {
                return TimeBinding.addDays(qty, time);
            }
            case 4: {
                return TimeBinding.addWeeks(qty, time);
            }
            case 5: {
                return TimeBinding.addMonths(qty, time);
            }
            case 6: {
                return TimeBinding.addYears(qty, time);
            }
        }
        return time;
    }

    private AnalyticContext prepareContext(AnalyticContext cx) {
        cx = new AnalyticContextWrapper(cx);
        long start = cx.getStartTime();
        long end = cx.getEndTime();
        if (end < 0L) {
            end = System.currentTimeMillis();
        }
        switch (this.getTimeRangePart().getOrdinal()) {
            case 0: {
                end = this.adjust(end, this.getQuantity());
                start = this.adjust(start, this.getQuantity());
                break;
            }
            case 1: {
                start = this.adjust(start, this.getQuantity());
                if (start <= end) break;
                start = end;
                break;
            }
            case 2: {
                end = this.adjust(end, this.getQuantity());
                if (end >= start) break;
                end = start;
            }
        }
        cx.setTimeRange(BAnalyticTimeRange.make(BAbsTime.make((long)start), BAbsTime.make((long)end)));
        return cx;
    }
}

