/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.util.Utils;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BAnalyticTimeRange;

public class BRollupBlock
extends BOutputBlock {
    public static final Property trendIn = BRollupBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property rollup = BRollupBlock.newProperty((int)8, (BValue)BCombination.first, null);
    public static final Property timeRange = BRollupBlock.newProperty((int)8, (BValue)BAnalyticTimeRange.make("current30days"), null);
    public static final Property useRequestRollup = BRollupBlock.newProperty((int)8, (boolean)false, null);
    public static final Property useRequestTimeRange = BRollupBlock.newProperty((int)8, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BRollupBlock.class);

    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    public BCombination getRollup() {
        return (BCombination)this.get(rollup);
    }

    public void setRollup(BCombination v) {
        this.set(rollup, (BValue)v, null);
    }

    public BAnalyticTimeRange getTimeRange() {
        return (BAnalyticTimeRange)this.get(timeRange);
    }

    public void setTimeRange(BAnalyticTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    public boolean getUseRequestRollup() {
        return this.getBoolean(useRequestRollup);
    }

    public void setUseRequestRollup(boolean v) {
        this.setBoolean(useRequestRollup, v, null);
    }

    public boolean getUseRequestTimeRange() {
        return this.getBoolean(useRequestTimeRange);
    }

    public void setUseRequestTimeRange(boolean v) {
        this.setBoolean(useRequestTimeRange, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue val;
        cx = this.prepareContext(cx);
        if (!this.getInput(0).hasTrend(cx)) {
            return this.getInput(0).getValue(cx);
        }
        AnalyticTrend trend = this.getInput(0).getTrend(cx);
        Combiner roll = null;
        roll = this.getUseRequestRollup() ? cx.getRollup(true).makeCombiner() : this.getRollup().makeCombiner();
        long end = cx.getEndTime();
        while (trend.hasNext() && !Utils.isEnded((val = trend.next()).getTimestamp(), end)) {
            roll.update(val);
        }
        return roll.getValue();
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        cx = this.prepareContext(cx);
        return this.getInput(0).getTrend(cx);
    }

    private AnalyticContext prepareContext(AnalyticContext cx) {
        cx = new AnalyticContextWrapper(cx);
        if (!this.getUseRequestTimeRange() || cx.getTimeRange(false) == null) {
            cx.setTimeRange(this.getTimeRange());
        }
        if (!this.getUseRequestRollup()) {
            cx.setRollup(this.getRollup());
        }
        return cx;
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        return this.getInput(0).hasTrend(cx);
    }
}

