/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.data.BooleanValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class BRangeSwitchBlock
extends BOutputBlock {
    public static final Property testIn = BRangeSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property highLimitIn = BRangeSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property lowLimitIn = BRangeSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property trueIn = BRangeSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property falseIn = BRangeSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Type TYPE = Sys.loadType(BRangeSwitchBlock.class);

    public BBlockPin getTestIn() {
        return (BBlockPin)this.get(testIn);
    }

    public void setTestIn(BBlockPin v) {
        this.set(testIn, (BValue)v, null);
    }

    public BBlockPin getHighLimitIn() {
        return (BBlockPin)this.get(highLimitIn);
    }

    public void setHighLimitIn(BBlockPin v) {
        this.set(highLimitIn, (BValue)v, null);
    }

    public BBlockPin getLowLimitIn() {
        return (BBlockPin)this.get(lowLimitIn);
    }

    public void setLowLimitIn(BBlockPin v) {
        this.set(lowLimitIn, (BValue)v, null);
    }

    public BBlockPin getTrueIn() {
        return (BBlockPin)this.get(trueIn);
    }

    public void setTrueIn(BBlockPin v) {
        this.set(trueIn, (BValue)v, null);
    }

    public BBlockPin getFalseIn() {
        return (BBlockPin)this.get(falseIn);
    }

    public void setFalseIn(BBlockPin v) {
        this.set(falseIn, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getInputDefault(int idx, AnalyticContext cx) {
        if (idx == 3) {
            return new BooleanValue(System.currentTimeMillis(), true, 0);
        }
        return new BooleanValue(System.currentTimeMillis(), false, 0);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue in = this.getInput(0).getValue(cx);
        AnalyticValue high = this.getInput(1).getValue(cx);
        double inVal = in.toNumeric();
        if (inVal > high.toNumeric()) {
            return this.getInputValue(4, cx).orStatus(in).orStatus(high);
        }
        AnalyticValue low = this.getInput(2).getValue(cx);
        if (inVal < low.toNumeric()) {
            return this.getInputValue(4, cx).orStatus(in).orStatus(low);
        }
        return this.getInputValue(3, cx).orStatus(in).orStatus(high).orStatus(low);
    }

    @Override
    public boolean isInputRequired(int idx) {
        return idx < 3;
    }

    private static class MyTrend
    extends BlockTrend {
        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            AnalyticValue in = this.getValue(0);
            AnalyticValue high = this.getValue(1);
            double inVal = in.toNumeric();
            if (inVal > high.toNumeric()) {
                return this.getValue(4).orStatus(in).orStatus(high);
            }
            AnalyticValue low = this.getValue(2);
            if (inVal < low.toNumeric()) {
                return this.getValue(4).orStatus(in).orStatus(low);
            }
            return this.getValue(3).orStatus(in).orStatus(high).orStatus(low);
        }
    }
}

