/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.time.TimeBinding;
import com.tridiumx.analytics.trend.SimpleTrend;
import com.tridiumx.analytics.util.Utils;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BAnalyticTimeRange;

public class BDayBuilderBlock
extends BOutputBlock {
    public static final Property trendIn = BDayBuilderBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property rollup = BDayBuilderBlock.newProperty((int)8, (BValue)BCombination.first, null);
    public static final Property timeRange = BDayBuilderBlock.newProperty((int)8, (BValue)BAnalyticTimeRange.make("previous60days"), null);
    public static final Property useRequestRollup = BDayBuilderBlock.newProperty((int)8, (boolean)true, null);
    public static final Property useRequestTimeRange = BDayBuilderBlock.newProperty((int)8, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BDayBuilderBlock.class);

    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    public BCombination getRollup() {
        return (BCombination)this.get(rollup);
    }

    public void setRollup(BCombination v) {
        this.set(rollup, (BValue)v, null);
    }

    public BAnalyticTimeRange getTimeRange() {
        return (BAnalyticTimeRange)this.get(timeRange);
    }

    public void setTimeRange(BAnalyticTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    public boolean getUseRequestRollup() {
        return this.getBoolean(useRequestRollup);
    }

    public void setUseRequestRollup(boolean v) {
        this.setBoolean(useRequestRollup, v, null);
    }

    public boolean getUseRequestTimeRange() {
        return this.getBoolean(useRequestTimeRange);
    }

    public void setUseRequestTimeRange(boolean v) {
        this.setBoolean(useRequestTimeRange, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        Combiner rollup;
        Long key;
        AnalyticValue val;
        AnalyticTrend trend = this.getInput(0).getTrend(this.prepareContext(cx));
        cx = trend.getContext();
        TreeMap<Long, Combiner> map = new TreeMap<Long, Combiner>();
        long today = TimeBinding.alignDay(TimeBinding.now());
        long end = cx.getEndTime();
        while (trend.hasNext() && !Utils.isEnded((val = trend.next()).getTimestamp(), end)) {
            key = today + (long)TimeBinding.getTimeOfDay(val.getTimestamp());
            rollup = (Combiner)map.get(key);
            if (rollup == null) {
                rollup = this.getUseRequestRollup() ? cx.getRollup(true).makeCombiner() : this.getRollup().makeCombiner();
                map.put(key, rollup);
            }
            rollup.update(val);
        }
        AnalyticContextWrapper w = new AnalyticContextWrapper(cx);
        w.setTimeRange(BAnalyticTimeRange.today);
        SimpleTrend ret = new SimpleTrend(w);
        for (Map.Entry me : map.entrySet()) {
            key = (Long)me.getKey();
            rollup = (Combiner)me.getValue();
            AnalyticValue res = rollup.getValue();
            res.setTimestamp(key);
            ret.add(res);
        }
        return ret;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        return Utils.rollup(this.getTrend(cx));
    }

    private AnalyticContext prepareContext(AnalyticContext cx) {
        if (cx.getTimeRange(false) == null || !this.getUseRequestTimeRange()) {
            cx = new AnalyticContextWrapper(cx);
            cx.setTimeRange(this.getTimeRange());
        }
        return cx;
    }
}

