/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.data.UnitConverter;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.trend.EmptyTrend;
import com.tridiumx.analytics.trend.FunctionTrend;
import com.tridiumx.analytics.util.BOptionalSimple;
import com.tridiumx.analytics.util.Utils;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;

public class BDataSourceBlock
extends BOutputBlock {
    public static final Property fallbackIn = BDataSourceBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    public static final Property data = BDataSourceBlock.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:DataFe")));
    public static final Property useRequestAggregation = BDataSourceBlock.newProperty((int)8, (boolean)false, null);
    public static final Property useRequestDataFilter = BDataSourceBlock.newProperty((int)8, (boolean)false, null);
    public static final Property useRequestRollup = BDataSourceBlock.newProperty((int)8, (boolean)false, null);
    public static final Property useRequestTotalize = BDataSourceBlock.newProperty((int)8, (boolean)false, null);
    public static final Property aggregation = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BCombination.first), null);
    public static final Property dataFilter = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BString.DEFAULT), null);
    public static final Property relationId = BDataSourceBlock.newProperty((int)4, (BValue)new BOptionalSimple(false, (BSimple)BString.DEFAULT), null);
    public static final Property rollup = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BCombination.first), null);
    public static final Property totalize = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BBoolean.TRUE), null);
    public static final Property unitConversion = BDataSourceBlock.newProperty((int)8, (BValue)new BOptionalSimple(false, (BSimple)BUnit.NULL), null);
    public static final Type TYPE = Sys.loadType(BDataSourceBlock.class);
    private static AcceptAll acceptAll = new AcceptAll();
    private Id id;

    public BBlockPin getFallbackIn() {
        return (BBlockPin)this.get(fallbackIn);
    }

    public void setFallbackIn(BBlockPin v) {
        this.set(fallbackIn, (BValue)v, null);
    }

    public String getData() {
        return this.getString(data);
    }

    public void setData(String v) {
        this.setString(data, v, null);
    }

    public boolean getUseRequestAggregation() {
        return this.getBoolean(useRequestAggregation);
    }

    public void setUseRequestAggregation(boolean v) {
        this.setBoolean(useRequestAggregation, v, null);
    }

    public boolean getUseRequestDataFilter() {
        return this.getBoolean(useRequestDataFilter);
    }

    public void setUseRequestDataFilter(boolean v) {
        this.setBoolean(useRequestDataFilter, v, null);
    }

    public boolean getUseRequestRollup() {
        return this.getBoolean(useRequestRollup);
    }

    public void setUseRequestRollup(boolean v) {
        this.setBoolean(useRequestRollup, v, null);
    }

    public boolean getUseRequestTotalize() {
        return this.getBoolean(useRequestTotalize);
    }

    public void setUseRequestTotalize(boolean v) {
        this.setBoolean(useRequestTotalize, v, null);
    }

    public BOptionalSimple getAggregation() {
        return (BOptionalSimple)this.get(aggregation);
    }

    public void setAggregation(BOptionalSimple v) {
        this.set(aggregation, (BValue)v, null);
    }

    public BOptionalSimple getDataFilter() {
        return (BOptionalSimple)this.get(dataFilter);
    }

    public void setDataFilter(BOptionalSimple v) {
        this.set(dataFilter, (BValue)v, null);
    }

    public BOptionalSimple getRelationId() {
        return (BOptionalSimple)this.get(relationId);
    }

    public void setRelationId(BOptionalSimple v) {
        this.set(relationId, (BValue)v, null);
    }

    public BOptionalSimple getRollup() {
        return (BOptionalSimple)this.get(rollup);
    }

    public void setRollup(BOptionalSimple v) {
        this.set(rollup, (BValue)v, null);
    }

    public BOptionalSimple getTotalize() {
        return (BOptionalSimple)this.get(totalize);
    }

    public void setTotalize(BOptionalSimple v) {
        this.set(totalize, (BValue)v, null);
    }

    public BOptionalSimple getUnitConversion() {
        return (BOptionalSimple)this.get(unitConversion);
    }

    public void setUnitConversion(BOptionalSimple v) {
        this.set(unitConversion, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (p.equals(data)) {
            this.id = null;
        }
        super.changed(p, cx);
    }

    public Id getDataId() {
        if (this.id == null) {
            this.id = Id.newId((String)this.getData());
        }
        return this.id;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        BINavNode node = cx.getNode();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(this.getDataId(), true, cx);
        if (source == null || !source.hasTrend(cx) || Values.isNull(source.getValue(cx).getStatus())) {
            AlgorithmBlock fb = this.getInput(0);
            if (Utils.log().isLoggable(Level.FINER) && fb == null) {
                BINavNode parent = this.getNavParent();
                String debugTrace = BDataSourceBlock.prepareLogMessage(node, this.getDataId(), parent);
                if (debugTrace != null && !debugTrace.isEmpty()) {
                    BAnalyticService.RequestContext.getReqMessages().get().add(debugTrace);
                }
            }
            if (fb != null) {
                Logger.getLogger("analytics").log(Level.INFO, "Using Fallback for trend request as data source " + this.getData() + " is not available");
                return fb.getTrend(cx);
            }
            return new EmptyTrend(cx);
        }
        AnalyticTrend trend = source.getTrend(this.prepare(cx));
        UnitConverter conv = this.getConverter(trend.getContext());
        if (conv == null) {
            return trend;
        }
        return new FunctionTrend(conv, trend);
    }

    protected static String prepareLogMessage(BINavNode node, Id id, BINavNode parent) {
        AnalyticContext oCx;
        String nodeName = null;
        String dataStr = null;
        String algName = null;
        String aSource = null;
        if (parent != null) {
            algName = parent.getNavName();
        }
        if (node != null && node.getNavOrd() != null) {
            nodeName = node.getNavOrd().toString();
        }
        if (id != null) {
            dataStr = id.getQName();
        }
        if (BAnalyticService.RequestContext.getReqOrigin() != null) {
            aSource = BAnalyticService.RequestContext.getReqOrigin().get();
        }
        if ((oCx = BAnalyticService.RequestContext.getReqAnalyticContext().get()) != null && oCx.getNode() != null && oCx.getNode().equals(node)) {
            return Utils.prepareDebugMessage(aSource, dataStr, nodeName, algName, null);
        }
        return null;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        BINavNode node = cx.getNode();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(this.getDataId(), true, cx);
        if (source == null || Values.isNull(source.getValue(cx).getStatus())) {
            AlgorithmBlock fb = this.getInput(0);
            if (Utils.log().isLoggable(Level.FINER) && fb == null) {
                BINavNode parent = this.getNavParent();
                String debugTrace = BDataSourceBlock.prepareLogMessage(node, this.getDataId(), parent);
                if (debugTrace != null && !debugTrace.isEmpty()) {
                    BAnalyticService.RequestContext.getReqMessages().get().add(debugTrace);
                }
            }
            if (fb != null) {
                Logger.getLogger("analytics").log(Level.INFO, "Using Fallback for value request as data source " + this.getData() + " is not available");
                return fb.getValue(cx);
            }
            return new NumericValue(0.0, 64);
        }
        UnitConverter conv = this.getConverter(cx = this.prepare(cx));
        if (conv != null) {
            return conv.apply(source.getValue(cx));
        }
        return source.getValue(cx);
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        BINavNode node = cx.getNode();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(this.getDataId(), true, cx);
        cx = this.prepare(cx);
        if (source != null && source.hasTrend(cx)) {
            return true;
        }
        int len = this.getInputCount();
        for (int i = 0; i < len; ++i) {
            AlgorithmBlock input = this.getInput(i);
            if (input == null || !input.hasTrend(cx)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAvailable(BINavNode node) {
        Id id = this.getDataId();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(id, true, null);
        if (source != null) {
            return true;
        }
        AlgorithmBlock fb = this.getInput(0);
        if (fb != null) {
            return fb.isAvailable(node);
        }
        if (Utils.log().isLoggable(Level.FINER)) {
            BINavNode parent = this.getNavParent();
            String debugTrace = BDataSourceBlock.prepareLogMessage(node, this.getDataId(), parent);
            if (debugTrace != null && !debugTrace.isEmpty()) {
                BAnalyticService.RequestContext.getReqMessages().get().add(debugTrace);
            }
        }
        return false;
    }

    @Override
    public boolean isInputRequired(int idx) {
        return false;
    }

    protected AnalyticContext prepare(AnalyticContext cx) {
        String idStr;
        AnalyticContextWrapper ret = new AnalyticContextWrapper(cx);
        ret.setData(this.getDataId());
        if (this.getRelationId().getHasValue() && (idStr = this.getRelationId().getValue().toString(null)).length() > 0) {
            Entity tmp;
            Optional rel;
            Id id = Id.newId((String)idStr);
            BINavNode node = cx.getNode();
            if (node instanceof Entity && (rel = ((Entity)node).relations().get(id)).isPresent() && (tmp = ((Relation)rel.get()).getEndpoint()) instanceof BINavNode) {
                ret.setNode((BINavNode)tmp);
            }
        }
        if (!this.getUseRequestDataFilter()) {
            if (this.getDataFilter().getHasValue()) {
                String neql = this.getDataFilter().getValue().toString(null);
                if (neql.length() > 0) {
                    ret.setDataFilter(neql);
                } else {
                    ret.setDataFilter(acceptAll);
                }
            } else {
                ret.setDataFilter(acceptAll);
            }
        }
        if (this.getUseRequestAggregation()) {
            ret.setAggregation(cx.getAggregation(true));
        } else if (this.getAggregation().getHasValue()) {
            ret.setAggregation((BCombination)this.getAggregation().getValue());
        } else {
            ret.setAggregation(ret.getDataPolicy().getDefaultAggregation());
        }
        if (this.getUseRequestRollup()) {
            ret.setRollup(cx.getRollup(true));
        } else if (this.getRollup().getHasValue()) {
            ret.setRollup((BCombination)this.getRollup().getValue());
        } else {
            ret.setRollup(ret.getDataPolicy().getDefaultRollup());
        }
        ret.setUseCache(false);
        if (this.getUnitConversion().getHasValue()) {
            ret.setUnit((BUnit)this.getUnitConversion().getValue());
        }
        if (this.getUseRequestTotalize()) {
            ret.setHisTotEnabled(cx.getHisTotEnabled());
        } else if (this.getTotalize().getHasValue()) {
            ret.setHisTotEnabled(((BBoolean)this.getTotalize().getValue()).getBoolean());
        } else {
            ret.setHisTotEnabled(true);
        }
        return ret;
    }

    private UnitConverter getConverter(AnalyticContext cx) {
        if (!this.getUnitConversion().getHasValue()) {
            return null;
        }
        BUnit to = (BUnit)this.getUnitConversion().getValue();
        return UnitConverter.make(cx.getUnit(true), to);
    }

    private static class AcceptAll
    implements Predicate<Entity> {
        private AcceptAll() {
        }

        @Override
        public boolean test(Entity e) {
            return true;
        }

        public String toString() {
            return "";
        }
    }
}

