/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.data.AnalyticValue;

public final class BBooleanOperator
extends BFrozenEnum {
    public static final int EQUAL = 0;
    public static final int GREATER_THAN = 1;
    public static final int GREATER_THAN_EQUAL_TO = 2;
    public static final int LESS_THAN = 3;
    public static final int LESS_THAN_EQUAL_TO = 4;
    public static final int NOT_EQUAL = 5;
    public static final int AND = 6;
    public static final int OR = 7;
    public static final BBooleanOperator equal = new BBooleanOperator(0);
    public static final BBooleanOperator greaterThan = new BBooleanOperator(1);
    public static final BBooleanOperator greaterThanEqualTo = new BBooleanOperator(2);
    public static final BBooleanOperator lessThan = new BBooleanOperator(3);
    public static final BBooleanOperator lessThanEqualTo = new BBooleanOperator(4);
    public static final BBooleanOperator notEqual = new BBooleanOperator(5);
    public static final BBooleanOperator and = new BBooleanOperator(6);
    public static final BBooleanOperator or = new BBooleanOperator(7);
    public static final BBooleanOperator DEFAULT = equal;
    public static final Type TYPE = Sys.loadType(BBooleanOperator.class);

    public static BBooleanOperator make(int ordinal) {
        return (BBooleanOperator)equal.getRange().get(ordinal, false);
    }

    public static BBooleanOperator make(String tag) {
        return (BBooleanOperator)equal.getRange().get(tag);
    }

    private BBooleanOperator(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean evaluate(AnalyticValue first, AnalyticValue second) {
        switch (this.getOrdinal()) {
            case 6: 
            case 7: {
                return this.booleans(first.toBoolean(), second.toBoolean());
            }
            case 0: {
                return first.valueEquals(second);
            }
            case 5: {
                return !first.valueEquals(second);
            }
        }
        return this.numerics(first.toNumeric(), second.toNumeric());
    }

    public String symbol() {
        switch (this.getOrdinal()) {
            case 0: {
                return "==";
            }
            case 1: {
                return ">";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<";
            }
            case 4: {
                return "<=";
            }
            case 5: {
                return "!=";
            }
            case 6: {
                return "&";
            }
            case 7: {
                return "|";
            }
        }
        return "???";
    }

    private boolean booleans(boolean first, boolean second) {
        switch (this.getOrdinal()) {
            case 6: {
                return first && second;
            }
            case 7: {
                return first || second;
            }
        }
        return false;
    }

    private boolean bothInvalid(double first, double second) {
        return this.isInvalid(first) && this.isInvalid(second);
    }

    private boolean isInvalid(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        return Double.isInfinite(val);
    }

    private boolean numerics(double first, double second) {
        switch (this.getOrdinal()) {
            case 3: {
                return first < second;
            }
            case 4: {
                if (first <= second) {
                    return true;
                }
                return this.bothInvalid(first, second);
            }
            case 1: {
                return first > second;
            }
        }
        if (first >= second) {
            return true;
        }
        return this.bothInvalid(first, second);
    }
}

