/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics;

import com.tridium.util.ComponentTreeCursor;
import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.Analytics;
import com.tridiumx.analytics.BChartRenderLimitConfiguration;
import com.tridiumx.analytics.alert.AlertEntry;
import com.tridiumx.analytics.alert.BAlertFolder;
import com.tridiumx.analytics.alert.BAnalyticAlert;
import com.tridiumx.analytics.algorithm.Algorithm;
import com.tridiumx.analytics.algorithm.BAlgorithm;
import com.tridiumx.analytics.algorithm.BAlgorithmFolder;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.data.AnalyticDataPolicy;
import com.tridiumx.analytics.data.AnalyticDataSource;
import com.tridiumx.analytics.data.BAnalyticDataFolder;
import com.tridiumx.analytics.data.DefaultPolicy;
import com.tridiumx.analytics.data.NodeInfo;
import com.tridiumx.analytics.data.UnitConverter;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.license.BAnalyticsSubscription;
import com.tridiumx.analytics.license.NAFFeatureUtil;
import com.tridiumx.analytics.point.BAnalyticProxyExt;
import com.tridiumx.analytics.poll.BAnalyticPoller;
import com.tridiumx.analytics.poll.BPollerFolder;
import com.tridiumx.analytics.report.BAnalyticReportFolder;
import com.tridiumx.analytics.trend.EmptyTrend;
import com.tridiumx.analytics.trend.ExitTrend;
import com.tridiumx.analytics.trend.IntervalTrend;
import com.tridiumx.analytics.util.Alarms;
import com.tridiumx.analytics.util.CachedTrend;
import com.tridiumx.analytics.util.KeyedCache;
import com.tridiumx.analytics.util.NeqlPredicate;
import com.tridiumx.analytics.util.Strings;
import com.tridiumx.analytics.util.ThreadPool;
import com.tridiumx.analytics.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMarker;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeSubscriber;
import javax.baja.tag.DataPolicy;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagInfo;
import javax.baja.tag.Taggable;
import javax.baja.tag.Tags;
import javax.baja.tagdictionary.BSimpleTagInfo;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.virtual.BVirtualGateway;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BAbsStartEndTime;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.Interval;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="rtVersion", type="String", defaultValue="", flags=3), @NiagaraProperty(name="wbVersion", type="String", defaultValue="", flags=3), @NiagaraProperty(name="uxVersion", type="String", defaultValue="", flags=3), @NiagaraProperty(name="alertCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="algorithmCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="pointCount", type="long", defaultValue="0", flags=3), @NiagaraProperty(name="proxyExtCount", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="caching", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="cacheBuilt", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="cachingStartupDelay", type="int", defaultValue="1"), @NiagaraProperty(name="autoTagAnalyticPoint", type="boolean", defaultValue="false"), @NiagaraProperty(name="limitAutoTagging", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="testCovNeql", type="String", defaultValue="hs:hisInterpolate = 'cov'"), @NiagaraProperty(name="testTotalizationNeql", type="String", defaultValue="hs:hisTotalized"), @NiagaraProperty(name="useHierarchyCache", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="areaTag", type="String", defaultValue="hs:area", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"analytics:DataFe\")")}), @NiagaraProperty(name="oatTag", type="String", defaultValue="hs:outsideAirTempSensor", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"analytics:DataFe\")")}), @NiagaraProperty(name="alerts", type="analytics:AlertFolder", defaultValue="new BAlertFolder()"), @NiagaraProperty(name="algorithms", type="analytics:AlgorithmFolder", defaultValue="new BAlgorithmFolder()"), @NiagaraProperty(name="definitions", type="analytics:AnalyticDataFolder", defaultValue="new BAnalyticDataFolder()"), @NiagaraProperty(name="pollers", type="analytics:PollerFolder", defaultValue="new BPollerFolder()"), @NiagaraProperty(name="hierCache", type="baja:Component", defaultValue="new BComponent()", flags=4), @NiagaraProperty(name="threadPriority", type="int", defaultValue="4", flags=4, facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="5")}), @NiagaraProperty(name="triggeredPollerConcurrency", type="int", defaultValue="2", flags=4, facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="15")}), @NiagaraProperty(name="skipDataSourceCache", type="boolean", defaultValue="false"), @NiagaraProperty(name="subscriptionAlarm", type="analytics:AnalyticsSubscription", defaultValue="new BAnalyticsSubscription()"), @NiagaraProperty(name="debugMode", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="reports", type="analytics:AnalyticReportFolder", defaultValue="new BAnalyticReportFolder()"), @NiagaraProperty(name="missingDataStrategy", type="analytics:MissingDataStrategy", defaultValue="new BMissingDataStrategy().enable()"), @NiagaraProperty(name="chartRenderCapacity", type="analytics:ChartRenderLimitConfiguration", defaultValue="new BChartRenderLimitConfiguration()", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="findData", parameterType="baja:Ord", returnType="baja:Blob", defaultValue="BOrd.NULL", flags=2052), @NiagaraAction(name="listPollers", returnType="baja:String", flags=2052), @NiagaraAction(name="refreshCache", flags=16), @NiagaraAction(name="stopCaching"), @NiagaraAction(name="houseKeeping", flags=2068), @NiagaraAction(name="getStartEndTimes", parameterType="baja:String", returnType="analytics:AbsStartEndTime", defaultValue="BString.DEFAULT", flags=260), @NiagaraAction(name="ackAlarm", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", returnType="baja:Boolean", flags=5)})
public final class BAnalyticService
extends BAbstractService
implements AnalyticConstants,
Analytics.Provider,
BIAlarmSource {
    public static final Property rtVersion = BAnalyticService.newProperty((int)3, (String)"", null);
    public static final Property wbVersion = BAnalyticService.newProperty((int)3, (String)"", null);
    public static final Property uxVersion = BAnalyticService.newProperty((int)3, (String)"", null);
    public static final Property alertCount = BAnalyticService.newProperty((int)3, (int)0, null);
    public static final Property algorithmCount = BAnalyticService.newProperty((int)3, (int)0, null);
    public static final Property pointCount = BAnalyticService.newProperty((int)3, (int)0, null);
    public static final Property proxyExtCount = BAnalyticService.newProperty((int)3, (int)0, null);
    public static final Property caching = BAnalyticService.newProperty((int)3, (boolean)false, null);
    public static final Property cacheBuilt = BAnalyticService.newProperty((int)3, (boolean)false, null);
    public static final Property cachingStartupDelay = BAnalyticService.newProperty((int)0, (int)1, null);
    public static final Property autoTagAnalyticPoint = BAnalyticService.newProperty((int)0, (boolean)false, null);
    public static final Property limitAutoTagging = BAnalyticService.newProperty((int)4, (boolean)true, null);
    public static final Property testCovNeql = BAnalyticService.newProperty((int)0, (String)"hs:hisInterpolate = 'cov'", null);
    public static final Property testTotalizationNeql = BAnalyticService.newProperty((int)0, (String)"hs:hisTotalized", null);
    public static final Property useHierarchyCache = BAnalyticService.newProperty((int)5, (boolean)false, null);
    public static final Property areaTag = BAnalyticService.newProperty((int)0, (String)"hs:area", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:DataFe")));
    public static final Property oatTag = BAnalyticService.newProperty((int)0, (String)"hs:outsideAirTempSensor", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"analytics:DataFe")));
    public static final Property alerts = BAnalyticService.newProperty((int)0, (BValue)new BAlertFolder(), null);
    public static final Property algorithms = BAnalyticService.newProperty((int)0, (BValue)new BAlgorithmFolder(), null);
    public static final Property definitions = BAnalyticService.newProperty((int)0, (BValue)new BAnalyticDataFolder(), null);
    public static final Property pollers = BAnalyticService.newProperty((int)0, (BValue)new BPollerFolder(), null);
    public static final Property hierCache = BAnalyticService.newProperty((int)4, (BValue)new BComponent(), null);
    public static final Property threadPriority = BAnalyticService.newProperty((int)4, (int)4, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)5)));
    public static final Property triggeredPollerConcurrency = BAnalyticService.newProperty((int)4, (int)2, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)15)));
    public static final Property skipDataSourceCache = BAnalyticService.newProperty((int)0, (boolean)false, null);
    public static final Property subscriptionAlarm = BAnalyticService.newProperty((int)0, (BValue)new BAnalyticsSubscription(), null);
    public static final Property debugMode = BAnalyticService.newProperty((int)4, (boolean)false, null);
    public static final Property reports = BAnalyticService.newProperty((int)0, (BValue)new BAnalyticReportFolder(), null);
    public static final Property missingDataStrategy = BAnalyticService.newProperty((int)0, (BValue)new BMissingDataStrategy().enable(), null);
    public static final Property chartRenderCapacity = BAnalyticService.newProperty((int)4, (BValue)new BChartRenderLimitConfiguration(), null);
    public static final Action findData = BAnalyticService.newAction((int)2052, (BValue)BOrd.NULL, null);
    public static final Action listPollers = BAnalyticService.newAction((int)2052, null);
    public static final Action refreshCache = BAnalyticService.newAction((int)16, null);
    public static final Action stopCaching = BAnalyticService.newAction((int)0, null);
    public static final Action houseKeeping = BAnalyticService.newAction((int)2068, null);
    public static final Action getStartEndTimes = BAnalyticService.newAction((int)260, (BValue)BString.DEFAULT, null);
    public static final Action ackAlarm = BAnalyticService.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BAnalyticService.class);
    public static final AtomicLong aPointCountGL = new AtomicLong(0L);
    private volatile AlarmState alarmState;
    private volatile int alarmBits;
    private volatile long lastUpdatedTime;
    private Lexicon lex = Lexicon.make(BAnalyticService.class);
    private AlarmSupport alarmSupport;
    private HashMap<Id, Algorithm> algoMap = new HashMap();
    private boolean cachesBuilt = true;
    private AtomicBoolean isCaching = new AtomicBoolean(false);
    private AtomicBoolean stopCachingRequested = new AtomicBoolean(false);
    private static BIcon icon = BIcon.std((String)"calculator.png");
    private static BAnalyticService instance;
    private volatile long lastCheck;
    private HashMap<Id, AnalyticDataPolicy> policyMap = new HashMap();
    private HashMap<String, BAnalyticPoller> pollerMap = new HashMap();
    private KeyedCache<String, Object> requestCache;
    private boolean steady = false;
    private static volatile BTagDictionaryService tagService;
    private Predicate<Entity> testCov;
    private Predicate<Entity> testTotalization;
    private ThreadPool threads = null;
    private ExecutorService pollerThreads = null;
    private static final String POLLER_TPOOL_NAME = "triggered-poller";
    private static final String ASERVICE_TPOOL_NAME = "Analytics";
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private final AtomicBoolean checking = new AtomicBoolean(false);
    private TypeSubscriber subscriber = null;
    private final AtomicLong aPointCount = new AtomicLong(0L);
    private long aPointLimit = 0L;
    public static long aPointLimitGL;
    public static final String DEFAULT_REQUEST_ORIGIN = "user request";

    public String getRtVersion() {
        return this.getString(rtVersion);
    }

    public void setRtVersion(String v) {
        this.setString(rtVersion, v, null);
    }

    public String getWbVersion() {
        return this.getString(wbVersion);
    }

    public void setWbVersion(String v) {
        this.setString(wbVersion, v, null);
    }

    public String getUxVersion() {
        return this.getString(uxVersion);
    }

    public void setUxVersion(String v) {
        this.setString(uxVersion, v, null);
    }

    public int getAlertCount() {
        return this.getInt(alertCount);
    }

    public void setAlertCount(int v) {
        this.setInt(alertCount, v, null);
    }

    public int getAlgorithmCount() {
        return this.getInt(algorithmCount);
    }

    public void setAlgorithmCount(int v) {
        this.setInt(algorithmCount, v, null);
    }

    public long getPointCount() {
        return this.getLong(pointCount);
    }

    public void setPointCount(long v) {
        this.setLong(pointCount, v, null);
    }

    public int getProxyExtCount() {
        return this.getInt(proxyExtCount);
    }

    public void setProxyExtCount(int v) {
        this.setInt(proxyExtCount, v, null);
    }

    public boolean getCaching() {
        return this.getBoolean(caching);
    }

    public void setCaching(boolean v) {
        this.setBoolean(caching, v, null);
    }

    public boolean getCacheBuilt() {
        return this.getBoolean(cacheBuilt);
    }

    public void setCacheBuilt(boolean v) {
        this.setBoolean(cacheBuilt, v, null);
    }

    public int getCachingStartupDelay() {
        return this.getInt(cachingStartupDelay);
    }

    public void setCachingStartupDelay(int v) {
        this.setInt(cachingStartupDelay, v, null);
    }

    public boolean getAutoTagAnalyticPoint() {
        return this.getBoolean(autoTagAnalyticPoint);
    }

    public void setAutoTagAnalyticPoint(boolean v) {
        this.setBoolean(autoTagAnalyticPoint, v, null);
    }

    public boolean getLimitAutoTagging() {
        return this.getBoolean(limitAutoTagging);
    }

    public void setLimitAutoTagging(boolean v) {
        this.setBoolean(limitAutoTagging, v, null);
    }

    public String getTestCovNeql() {
        return this.getString(testCovNeql);
    }

    public void setTestCovNeql(String v) {
        this.setString(testCovNeql, v, null);
    }

    public String getTestTotalizationNeql() {
        return this.getString(testTotalizationNeql);
    }

    public void setTestTotalizationNeql(String v) {
        this.setString(testTotalizationNeql, v, null);
    }

    public boolean getUseHierarchyCache() {
        return this.getBoolean(useHierarchyCache);
    }

    public void setUseHierarchyCache(boolean v) {
        this.setBoolean(useHierarchyCache, v, null);
    }

    public String getAreaTag() {
        return this.getString(areaTag);
    }

    public void setAreaTag(String v) {
        this.setString(areaTag, v, null);
    }

    public String getOatTag() {
        return this.getString(oatTag);
    }

    public void setOatTag(String v) {
        this.setString(oatTag, v, null);
    }

    public BAlertFolder getAlerts() {
        return (BAlertFolder)this.get(alerts);
    }

    public void setAlerts(BAlertFolder v) {
        this.set(alerts, (BValue)v, null);
    }

    public BAlgorithmFolder getAlgorithms() {
        return (BAlgorithmFolder)this.get(algorithms);
    }

    public void setAlgorithms(BAlgorithmFolder v) {
        this.set(algorithms, (BValue)v, null);
    }

    public BAnalyticDataFolder getDefinitions() {
        return (BAnalyticDataFolder)this.get(definitions);
    }

    public void setDefinitions(BAnalyticDataFolder v) {
        this.set(definitions, (BValue)v, null);
    }

    public BPollerFolder getPollers() {
        return (BPollerFolder)this.get(pollers);
    }

    public void setPollers(BPollerFolder v) {
        this.set(pollers, (BValue)v, null);
    }

    public BComponent getHierCache() {
        return (BComponent)this.get(hierCache);
    }

    public void setHierCache(BComponent v) {
        this.set(hierCache, (BValue)v, null);
    }

    public int getThreadPriority() {
        return this.getInt(threadPriority);
    }

    public void setThreadPriority(int v) {
        this.setInt(threadPriority, v, null);
    }

    public int getTriggeredPollerConcurrency() {
        return this.getInt(triggeredPollerConcurrency);
    }

    public void setTriggeredPollerConcurrency(int v) {
        this.setInt(triggeredPollerConcurrency, v, null);
    }

    public boolean getSkipDataSourceCache() {
        return this.getBoolean(skipDataSourceCache);
    }

    public void setSkipDataSourceCache(boolean v) {
        this.setBoolean(skipDataSourceCache, v, null);
    }

    public BAnalyticsSubscription getSubscriptionAlarm() {
        return (BAnalyticsSubscription)this.get(subscriptionAlarm);
    }

    public void setSubscriptionAlarm(BAnalyticsSubscription v) {
        this.set(subscriptionAlarm, (BValue)v, null);
    }

    public boolean getDebugMode() {
        return this.getBoolean(debugMode);
    }

    public void setDebugMode(boolean v) {
        this.setBoolean(debugMode, v, null);
    }

    public BAnalyticReportFolder getReports() {
        return (BAnalyticReportFolder)this.get(reports);
    }

    public void setReports(BAnalyticReportFolder v) {
        this.set(reports, (BValue)v, null);
    }

    public BMissingDataStrategy getMissingDataStrategy() {
        return (BMissingDataStrategy)this.get(missingDataStrategy);
    }

    public void setMissingDataStrategy(BMissingDataStrategy v) {
        this.set(missingDataStrategy, (BValue)v, null);
    }

    public BChartRenderLimitConfiguration getChartRenderCapacity() {
        return (BChartRenderLimitConfiguration)this.get(chartRenderCapacity);
    }

    public void setChartRenderCapacity(BChartRenderLimitConfiguration v) {
        this.set(chartRenderCapacity, (BValue)v, null);
    }

    public BBlob findData(BOrd parameter) {
        return (BBlob)this.invoke(findData, (BValue)parameter, null);
    }

    public BString listPollers() {
        return (BString)this.invoke(listPollers, null, null);
    }

    public void refreshCache() {
        this.invoke(refreshCache, null, null);
    }

    public void stopCaching() {
        this.invoke(stopCaching, null, null);
    }

    public void houseKeeping() {
        this.invoke(houseKeeping, null, null);
    }

    public BAbsStartEndTime getStartEndTimes(BString parameter) {
        return (BAbsStartEndTime)this.invoke(getStartEndTimes, (BValue)parameter, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    private static BFacets makeTextFacets() {
        BFacets ret = BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE);
        ret = BFacets.make((BFacets)ret, (String)"fieldWidth", (BIDataValue)BInteger.make((int)100));
        return ret;
    }

    public final void atSteadyState() throws Exception {
        if (instance == this) {
            if (!this.getEnabled()) {
                Utils.log().log(Level.INFO, Utils.lex("cachingWithServiceDisabled"));
                return;
            }
            this.steady = true;
            new Check("Analytics-check").start();
            Utils.log().log(Level.INFO, Utils.lex("cachingTriggered"), new Object[]{this.getCachingStartupDelay()});
            this.executor.schedule(() -> this.refreshCache(), (long)this.getCachingStartupDelay(), TimeUnit.MINUTES);
            this.subscriber = new EventTypeSubscriber(Sys.getStation().getComponentSpace());
            this.subscriber.subscribe(BControlPoint.TYPE, null);
            this.getSubscriptionAlarm().setDateOfExpiration(BAbsTime.make((long)NAFFeatureUtil.getExpiry()));
        }
        super.atSteadyState();
    }

    public BBoolean doAckAlarm(BAlarmRecord record) {
        if (!this.isRunning() || this.alarmSupport == null) {
            return BBoolean.FALSE;
        }
        BBoolean res = BBoolean.FALSE;
        try {
            res = BBoolean.make((boolean)this.alarmSupport.ackAlarm(record));
            if (res.getBoolean()) {
                this.alarmBits &= 0xFFFFFF7F;
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public void serviceStarted() throws Exception {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getSubscriptionAlarm().getAlarmSourceInfo());
    }

    public void updateStatus() {
        super.updateStatus();
        if (this.alarmSupport == null) {
            return;
        }
        BStatus status = this.getStatus();
        if (!(this.alarmState != AlarmState.FAULT || this.alarmSupport.getLastFault() != null && this.alarmSupport.getLastFault().isAlarm())) {
            this.alarmBits = 8;
            if (this.alarmSupport.isAckRequired(BSourceState.fault)) {
                this.alarmBits |= 0x80;
            }
            try {
                this.alarmSupport.newFaultAlarm(BFacets.DEFAULT);
            }
            catch (Exception e) {
                Utils.log().log(Level.SEVERE, "Unable to create fault alarm", e);
            }
            this.lastUpdatedTime = Clock.millis();
        } else if (this.alarmState == AlarmState.ALERT && this.isUpdateDue()) {
            this.alarmBits = 8;
            long expiry = NAFFeatureUtil.getExpiry();
            String message = Utils.lex("subscription.expiring", new String[]{BAbsTime.make((long)expiry).toDateString(null)});
            BFacets alarmData = BFacets.make((String)"msgText", (BIDataValue)BString.make((String)message));
            if (this.alarmSupport.isAckRequired(BSourceState.alert)) {
                this.alarmBits |= 0x80;
            }
            try {
                this.alarmSupport.newAlert(alarmData);
            }
            catch (Exception e) {
                Utils.log().log(Level.SEVERE, "Unable to create fault alarm", e);
            }
            this.lastUpdatedTime = Clock.millis();
        } else if (this.alarmState == AlarmState.NONE && !status.isFault() && (this.alarmSupport.getLastAlert() != null && this.alarmSupport.getLastAlert().isAlarm() || this.alarmSupport.getLastFault() != null && this.alarmSupport.getLastFault().isAlarm() || this.alarmSupport.getLastOffnormal() != null && this.alarmSupport.getLastOffnormal().isAlarm())) {
            this.alarmBits = 0;
            if (this.alarmSupport.isAckRequired(BSourceState.normal)) {
                this.alarmBits |= 0x80;
            }
            try {
                this.alarmSupport.toNormal((Context)null);
            }
            catch (Exception e) {
                Utils.log().log(Level.SEVERE, "Unable to create fault alarm", e);
            }
            this.lastUpdatedTime = 0L;
        }
        this.setStatus(BStatus.make((int)(status.getBits() | this.alarmBits)));
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p.equals(testCovNeql)) {
                this.testCov = null;
            } else if (p.equals(testTotalizationNeql)) {
                this.testTotalization = null;
            }
        }
        super.changed(p, cx);
    }

    public BBlob doFindData(BOrd node) throws Exception {
        HashSet<Id> ids = null;
        if (node != null && !node.isNull()) {
            try {
                BINavNode nn = (BINavNode)node.get((BObject)this);
                ids = this.getAvailableData(nn);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (ids == null) {
            ids = new HashSet<Id>();
            this.getAllTags(ids);
            this.getAllAlgorithms(ids);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(20000);
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        DataOutputStream out = new DataOutputStream(gzos);
        out.writeInt(ids.size());
        for (Id i : ids) {
            out.writeUTF(i.getQName());
        }
        out.close();
        return BBlob.make((byte[])baos.toByteArray());
    }

    @NiagaraRpc(permissions="i", transports={@Transport(type=TransportType.box)})
    public List<String> getTagDataForBox(Map<?, ?> map, Context ctx) {
        BBlob blob = this.findData(BOrd.NULL);
        ArrayList<String> data = new ArrayList<String>();
        ByteArrayInputStream bin = new ByteArrayInputStream(blob.copyBytes());
        GZIPInputStream gin = null;
        try {
            gin = new GZIPInputStream(bin);
            DataInputStream in = new DataInputStream(gin);
            int size = in.readInt();
            while (--size >= 0) {
                String s = in.readUTF();
                data.add(s);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BString doListPollers() {
        ArrayList<String> pollers = new ArrayList<String>();
        HashMap<String, BAnalyticPoller> hashMap = this.pollerMap;
        synchronized (hashMap) {
            pollers.addAll(this.pollerMap.keySet());
        }
        return BString.make((String)Strings.encodeCsvRow(pollers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefreshCache() {
        if (!this.getEnabled()) {
            Utils.log().log(Level.INFO, Utils.lex("cachingWithServiceDisabled"));
            return;
        }
        if (!this.isCaching.compareAndSet(false, true)) {
            Utils.log().log(Level.WARNING, Utils.lex("cachingInProgress"));
            return;
        }
        this.setCaching(true);
        try {
            Utils.log().log(Level.INFO, Utils.lex("cachingStarted"));
            long start = System.currentTimeMillis();
            this.setCacheBuilt(false);
            this.cachesBuilt = false;
            this.clearCache();
            this.validate(true);
            AlertEntry.loadOpenAlarms();
            ComponentTreeCursor alertCursor = new ComponentTreeCursor((BComponent)this.getAlerts(), null);
            while (!this.stopCachingRequested.get() && alertCursor.next(BAnalyticAlert.class)) {
                BAnalyticAlert alert = (BAnalyticAlert)alertCursor.get();
                alert.findTargets();
            }
            BITable table = (BITable)BOrd.make((String)"station:|slot:/|bql:select * from analytics:AnalyticProxyExt where enabled = 'true'").get((BObject)Sys.getStation());
            TableCursor tc = table.cursor();
            while (!this.stopCachingRequested.get() && tc.next()) {
                BAnalyticProxyExt ext = (BAnalyticProxyExt)tc.get();
                ext.findTargets();
            }
            tc.close();
            AlertEntry.clearRemainingAlarms();
            if (!this.stopCachingRequested.get() || !alertCursor.next(BAnalyticAlert.class)) {
                String reqLogs;
                this.cachesBuilt = true;
                this.setCacheBuilt(true);
                this.validate(true);
                if (Utils.log().isLoggable(Level.FINEST) && (reqLogs = RequestContext.reqMessagesAsString()) != null && !reqLogs.isEmpty()) {
                    Utils.log().log(Level.FINEST, Utils.lex("err.dataNotAvailable") + reqLogs);
                }
                Utils.log().log(Level.INFO, Utils.lex("cachingFinished"), (System.currentTimeMillis() - start) / 1000L);
            } else {
                this.clearCache();
                Utils.log().log(Level.WARNING, Utils.lex("cachingInterrupted"), (System.currentTimeMillis() - start) / 1000L);
            }
        }
        finally {
            this.isCaching.set(false);
            this.setCaching(false);
            this.stopCachingRequested.set(false);
            RequestContext.resetRequestLocals();
        }
    }

    private void clearCache() {
        tagService = null;
        NodeInfo.clear();
        this.requestCache.clear();
        ComponentTreeCursor cur = new ComponentTreeCursor((BComponent)this.getAlerts(), null);
        while (cur.next(BAnalyticAlert.class)) {
            BAnalyticAlert alert = (BAnalyticAlert)cur.get();
            alert.clearTargets();
        }
    }

    public void doStopCaching() {
        if (!this.getEnabled()) {
            Utils.log().log(Level.INFO, Utils.lex("cachingWithServiceDisabled"));
            return;
        }
        if (this.isCaching.get()) {
            Utils.log().log(Level.INFO, Utils.lex("requestStopCaching"));
            this.stopCachingRequested.set(true);
        } else {
            Utils.log().log(Level.WARNING, Utils.lex("requestStopCachingIgnored"));
        }
    }

    public final void doHouseKeeping() {
        this.requestCache.clean();
        this.validate(false);
    }

    public final BAbsStartEndTime doGetStartEndTimes(BString parameter, Context context) {
        BAnalyticTimeRange timeRange = BAnalyticTimeRange.make(SlotPath.unescape((String)parameter.getString()));
        BAbsStartEndTime startEndTime = new BAbsStartEndTime();
        startEndTime.setStartTime(BAbsTime.make((long)timeRange.getStart()));
        startEndTime.setEndTime(BAbsTime.make((long)timeRange.getEnd()));
        if (context != null) {
            BUser currentUser = context.getUser();
            BString timeFormat = (BString)currentUser.getFacets().get("timeFormat");
            if (timeFormat != null && !"".equals(timeFormat.getString().trim())) {
                startEndTime.setFormat(timeFormat.getString());
            } else {
                startEndTime.setFormat("D MMM YY HH:mm");
            }
        }
        long now = BAbsTime.now().getMillis();
        startEndTime.setCurrent(now);
        return startEndTime;
    }

    public void enqueue(Runnable arg) {
        this.threads.enqueue(arg);
    }

    public void enqueuePoller(Runnable arg) {
        this.pollerThreads.execute(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Algorithm getAlgorithm(Id id) {
        HashMap<Id, Algorithm> hashMap = this.algoMap;
        synchronized (hashMap) {
            if (id == null) {
                return null;
            }
            return this.algoMap.get(id);
        }
    }

    public HashSet<Id> getAvailableData(BINavNode node) {
        HashSet<Id> ret = new HashSet<Id>();
        this.getAvailableTags(node, ret);
        this.getAvailableAlgorithms(node, ret);
        return ret;
    }

    public Predicate<Entity> getCovTest() {
        if (this.testCov == null) {
            this.testCov = new NeqlPredicate(this.getTestCovNeql());
        }
        return this.testCov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalyticDataPolicy getDataPolicy(Id id, boolean create) {
        AnalyticDataPolicy ret;
        HashMap<Id, AnalyticDataPolicy> hashMap = this.policyMap;
        synchronized (hashMap) {
            if (id == null) {
                return null;
            }
            ret = this.policyMap.get(id);
            if (ret != null) {
                return ret;
            }
        }
        if (id.hasDictionary() && id.getDictionary().equals("alg")) {
            hashMap = this.algoMap;
            synchronized (hashMap) {
                ret = this.algoMap.get(id);
                if (ret != null) {
                    return ret;
                }
            }
        }
        try {
            Optional odp;
            if (tagService == null) {
                tagService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
            }
            if ((odp = tagService.getDataPolicyForTag(id)).isPresent()) {
                DataPolicy dp = (DataPolicy)odp.get();
                if (dp instanceof AnalyticDataPolicy) {
                    return (AnalyticDataPolicy)dp;
                }
                if (create && dp instanceof BComponent) {
                    BComponent comp = (BComponent)dp;
                    BFacets f = (BFacets)comp.get("defFacets");
                    if (f == null) {
                        f = (BFacets)comp.get("facets");
                    }
                    if (f != null) {
                        ret = new DefaultPolicy(id, f);
                    }
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (create && ret == null) {
            return new DefaultPolicy(id);
        }
        return ret;
    }

    public BIcon getIcon() {
        return icon;
    }

    public static BAnalyticService getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAnalyticPoller getPoller(String name) {
        if (!this.steady) {
            return null;
        }
        HashMap<String, BAnalyticPoller> hashMap = this.pollerMap;
        synchronized (hashMap) {
            return this.pollerMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticValue getRollup(AnalyticContext cx) {
        try {
            if (!BAnalyticService.getInstance().isSteady()) {
                AnalyticValue analyticValue = Values.make(cx).setStatus(64);
                return analyticValue;
            }
            RequestContext.getReqAnalyticContext().set(cx);
            BUnit origUnit = cx.getUnit(false);
            cx.setUnit(null);
            AnalyticValue ret = null;
            OrdTarget ot = cx.getNodeTarget();
            if (!ot.canRead()) {
                throw new PermissionException(Utils.lex("cannotRead") + ": " + ot.getOrd().toString(null));
            }
            String requestId = null;
            if (cx.getUseCache() && (ret = (AnalyticValue)this.requestCache.get(requestId = "r_" + cx.toString())) != null) {
                AnalyticValue analyticValue = this.convert(ret, origUnit, cx);
                return analyticValue;
            }
            BINavNode node = cx.getNode();
            NodeInfo info = NodeInfo.get(node, true);
            AnalyticDataSource source = info.getAnalyticDataSource(cx.getData(), true, cx);
            BAnalyticService.dataAvailabilityExceptionHandling(source, cx);
            long time = Clock.nanoTicks();
            AnalyticTrend trend = null;
            if (source != null) {
                trend = source.getTrend(cx);
            }
            trend = new ExitTrend(trend, cx);
            Combiner roll = cx.getRollup(true).makeCombiner();
            trend.forEachRemaining(roll);
            ret = roll.getValue();
            if (requestId != null && (time -= Clock.nanoTicks()) > 200000000L) {
                time *= 10L;
                time = Math.max(time, 30000000000L);
                this.requestCache.put(requestId, ret, time);
            }
            AnalyticValue analyticValue = this.convert(ret, origUnit, cx);
            return analyticValue;
        }
        finally {
            RequestContext.resetRequestLocals();
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Predicate<Entity> getTotalizationTest() {
        if (this.testTotalization == null) {
            this.testTotalization = new NeqlPredicate(this.getTestTotalizationNeql());
        }
        return this.testTotalization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        try {
            AnalyticContextWrapper wrapperCx;
            if (!BAnalyticService.getInstance().isSteady()) {
                EmptyTrend emptyTrend = new EmptyTrend(cx);
                return emptyTrend;
            }
            RequestContext.getReqAnalyticContext().set(cx);
            BUnit origUnit = cx.getUnit(false);
            cx.setUnit(null);
            AnalyticTrend ret = this.getTrendInternal(cx);
            if (cx instanceof AnalyticContextWrapper && (wrapperCx = (AnalyticContextWrapper)cx).getInner() != null && wrapperCx.getInterval(false) != wrapperCx.getInner().getInterval(false)) {
                ret = new IntervalTrend(ret, wrapperCx.getInner());
            }
            ExitTrend exitTrend = new ExitTrend(ret, cx.setUnit(origUnit));
            return exitTrend;
        }
        finally {
            RequestContext.resetRequestLocals();
        }
    }

    @Override
    public CompletableFuture<Optional<AnalyticTrend>> getTrendAsync(AnalyticContext cx) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Optional.of(this.getTrend(cx));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        });
    }

    @Override
    public CompletableFuture<Optional<AnalyticValue>> getRollupAsync(AnalyticContext cx) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Optional.of(this.getRollup(cx));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        });
    }

    private AnalyticTrend getTrendInternal(AnalyticContext cx) {
        Interval ivl;
        int rowCount;
        CachedTrend tmp;
        AnalyticTrend ret = null;
        OrdTarget ot = cx.getNodeTarget();
        if (!ot.canRead()) {
            throw new PermissionException(Utils.lex("cannotRead") + ": " + ot.getOrd().toString(null));
        }
        String requestId = null;
        if (cx.getUseCache() && (tmp = (CachedTrend)this.requestCache.get(requestId = "t_" + cx.toString())) != null) {
            return tmp.newTrend();
        }
        BINavNode node = cx.getNode();
        NodeInfo info = NodeInfo.get(node, true);
        AnalyticDataSource source = info.getAnalyticDataSource(cx.getData(), true, cx);
        BAnalyticService.dataAvailabilityExceptionHandling(source, cx);
        long time = Clock.nanoTicks();
        ret = source != null ? source.getTrend(cx.newCopy()) : new EmptyTrend(cx.newCopy());
        if (requestId != null && (time -= Clock.nanoTicks()) > 200000000L && (rowCount = (ivl = ret.getContext().getInterval(true)).count(cx.getStartTime(), cx.getEndTime())) > 0 && rowCount <= 500) {
            time *= 10L;
            time = Math.max(time, 30000000000L);
            CachedTrend tmp2 = CachedTrend.make(ret);
            this.requestCache.put(requestId, tmp2, time);
            ret = tmp2.newTrend();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        try {
            if (!BAnalyticService.getInstance().isSteady()) {
                AnalyticValue analyticValue = Values.make(cx).setStatus(64);
                return analyticValue;
            }
            RequestContext.getReqAnalyticContext().set(cx);
            BUnit origUnit = cx.getUnit(false);
            cx.setUnit(null);
            AnalyticValue ret = null;
            OrdTarget ot = cx.getNodeTarget();
            if (!ot.canRead()) {
                throw new PermissionException(Utils.lex("cannotRead") + ": " + ot.getOrd().toString(null));
            }
            String requestId = null;
            if (cx.getUseCache() && (ret = (AnalyticValue)this.requestCache.get(requestId = "v_" + cx.toString())) != null) {
                AnalyticValue analyticValue = this.convert(ret, origUnit, cx);
                return analyticValue;
            }
            BINavNode node = cx.getNode();
            NodeInfo info = NodeInfo.get(node, true);
            AnalyticDataSource source = info.getAnalyticDataSource(cx.getData(), true, cx);
            BAnalyticService.dataAvailabilityExceptionHandling(source, cx);
            long time = Clock.nanoTicks();
            ret = source != null ? source.getValue(cx) : AnalyticValue.makeString();
            if (requestId != null && (time -= Clock.nanoTicks()) > 200000000L) {
                time *= 10L;
                time = Math.max(time, 5000000000L);
                this.requestCache.put(requestId, ret, time);
            }
            AnalyticValue analyticValue = this.convert(ret, origUnit, cx);
            return analyticValue;
        }
        finally {
            RequestContext.resetRequestLocals();
        }
    }

    public static final void dataAvailabilityExceptionHandling(AnalyticDataSource source, AnalyticContext cx) {
        String msg = null;
        if (Utils.log().isLoggable(Level.FINEST) || source == null && Utils.log().isLoggable(Level.FINER)) {
            msg = RequestContext.reqMessagesAsString();
        }
        if (source == null) {
            String nodeName = null;
            String username = null;
            String dataStr = null;
            if (cx.getNode() != null && cx.getNode().getNavOrd() != null) {
                nodeName = cx.getNode().getNavOrd().toString();
            }
            if (cx.getUser() != null) {
                username = cx.getUser().getUsername();
            }
            if (cx.getData() != null) {
                dataStr = cx.getData().getQName();
            }
            String debugTrace = Utils.prepareDebugMessage(RequestContext.getReqOrigin().get(), dataStr, nodeName, null, username);
            if (msg != null && !msg.isEmpty()) {
                debugTrace = debugTrace + msg;
            }
            Utils.log().warning(Utils.lex("err.dataNotAvailable") + debugTrace);
        }
    }

    public final boolean isSteady() {
        return this.steady && this.cachesBuilt && this.getEnabled();
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        if (this.isRunning()) {
            this.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        }
        return null;
    }

    private final void initThreadPools() {
        if (this.threads == null) {
            this.threads = new ThreadPool(ASERVICE_TPOOL_NAME, 1, 10, this.getThreadPriority(), 2000);
        }
        if (this.pollerThreads == null) {
            ArrayBlockingQueue<Runnable> pollerThreadQueue = new ArrayBlockingQueue<Runnable>(this.triggeredPoolCapacity());
            this.pollerThreads = new ThreadPoolExecutor(1, this.getTriggeredPollerConcurrency(), 30L, TimeUnit.SECONDS, pollerThreadQueue, new SimpleThreadFactory(POLLER_TPOOL_NAME), new SimpleDiscardPolicy(this.triggeredPoolCapacity(), POLLER_TPOOL_NAME));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void started() throws Exception {
        aPointLimitGL = this.aPointLimit = NAFFeatureUtil.getLimit("point.limit");
        this.setupMarkerATag();
        this.initThreadPools();
        Class<BAnalyticService> clazz = BAnalyticService.class;
        synchronized (BAnalyticService.class) {
            if (instance != null && instance != this) {
                this.configFail("Duplicate service: " + instance.toPathString());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.requestCache = new KeyedCache(10000);
            instance = this;
            this.configOk();
            Analytics.setProvider(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                BModule mod = Sys.getModuleForClass(BAnalyticService.class);
                Version v = mod.getVendorVersion(RuntimeProfile.rt);
                this.setRtVersion(v.toString());
                v = mod.getVendorVersion(RuntimeProfile.wb);
                this.setWbVersion(v.toString());
                v = mod.getVendorVersion(RuntimeProfile.ux);
                this.setUxVersion(v.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Sys.atSteadyState()) {
                this.atSteadyState();
            }
            super.started();
            return;
        }
    }

    private void setupMarkerATag() {
        try {
            TagDictionary aTagDictionary;
            TagDictionaryService tagDictionaryService = Sys.getStation().getTagDictionaryService();
            if (tagDictionaryService == null) {
                Utils.log().warning(Utils.lex("tagDictServMissing"));
                return;
            }
            Optional aOTagDictionary = Sys.getStation().getTagDictionaryService().getTagDictionary("a");
            if (!aOTagDictionary.isPresent()) {
                Utils.log().warning(Utils.lex("aTagDictMissing"));
                aTagDictionary = new BTagDictionary("a");
                ((BComponent)Sys.getStation().getTagDictionaryService()).add("analytics", (BValue)((BTagDictionary)aTagDictionary));
                Utils.log().info(Utils.lex("aTagDictCreated"));
            } else {
                aTagDictionary = (TagDictionary)aOTagDictionary.get();
            }
            boolean found = false;
            Iterator infoIter = aTagDictionary.getTags();
            while (infoIter.hasNext()) {
                TagInfo tagInfo = (TagInfo)infoIter.next();
                if (!tagInfo.getTagId().equals((Object)Id.newId((String)"a", (String)"a"))) continue;
                found = true;
                break;
            }
            if (!found) {
                Utils.log().info(Utils.lex("aTagMissing"));
                ((BTagDictionary)aTagDictionary).getTagDefinitions().add("a", (BValue)new BSimpleTagInfo((BIDataValue)BMarker.MARKER));
            }
        }
        catch (Exception e) {
            Utils.log().warning(Utils.lex("aTagCreationError"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerAlgorithm(Id id, Algorithm arg) {
        if (id == null || arg == null) {
            return false;
        }
        HashMap<Id, Algorithm> hashMap = this.algoMap;
        synchronized (hashMap) {
            Algorithm cur = this.algoMap.get(id);
            if (cur != null) {
                if (cur != arg) {
                    return false;
                }
            } else {
                this.algoMap.put(id, arg);
            }
        }
        this.registerDataPolicy(id, arg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataPolicy(Id id, AnalyticDataPolicy policy) {
        HashMap<Id, AnalyticDataPolicy> hashMap = this.policyMap;
        synchronized (hashMap) {
            if (id == null) {
                return;
            }
            this.policyMap.put(id, policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPoller(String name, BAnalyticPoller poller) {
        HashMap<String, BAnalyticPoller> hashMap = this.pollerMap;
        synchronized (hashMap) {
            this.pollerMap.put(name, poller);
        }
    }

    public void stopped() throws Exception {
        if (instance == this) {
            instance = null;
            Analytics.setProvider(null);
        }
        this.doStopCaching();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.pollerThreads != null) {
            this.pollerThreads.shutdownNow();
        }
        this.pollerThreads = null;
        if (this.threads != null) {
            this.threads.stop();
        }
        this.threads = null;
        if (this.requestCache != null) {
            this.requestCache.clear();
        }
        if (this.subscriber != null) {
            this.subscriber.unsubscribe(BControlPoint.TYPE, null);
            this.subscriber = null;
        }
        this.requestCache = null;
        this.steady = false;
        Alarms.closeConnection();
        super.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterAlgorithm(Id id, Algorithm arg) {
        if (id == null || arg == null) {
            return false;
        }
        HashMap<Id, Algorithm> hashMap = this.algoMap;
        synchronized (hashMap) {
            Algorithm cur = this.algoMap.get(id);
            if (cur != null) {
                if (cur != arg) {
                    return false;
                }
                this.algoMap.remove(id);
            }
        }
        this.unregisterDataPolicy(id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDataPolicy(Id id) {
        if (id == null) {
            return;
        }
        HashMap<Id, AnalyticDataPolicy> hashMap = this.policyMap;
        synchronized (hashMap) {
            this.policyMap.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPoller(String name) {
        if (name == null) {
            return;
        }
        HashMap<String, BAnalyticPoller> hashMap = this.pollerMap;
        synchronized (hashMap) {
            this.pollerMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAllAlgorithms(HashSet<Id> ids) {
        HashSet<Algorithm> tmp = new HashSet<Algorithm>(this.algoMap.size());
        Property property = algorithms;
        synchronized (property) {
            tmp.addAll(this.algoMap.values());
        }
        for (Algorithm a : tmp) {
            ids.add(a.getDataId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAvailableAlgorithms(BINavNode node, HashSet<Id> ids) {
        HashSet<Algorithm> tmp = new HashSet<Algorithm>(this.algoMap.size());
        Property property = algorithms;
        synchronized (property) {
            tmp.addAll(this.algoMap.values());
        }
        NodeInfo info = NodeInfo.get(node, true);
        for (Algorithm a : tmp) {
            AnalyticDataSource src = info.getAnalyticDataSource(a.getDataId(), true, null);
            if (src == null) continue;
            ids.add(a.getDataId());
        }
    }

    protected void getAllTags(HashSet<Id> ids) {
        TagDictionaryService svc = (TagDictionaryService)BOrd.make((String)"service:tagdictionary:TagDictionaryService").get((BObject)this);
        for (TagDictionary td : svc.getTagDictionaries()) {
            if (!td.getEnabled()) continue;
            td.getTags().forEachRemaining(p -> ids.add(p.getTagId()));
            td.getTagGroups().forEachRemaining(p -> ids.add(p.getGroupId()));
        }
    }

    protected void getAvailableTags(BINavNode node, HashSet<Id> ids) {
        Tags tags;
        BINavNode actual = Utils.getProxyTarget(node);
        if (actual instanceof Taggable && !(tags = ((Taggable)actual).tags()).isEmpty()) {
            for (Tag t : tags) {
                ids.add(t.getId());
            }
        }
        if (node.hasNavChildren()) {
            BINavNode[] kids = node.getNavChildren();
            int i = kids.length;
            while (--i >= 0) {
                this.getAvailableTags(kids[i], ids);
            }
        }
    }

    public final boolean isValidNodeType(BINavNode node) {
        return node != null && !(node instanceof BVirtualGateway);
    }

    private AnalyticValue convert(AnalyticValue val, BUnit to, AnalyticContext cx) {
        BUnit from = cx.getUnit(true);
        to = UnitConverter.getConversionUnit(from, to, cx);
        if (to != null) {
            val = UnitConverter.convert(val, from, to);
            cx.setUnit(to);
        } else {
            cx.setUnit(from);
        }
        return val;
    }

    private boolean isUpdateDue() {
        return this.lastUpdatedTime == 0L || this.lastUpdatedTime + 86400000L < Clock.millis();
    }

    private boolean withinNotificationRange() {
        long expiry = NAFFeatureUtil.getExpiry();
        return expiry < Clock.millis() + (long)this.getSubscriptionAlarm().getAlarmBeforeDays() * 86400000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void validate(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now - this.lastCheck < 3600000L) {
            return;
        }
        if (!this.checking.compareAndSet(false, true)) {
            Utils.log().finest(Utils.lex("checkingInProgress"));
            return;
        }
        try {
            this.lastCheck = now;
            if (this.isFatalFault()) {
                this.steady = false;
                this.configFail(Utils.lex("unlicensed"));
                return;
            }
            if (NAFFeatureUtil.isSubscriptionActive()) {
                if (this.getSubscriptionAlarm().getAlarmExpiryReminder() && this.withinNotificationRange()) {
                    this.alarmState = AlarmState.ALERT;
                } else if (!this.getSubscriptionAlarm().getAlarmExpiryReminder() || !this.withinNotificationRange()) {
                    this.alarmState = AlarmState.NONE;
                }
            } else {
                this.steady = false;
                String msg = Utils.lex("subscription.expired");
                this.alarmState = AlarmState.FAULT;
                this.configFatal(msg);
                Utils.log().severe(msg);
                return;
            }
            ComponentTreeCursor cur = new ComponentTreeCursor((BComponent)this.getAlerts(), null);
            int alertCount = 0;
            BAnalyticAlert alert = null;
            while (cur.next(BAnalyticAlert.class)) {
                alert = (BAnalyticAlert)cur.get();
                if (!alert.getEnabled()) continue;
                ++alertCount;
            }
            this.setAlertCount(alertCount);
            Thread.yield();
            int algoCount = 0;
            for (Algorithm algo : this.algoMap.values()) {
                if (!(algo instanceof BAlgorithm) || !((BAlgorithm)algo).getEnabled()) continue;
                ++algoCount;
            }
            this.setAlgorithmCount(algoCount);
            Thread.yield();
            int proxyExtCount = 0;
            BITable table = (BITable)BOrd.make((String)"station:|slot:/|bql:select count(*) from analytics:AnalyticProxyExt where enabled = 'true'").get((BObject)Sys.getStation());
            TableCursor tc = table.cursor();
            if (tc.next()) {
                ColumnList columns = table.getColumns();
                Column valueColumn = columns.get(0);
                proxyExtCount = (int)((BINumeric)tc.cell(valueColumn)).getNumeric();
            }
            tc.close();
            this.setProxyExtCount(proxyExtCount);
            long ptCount = 0L;
            String slotName = SlotPath.escape((String)"a$3aa");
            table = (BITable)BOrd.make((String)("station:|slot:/|bql:select count(*) from control:ControlPoint where slotExists('" + slotName + "') = true")).get((BObject)Sys.getStation());
            tc = table.cursor();
            if (tc.next()) {
                ColumnList columns = table.getColumns();
                Column valueColumn = columns.get(0);
                ptCount = (long)((BINumeric)tc.cell(valueColumn)).getNumeric();
            }
            tc.close();
            this.aPointCount.set(ptCount);
            this.setPointCount(ptCount);
            aPointCountGL.set(ptCount);
            long algoLimit = NAFFeatureUtil.getLimit("algorithm.limit");
            if ((long)algoCount > algoLimit) {
                String msg = MessageFormat.format(Utils.lex("algoLimitExceeded"), algoCount, algoLimit);
                this.configFail(msg);
                this.steady = false;
                Utils.log().severe(msg);
                return;
            }
            long alertLimit = NAFFeatureUtil.getLimit("alert.limit");
            if ((long)alertCount > alertLimit) {
                String msg = MessageFormat.format(Utils.lex("alertLimitExceeded"), alertCount, alertLimit);
                this.configFail(msg);
                this.steady = false;
                Utils.log().severe(msg);
                return;
            }
            long proxyExtLimit = NAFFeatureUtil.getLimit("proxyext.limit");
            if ((long)proxyExtCount > proxyExtLimit) {
                String msg = MessageFormat.format(Utils.lex("proxyLimitExceeded"), proxyExtCount, proxyExtLimit);
                this.configFail(msg);
                this.steady = false;
                Utils.log().severe(msg);
                return;
            }
            long pointLimit = NAFFeatureUtil.getLimit("point.limit");
            if (ptCount > pointLimit) {
                String msg = MessageFormat.format(Utils.lex("pointLimitExceeded"), ptCount, pointLimit);
                this.configFail(msg);
                this.steady = false;
                Utils.log().severe(msg);
                return;
            }
            this.steady = Sys.atSteadyState();
            this.configOk();
        }
        catch (Exception e) {
            Utils.log().severe(Utils.lex("unknownExceptionCheck") + ": " + e.getLocalizedMessage());
            this.steady = false;
        }
        finally {
            this.checking.set(false);
        }
    }

    private final boolean pointLimitCheck() {
        long ptCount = this.aPointCount.get();
        if (ptCount > this.aPointLimit) {
            String msg = MessageFormat.format(Utils.lex("pointLimitExceeded"), ptCount, this.aPointLimit);
            this.configFail(msg);
            Utils.log().log(Level.SEVERE, msg);
            return false;
        }
        return true;
    }

    private final void aPointAdded() {
        this.aPointCount.incrementAndGet();
        this.setPointCount(this.aPointCount.get());
        this.pointLimitCheck();
    }

    private final int triggeredPoolCapacity() {
        return this.getTriggeredPollerConcurrency() * 2 + 5;
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (testTotalizationNeql.getName().equals(slot.getName())) {
            return this.lex.get("AnalyticService.testTotalizationNeql");
        }
        return super.getDisplayName(slot, cx);
    }

    static {
        aPointLimitGL = 0L;
    }

    public static final class RequestContext {
        private static final ThreadLocal<AnalyticContext> reqContext = new ThreadLocal<AnalyticContext>(){

            @Override
            protected AnalyticContext initialValue() {
                return null;
            }
        };
        private static final ThreadLocal<String> reqOrigin = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return BAnalyticService.DEFAULT_REQUEST_ORIGIN;
            }
        };
        private static final ThreadLocal<List<String>> reqMessages = new ThreadLocal<List<String>>(){

            @Override
            protected List<String> initialValue() {
                return new LinkedList<String>();
            }
        };

        public static final ThreadLocal<AnalyticContext> getReqAnalyticContext() {
            return reqContext;
        }

        public static final ThreadLocal<String> getReqOrigin() {
            return reqOrigin;
        }

        public static final ThreadLocal<List<String>> getReqMessages() {
            return reqMessages;
        }

        public static final void resetRequestLocals() {
            RequestContext.getReqOrigin().set(BAnalyticService.DEFAULT_REQUEST_ORIGIN);
            RequestContext.getReqMessages().get().clear();
            RequestContext.getReqAnalyticContext().set(null);
        }

        private static final String reqMessagesAsString() {
            return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)RequestContext.getReqMessages().get());
        }
    }

    private static enum AlarmState {
        NONE,
        ALERT,
        FAULT;

    }

    private final class SimpleThreadFactory
    implements ThreadFactory {
        String tName;

        public SimpleThreadFactory(String tName) {
            this.tName = tName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.tName);
            t.setDaemon(true);
            t.setPriority(BAnalyticService.this.getThreadPriority());
            return t;
        }
    }

    public final class SimpleDiscardPolicy
    implements RejectedExecutionHandler {
        int triggeredPoolCapacity;
        String poolName;

        public SimpleDiscardPolicy(int triggeredPoolCapacity, String poolName) {
            this.triggeredPoolCapacity = triggeredPoolCapacity;
            this.poolName = poolName;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            Utils.log().log(Level.WARNING, Utils.lex("queueFull"), new Object[]{this.poolName, this.triggeredPoolCapacity, r});
        }
    }

    private final class EventTypeSubscriber
    extends TypeSubscriber {
        private final BComponentEventMask mask;

        BComponentEventMask getEvents() {
            return this.mask;
        }

        public EventTypeSubscriber(BComponentSpace space) {
            super(space);
            this.mask = BComponentEventMask.make((int)10);
            this.setMask(this.mask);
        }

        public final void event(BComponentEvent componentEvent) {
            Slot s;
            if (this.getEvents().includes(componentEvent.getId()) && (s = componentEvent.getSlot()) != null && s.getName().equals("a$3aa")) {
                BAnalyticService.this.aPointAdded();
            }
        }
    }

    private final class Check
    extends Thread {
        public Check(String tName) {
            this.setName(tName);
            this.setPriority(BAnalyticService.this.getThreadPriority());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (BAnalyticService.this.isRunning()) {
                try {
                    BAnalyticService.this.doHouseKeeping();
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

