/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup.file;

import com.tridium.cloud.client.backup.crypto.CipherStreams;
import com.tridium.json.JSONObject;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.agent.AgentList;
import javax.baja.file.BDataFile;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ext={@FileExt(name="edist")})
public final class BEncryptedDistributionFile
extends BDataFile {
    public static final Type TYPE = Sys.loadType(BEncryptedDistributionFile.class);
    private static final Logger log = Logger.getLogger("cloudBackup");
    private static final Pattern edistPattern = Pattern.compile("\\.edist$", 2);
    private static final BIcon icon = BIcon.std((String)"modules.png");
    public static final String mimeType = "application/vnd.tridium.baja.v0+edist";

    public BEncryptedDistributionFile(BIFileStore store) {
        super(store);
    }

    public BEncryptedDistributionFile() {
    }

    public Type getType() {
        return TYPE;
    }

    public String getMimeType() {
        return mimeType;
    }

    public BIcon getIcon() {
        return icon;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toBottom("web:FileDownloadView");
        return list;
    }

    @NiagaraRpc(permissions="R", isSecure=true, transports={@Transport(type=TransportType.box)})
    public boolean isDistFileAvailable(Context cx) {
        String distFileName = this.getDistFilePath().getName();
        BIDirectory parent = (BIDirectory)this.getFileSpace().findFile(this.getFilePath().getParent());
        return Arrays.stream(parent.listFiles()).anyMatch(file -> file.getFileName().equals(distFileName));
    }

    @NiagaraRpc(permissions="R", isSecure=true, transports={@Transport(type=TransportType.box)})
    public Map<String, Object> getKeyInfo(Context cx) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Getting key information");
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        try (DataInputStream in = new DataInputStream(this.getInputStream());){
            JSONObject header = CipherStreams.makeDecrypter().readHeader(in);
            info.put("salt", header.getString("salt"));
            info.put("iterationCount", header.getInt("iterationCount"));
            info.put("keySize", header.getInt("keySize"));
            info.put("keyFactory", header.getString("keyFactory"));
        }
        return info;
    }

    @NiagaraRpc(permissions="R", isSecure=true, transports={@Transport(type=TransportType.box)})
    public String decryptToDistUsingPassphrase(String passphrase, Context cx) throws IOException {
        if (Sys.getStation() != null) {
            throw new IOException("Cannot decrypt using passphrase from a Station!");
        }
        return this.decryptToDist(CipherStreams.makePassphraseKeyBuilder(passphrase.toCharArray()));
    }

    @NiagaraRpc(permissions="R", isSecure=true, transports={@Transport(type=TransportType.box)})
    public String decryptToDistUsingKey(String key, Context cx) {
        return this.decryptToDist(CipherStreams.makeEncodedEncryptedKeyBuilder(key));
    }

    private String decryptToDist(CipherStreams.KeyBuilder keyBuilder) {
        BIFile newFile = null;
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Attempting to decrypt a DIST file");
            }
            FilePath distFilePath = this.getDistFilePath();
            BIFile oldDistFile = this.getFileSpace().findFile(distFilePath);
            if (oldDistFile != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Attempting to delete old DIST file");
                }
                oldDistFile.delete();
            }
            newFile = this.getFileSpace().makeFile(distFilePath);
            try (InputStream in = CipherStreams.makeDecrypter().makeInputStream(this.getInputStream(), keyBuilder);
                 BufferedOutputStream out = new BufferedOutputStream(newFile.getOutputStream());){
                FileUtil.pipe((InputStream)in, (OutputStream)out);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Successfully decrypted to DIST file: " + newFile.getNavOrd());
            }
            return newFile.getOrdInSession().toString();
        }
        catch (Exception e) {
            log.log(Level.INFO, "Unable to decrypt backup", e);
            try {
                if (newFile != null) {
                    newFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }
    }

    private FilePath getDistFilePath() {
        return this.getFilePath().getParent().merge(BEncryptedDistributionFile.toDistFileName(this.getFilePath().getName()));
    }

    public static String toDistFileName(String eDistFileName) {
        return edistPattern.matcher(eDistFileName.trim()).replaceFirst(".dist");
    }
}

