/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup.crypto;

import com.tridium.cloud.client.backup.BCloudCreateBackupJob;
import java.util.Base64;
import java.util.Objects;
import javax.baja.sys.LocalizableException;

public final class CipherUtils {
    private static final String KEY_ALG_RSA_ECB_OAEP_SHA256_MGF1 = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private static final String KEY_ALG_RSA = "RSA";

    private CipherUtils() {
    }

    public static String validateKekAlgorithm(String kekAlg) throws Exception {
        try {
            Objects.requireNonNull(kekAlg);
            if (kekAlg.toUpperCase().startsWith(KEY_ALG_RSA)) {
                return kekAlg;
            }
            throw new IllegalArgumentException("Invalid key encryption algorithm: " + kekAlg);
        }
        catch (Exception e) {
            throw new LocalizableException(BCloudCreateBackupJob.TYPE.getModule().getModuleName(), "invalidKekAlgorithm");
        }
    }

    public static String validateKekId(String kekId) throws Exception {
        return kekId;
    }

    public static String validatePublicKey(String kek) throws Exception {
        try {
            Base64.getDecoder().decode(kek);
            return kek;
        }
        catch (IllegalArgumentException e) {
            throw new LocalizableException(BCloudCreateBackupJob.TYPE.getModule().getModuleName(), "invalidKek");
        }
    }
}

