/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup.crypto;

import com.tridium.cloud.client.backup.crypto.CipherUtils;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.baja.nre.util.SecurityUtil;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class CipherStreams {
    private static final SecureRandom random;
    private static final byte[] wellKnownHeader;
    public static final String VERSION_KEY = "version";
    public static final String TRANSFORM_KEY = "transform";
    public static final String KEY_ALGORITHM_KEY = "keyAlgorithm";
    public static final String KEY_SIZE_KEY = "keySize";
    public static final String INITIALIZATION_VECTOR_KEY = "initializationVector";
    public static final String SALT_KEY = "salt";
    public static final String ITERATION_COUNT_KEY = "iterationCount";
    public static final String KEY_FACTORY_KEY = "keyFactory";
    public static final String DEFAULT_VERSION = "1";
    public static final String DEFAULT_TRANSFORM = "AES/CBC/PKCS5Padding";
    public static final String DEFAULT_KEY_ALGORITHM = "AES";
    public static final int DEFAULT_KEY_SIZE = 256;
    public static final int DEFAULT_ITERATION_COUNT = 4096;
    public static final int DEFAULT_SALT_LENGTH = 16;
    public static final String DEFAULT_KEY_FACTORY = "PBKDF2WithHmacSHA256";

    private CipherStreams() {
    }

    public static Decrypter makeDecrypter() {
        return DecrypterHolder.INSTANCE;
    }

    private static KeyBuilder makeEncryptedKeyBuilder(byte[] key) {
        return (salt, iterationCount, keySize, keyFactory) -> key;
    }

    public static KeyBuilder makePassphraseKeyBuilder(char[] passphrase) {
        return (salt, iterationCount, keySize, keyFactory) -> CipherStreams.createPasskey(passphrase, salt, iterationCount, keySize, keyFactory);
    }

    public static KeyBuilder makeEncodedEncryptedKeyBuilder(String key) {
        return (salt, iterationCount, keySize, keyFactory) -> Base64.getDecoder().decode(key);
    }

    public static Encrypter makeEncrypter() {
        return new Encrypter(DEFAULT_TRANSFORM, DEFAULT_KEY_ALGORITHM, 256, null, null, 4096, DEFAULT_KEY_FACTORY);
    }

    public static Encrypter makeEncrypter(String transform, String keyAlg, int keySize, byte[] iv, byte[] salt, int iterationCount, String keyFactory) {
        return new Encrypter(transform, keyAlg, keySize, iv, salt, iterationCount, keyFactory);
    }

    public static byte[] createPasskey(char[] passphrase, byte[] salt, int iterationCount, int keySize, String keyFactory) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        CipherStreams.validatePassPhrase(passphrase);
        PBEKeySpec keySpec = new PBEKeySpec(passphrase, salt, iterationCount, keySize);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(keyFactory);
        return keyFac.generateSecret(keySpec).getEncoded();
    }

    public static byte[] encryptPasskeyUsingPublicKey(byte[] bPublicKey, String publicKeyAlg, byte[] passKey) throws Exception {
        String kekAlg = CipherUtils.validateKekAlgorithm(publicKeyAlg);
        Cipher cipher = Cipher.getInstance(kekAlg);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bPublicKey);
        String kfAlg = kekAlg.split("/")[0];
        KeyFactory keyFactory = KeyFactory.getInstance(kfAlg);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        cipher.init(1, publicKey);
        return cipher.doFinal(passKey);
    }

    private static void validatePassPhrase(char[] passphrase) throws InvalidKeyException {
        if (passphrase == null || passphrase.length == 0) {
            throw new InvalidKeyException("Passphrase can't be null or empty");
        }
    }

    static {
        SecureRandom tRandom;
        try {
            tRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            tRandom = new SecureRandom();
        }
        random = tRandom;
        try {
            wellKnownHeader = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Encrypter {
        private final String transform;
        private final String keyAlg;
        private final int keySize;
        private final byte[] iv;
        private final byte[] salt;
        private final int iterationCount;
        private final String keyFactory;

        private Encrypter(String transform, String keyAlg, int keySize, byte[] iv, byte[] salt, int iterationCount, String keyFactory) {
            this.transform = transform;
            this.keyAlg = keyAlg;
            this.keySize = keySize;
            this.iv = iv;
            this.iterationCount = iterationCount;
            this.keyFactory = keyFactory;
            if (salt == null) {
                this.salt = new byte[16];
                random.nextBytes(this.salt);
            } else {
                this.salt = salt;
            }
        }

        public byte[] makePasskey(char[] passphrase) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
            CipherStreams.validatePassPhrase(passphrase);
            return CipherStreams.createPasskey(passphrase, this.salt, this.iterationCount, this.keySize, this.keyFactory);
        }

        public OutputStream makeOutputStream(OutputStream out, byte[] passkey) throws IOException, InvalidKeyException {
            DataOutputStream dOut = new DataOutputStream(out);
            try {
                SecretKeySpec key = new SecretKeySpec(passkey, this.keyAlg);
                Cipher cipher = Cipher.getInstance(this.transform);
                byte[] _iv = this.iv;
                if (_iv == null) {
                    _iv = new byte[cipher.getBlockSize()];
                    random.nextBytes(_iv);
                }
                JSONObject params = new JSONObject();
                params.put(CipherStreams.VERSION_KEY, (Object)CipherStreams.DEFAULT_VERSION);
                params.put(CipherStreams.TRANSFORM_KEY, (Object)this.transform);
                params.put(CipherStreams.KEY_ALGORITHM_KEY, (Object)this.keyAlg);
                params.put(CipherStreams.KEY_SIZE_KEY, this.keySize);
                params.put(CipherStreams.ITERATION_COUNT_KEY, this.iterationCount);
                params.put(CipherStreams.KEY_FACTORY_KEY, (Object)this.keyFactory);
                params.put(CipherStreams.SALT_KEY, (Object)Base64.getEncoder().encodeToString(this.salt));
                params.put(CipherStreams.INITIALIZATION_VECTOR_KEY, (Object)Base64.getEncoder().encodeToString(_iv));
                dOut.writeUTF(params.toString());
                cipher.init(1, (Key)key, new IvParameterSpec(_iv), random);
                CipherOutputStream cout = new CipherOutputStream(out, cipher);
                cout.write(wellKnownHeader);
                return cout;
            }
            catch (Exception e) {
                try {
                    dOut.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (e instanceof InvalidKeyException) {
                    throw (InvalidKeyException)e;
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }

        public String toString() {
            return "1-" + this.transform + '-' + CipherStreams.DEFAULT_KEY_FACTORY + '-' + this.keyAlg + '-' + this.keySize;
        }
    }

    public static interface KeyBuilder {
        public byte[] make(byte[] var1, int var2, int var3, String var4) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException;
    }

    public static final class Decrypter {
        private Decrypter() {
        }

        public InputStream makeInputStreamFromPassphrase(InputStream in, char[] passphrase) throws IOException, InvalidKeyException {
            CipherStreams.validatePassPhrase(passphrase);
            return this.makeInputStream(in, CipherStreams.makePassphraseKeyBuilder(passphrase));
        }

        public InputStream makeInputStreamFromEncodedEncryptedKey(InputStream in, String key) throws IOException, InvalidKeyException {
            return this.makeInputStream(in, CipherStreams.makeEncodedEncryptedKeyBuilder(key));
        }

        public InputStream makeInputStreamFromUnencodedEncryptedKey(InputStream in, byte[] key) throws IOException, InvalidKeyException {
            return this.makeInputStream(in, CipherStreams.makeEncryptedKeyBuilder(key));
        }

        public InputStream makeInputStream(InputStream in, KeyBuilder keyBuilder) throws IOException, InvalidKeyException {
            DataInputStream dIn = new DataInputStream(in);
            try {
                JSONObject params = this.readHeader(dIn);
                byte[] salt = Base64.getDecoder().decode(params.getString(CipherStreams.SALT_KEY));
                int iterationCount = params.getInt(CipherStreams.ITERATION_COUNT_KEY);
                int keySize = params.getInt(CipherStreams.KEY_SIZE_KEY);
                byte[] encodedKey = keyBuilder.make(salt, iterationCount, keySize, params.getString(CipherStreams.KEY_FACTORY_KEY));
                SecretKeySpec key = new SecretKeySpec(encodedKey, params.getString(CipherStreams.KEY_ALGORITHM_KEY));
                byte[] iv = Base64.getDecoder().decode(params.getString(CipherStreams.INITIALIZATION_VECTOR_KEY));
                Cipher cipher = Cipher.getInstance(params.getString(CipherStreams.TRANSFORM_KEY));
                cipher.init(2, (Key)key, new IvParameterSpec(iv));
                CipherInputStream cin = new CipherInputStream(dIn, cipher);
                byte[] header = new byte[wellKnownHeader.length];
                int bytesRead = cin.read(header);
                if (bytesRead < 0) {
                    throw new IOException("Could not read stream header");
                }
                if (!SecurityUtil.equals((byte[])header, (byte[])wellKnownHeader)) {
                    throw new InvalidKeyException("Passphrase mismatch!");
                }
                return cin;
            }
            catch (Exception e) {
                try {
                    dIn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (e instanceof InvalidKeyException) {
                    throw (InvalidKeyException)e;
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }

        public JSONObject readHeader(DataInputStream in) throws IOException {
            String paramStr = in.readUTF();
            if (paramStr.isEmpty()) {
                throw new IllegalArgumentException("Encoded cipher header can't be empty");
            }
            return new JSONObject(new JSONTokener((Reader)new StringReader(paramStr)));
        }
    }

    private static final class DecrypterHolder {
        private static final Decrypter INSTANCE = new Decrypter();

        private DecrypterHolder() {
        }
    }
}

