/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup;

import com.tridium.cloud.client.BCloudConnector;
import com.tridium.cloud.client.BIBearerTokenProvider;
import com.tridium.cloud.client.backup.BCloudBackupService;
import com.tridium.cloud.client.backup.crypto.CipherStreams;
import com.tridium.cloud.client.backup.file.BEncryptedDistributionFile;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.cloud.util.StandardHttpUtils;
import com.tridium.history.audit.BAuditHistoryService;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.baja.backup.BBackupService;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.AuditEvent;
import javax.baja.security.BIProtected;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class BackupDownloadServlet
extends HttpServlet {
    private static final String error = "error";
    private static final String invalidKey = "invalidkey";
    private static final String keyinfo = "keyinfo";
    private static final String filter = "filter";
    private static final String contentDisposition = "Content-Disposition";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (invalidKey.equals(request.getParameter(error))) {
            this.showInvalidKeyError(request, response);
        } else if (keyinfo.equals(request.getParameter(filter))) {
            this.downloadKeyInfo(request, response);
        } else {
            response.sendError(404);
        }
    }

    private void showInvalidKeyError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        Context cx = (Context)request.getAttribute("niagara.context");
        Lexicon lex = Lexicon.make((BModule)BCloudBackupService.TYPE.getModule(), (Context)cx);
        out.write("<!DOCTYPE html>");
        out.write(String.format("<html><head><title>%s</title></head>", lex.get("invalidPassphrase")));
        out.write(String.format("<body><h2>%s</h2>", lex.get("invalidPassphraseTryAgain")));
        out.write(String.format("<button onclick='window.history.back();'>%s</button>", lex.get("goBack")));
        out.write("</body></html>");
    }

    private void downloadKeyInfo(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!request.isSecure()) {
            throw new ServletException("Unencrypted backups can only be downloaded over a secure connection!");
        }
        String backupId = this.getBackupId(request, response);
        if (backupId.isEmpty()) {
            return;
        }
        BCloudBackupService backupSrv = (BCloudBackupService)Sys.getService((Type)BCloudBackupService.TYPE);
        if (!this.userHasPermission(backupSrv, response)) {
            return;
        }
        String downloadUri = BackupDownloadServlet.makeDownloadUri(backupSrv, backupId);
        try {
            try {
                CipherStreams.Decrypter decrypter = CipherStreams.makeDecrypter();
                JSONObject header = (JSONObject)StandardHttpUtils.getInstance().get(downloadUri, HttpUtils.makeAuthHeaderMap((String)backupSrv.getBearerToken()), Optional.of(in -> {
                    try (DataInputStream dataIn = new DataInputStream((InputStream)in);){
                        JSONObject jSONObject = decrypter.readHeader(dataIn);
                        return jSONObject;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }), Optional.empty());
                response.setContentType("application/json; charset=utf-8");
                try (PrintWriter writer = response.getWriter();){
                    JSONWriter out = new JSONWriter((Appendable)writer);
                    out.object().key("salt").value((Object)header.getString("salt")).key("iterationCount").value((long)header.getInt("iterationCount")).key("keySize").value((long)header.getInt("keySize")).key("keyFactory").value((Object)header.getString("keyFactory")).endObject();
                }
            }
            catch (RuntimeException e) {
                Throwable inner = e.getCause();
                if (inner != null && inner instanceof IOException) {
                    throw (Exception)inner;
                }
                throw e;
            }
        }
        catch (Exception e) {
            this.log("Error reading backup", e);
            response.sendError(500);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String key = BackupDownloadServlet.decodeValue(request.getParameterValues("value"));
        boolean decrypt = BackupDownloadServlet.decodeValue(request.getParameterValues("process")).equalsIgnoreCase("true");
        if (decrypt && !request.isSecure()) {
            throw new ServletException("Unencrypted backups can only be downloaded over a secure connection!");
        }
        response.setContentType("application/vnd.tridium.baja.v0+edist");
        String backupId = this.getBackupId(request, response);
        if (backupId.isEmpty()) {
            return;
        }
        BCloudBackupService backupSrv = (BCloudBackupService)Sys.getService((Type)BCloudBackupService.TYPE);
        if (!this.userHasPermission(backupSrv, response)) {
            return;
        }
        String downloadUri = BackupDownloadServlet.makeDownloadUri(backupSrv, backupId);
        BAuditHistoryService auditHistorySrv = (BAuditHistoryService)Sys.getService((Type)BAuditHistoryService.TYPE);
        auditHistorySrv.audit(new AuditEvent("Invoked", backupSrv.getSlotPath().toDisplayString(), "download", "", downloadUri, request.getRemoteUser()));
        try {
            try {
                CipherStreams.Decrypter decrypter = CipherStreams.makeDecrypter();
                StandardHttpUtils.getInstance().get(downloadUri, HttpUtils.makeAuthHeaderMap((String)backupSrv.getBearerToken()), Optional.of(in -> {
                    try (InputStream newIn = decrypt ? decrypter.makeInputStreamFromEncodedEncryptedKey((InputStream)in, key) : in;
                         ServletOutputStream out = response.getOutputStream();){
                        FileUtil.pipe((InputStream)newIn, (OutputStream)out);
                    }
                    catch (IOException | InvalidKeyException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }), Optional.of(headers -> {
                    for (String headerVal : (List)headers.get(contentDisposition)) {
                        response.setHeader(contentDisposition, decrypt ? BEncryptedDistributionFile.toDistFileName(headerVal) : headerVal);
                    }
                }));
                auditHistorySrv.audit(new AuditEvent("Completed", backupSrv.getSlotPath().toDisplayString(), "download", "", downloadUri, request.getRemoteUser()));
            }
            catch (RuntimeException e) {
                Throwable inner = e.getCause();
                if (inner != null && (inner instanceof IOException || inner instanceof InvalidKeyException)) {
                    throw (Exception)inner;
                }
                throw e;
            }
        }
        catch (InvalidKeyException e) {
            this.log("Invalid passphrase entered", e);
            response.sendRedirect(String.format("%s?%s=%s", request.getRequestURI(), error, invalidKey));
        }
        catch (Exception e) {
            this.log("Error reading backup", e);
            response.sendError(500);
        }
    }

    private boolean userHasPermission(BBackupService backupSrv, HttpServletResponse response) throws IOException {
        boolean access;
        BUser user = BUser.getCurrentAuthenticatedUser();
        boolean bl = access = user != null && user.getPermissionsFor((BIProtected)backupSrv).has(16);
        if (!access) {
            this.log("User must have admin read privileges to download back up");
            response.sendError(401);
        }
        return access;
    }

    private static String makeDownloadUri(BCloudBackupService backupSrv, String backupId) throws ServletException {
        Optional connectorSrv = BIBearerTokenProvider.getCloudConnector();
        if (!connectorSrv.isPresent()) {
            throw new ServletException("Cannot find Bearer Token Cloud Connector");
        }
        return String.format("%s/api/v1/systems/%s/backups/%s", backupSrv.getBackupUrl(), ((BCloudConnector)connectorSrv.get()).getId(), backupId);
    }

    private String getBackupId(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String backupId = Objects.toString(request.getPathInfo(), "/");
        if (backupId.isEmpty()) {
            this.log("Invalid back up id: " + backupId);
            response.sendError(404);
        }
        return backupId;
    }

    private static String decodeValue(String[] values) {
        return values != null && values.length > 0 ? values[0] : "";
    }
}

