/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup;

import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="manual"), @Range(value="ninetyDays"), @Range(value="thirtyDays"), @Range(value="sevenDays")})
public final class BRandomizedTimeTriggerMode
extends BFrozenEnum {
    public static final int MANUAL = 0;
    public static final int NINETY_DAYS = 1;
    public static final int THIRTY_DAYS = 2;
    public static final int SEVEN_DAYS = 3;
    public static final BRandomizedTimeTriggerMode manual = new BRandomizedTimeTriggerMode(0);
    public static final BRandomizedTimeTriggerMode ninetyDays = new BRandomizedTimeTriggerMode(1);
    public static final BRandomizedTimeTriggerMode thirtyDays = new BRandomizedTimeTriggerMode(2);
    public static final BRandomizedTimeTriggerMode sevenDays = new BRandomizedTimeTriggerMode(3);
    public static final BRandomizedTimeTriggerMode DEFAULT = manual;
    public static final Type TYPE = Sys.loadType(BRandomizedTimeTriggerMode.class);

    public static BRandomizedTimeTriggerMode make(int ordinal) {
        return (BRandomizedTimeTriggerMode)manual.getRange().get(ordinal, false);
    }

    public static BRandomizedTimeTriggerMode make(String tag) {
        return (BRandomizedTimeTriggerMode)manual.getRange().get(tag);
    }

    private BRandomizedTimeTriggerMode(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public long getMillis() {
        long ms = -1L;
        if (this.isNinetyDays()) {
            ms = BRandomizedTimeTriggerMode.daysToMilliseconds(90L);
        } else if (this.isThirtyDays()) {
            ms = BRandomizedTimeTriggerMode.daysToMilliseconds(30L);
        } else if (this.isSevenDays()) {
            ms = BRandomizedTimeTriggerMode.daysToMilliseconds(7L);
        }
        return ms;
    }

    public boolean isManual() {
        return this.equals((Object)manual);
    }

    public boolean isNinetyDays() {
        return this.equals((Object)ninetyDays);
    }

    public boolean isThirtyDays() {
        return this.equals((Object)thirtyDays);
    }

    public boolean isSevenDays() {
        return this.equals((Object)sevenDays);
    }

    private static long daysToMilliseconds(long days) {
        return days * 24L * 60L * 60L * 1000L;
    }
}

