/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup;

import com.tridium.backup.BBackupRecord;
import com.tridium.cloud.client.BCloudConnector;
import com.tridium.cloud.client.BIBearerTokenProvider;
import com.tridium.cloud.client.backup.BCloudBackupJob;
import com.tridium.cloud.client.backup.BCloudBackupService;
import com.tridium.cloud.client.backup.SlicedOutputStream;
import com.tridium.cloud.client.backup.crypto.CipherStreams;
import com.tridium.cloud.client.backup.crypto.CipherUtils;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.cloud.util.StandardHttpUtils;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.sys.station.Station;
import com.tridium.util.TimeFormat;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.baja.backup.BBackupService;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BCloudCreateBackupJob
extends BCloudBackupJob {
    public static final Type TYPE = Sys.loadType(BCloudCreateBackupJob.class);
    private static final int defaultBlockSize = Integer.getInteger("niagara.cloud.backup.blocksize", 0);
    private static final String jsonKeyAdded = "added";
    private static final String jsonKeyRemoved = "removed";
    private static final String jsonKeyBackupId = "backupId";
    private static final String jsonKeyNotes = "notes";
    private static final String jsonKeyTimestamp = "timestamp";
    private String remoteAddr = "";
    private String userName = "";
    private String notes = "";
    private String retention = "";
    private BAbsTime timestamp = BAbsTime.DEFAULT;
    private static final Pattern NOT_ALPHANUMERIC_DOT_DASH = Pattern.compile("[^a-zA-Z0-9.-]");
    private final HttpUtils httpUtils = StandardHttpUtils.getInstance();
    private static final String NOT_SHARED = "private";
    private static final String PRIVATE = "private";
    private static final String MIME_TYPE_KEY = "mimeType";
    private static final String REMOTE_USER_KEY = "remoteUser";
    private static final String NOTES_KEY = "notes";
    private static final String RETENTION_KEY = "retention";
    private static final String SYSTEM_GUID_KEY = "systemGuid";
    private static final String FILE_NAME_KEY = "fileName";
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String TIME_ZONE_KEY = "timeZone";
    private static final String ALG_KEY = "alg";
    private static final String BLOCK_IDS_KEY = "blockIds";
    private static final String KEY_ENCRYPTION_KEY = "kek";
    private static final String KEK_ALG_KEY = "kekAlg";
    private static final String KEK_ID_KEY = "kekId";
    private static final String ENCRYPTED_KEY_KEY = "dek";

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCloudCreateBackupJob() {
    }

    BCloudCreateBackupJob(String remoteAddr, String userName, String notes, String retention) {
        this.remoteAddr = remoteAddr;
        this.userName = userName;
        this.notes = notes;
        this.retention = retention;
    }

    public void run(Context cx) throws Exception {
        SecretBytes passkey = null;
        try {
            String encryptedPasskey;
            String ncKeyId;
            String ncPubKeyAlg;
            String ncPubKey;
            this.timestamp = BAbsTime.now();
            this.log("cloudBackupJob.runningBackup", new Object[0]);
            this.log("cloudBackupJob.remoteAddr", this.remoteAddr);
            BCloudBackupService backupSrv = BCloudBackupService.getBackupService();
            Optional connectorSrv = BIBearerTokenProvider.getCloudConnector();
            if (!connectorSrv.isPresent()) {
                throw new LocalizableException(this.getType().getModule().getModuleName(), "connectorNotAvailable");
            }
            if (!((BCloudConnector)connectorSrv.get()).isConnected()) {
                throw new LocalizableException(this.getType().getModule().getModuleName(), "notConnected");
            }
            this.log("cloudBackupJob.savingStation", new Object[0]);
            Station.saveSync((BJob)this, (int)10);
            this.log("cloudBackupJob.creatingBackupId", new Object[0]);
            String systemGuid = ((BCloudConnector)connectorSrv.get()).getId();
            JSONObject backupObj = (JSONObject)this.httpUtils.post(String.format("%s/api/v1/systems/%s/backups", backupSrv.getBackupUrl(), systemGuid), "application/json; charset=UTF-8", HttpUtils.makeAuthHeaderMap((String)backupSrv.getBearerToken()), -1L, Optional.empty(), Optional.of(HttpUtils::fromInputStreamToJsonObject), Optional.empty());
            String backupId = backupObj.getString("id");
            try {
                ncPubKey = CipherUtils.validatePublicKey(backupObj.getString(KEY_ENCRYPTION_KEY));
                ncPubKeyAlg = CipherUtils.validateKekAlgorithm(backupObj.getString(KEK_ALG_KEY));
                ncKeyId = CipherUtils.validateKekId(backupObj.getString(KEK_ID_KEY));
            }
            catch (JSONException e) {
                throw new LocalizableException(this.getType().getModule().getModuleName(), "invalidEncryptionParams");
            }
            String baseBackupUri = BCloudCreateBackupJob.convertUrlHostName(backupSrv.getBackupUrl(), backupObj.getString("hostName"));
            this.log("cloudBackupJob.backingUpTo", backupSrv.getBackupUrl(), baseBackupUri);
            this.log("cloudBackupJob.writingToBackupId", backupId);
            String backupUri = String.format("%s/api/v1/systems/%s/backups/%s", baseBackupUri, systemGuid, backupId);
            final ArrayList blockIds = new ArrayList();
            int blockSizeInBytes = defaultBlockSize;
            if (blockSizeInBytes <= 0) {
                blockSizeInBytes = backupSrv.getBlockSize() * 1024 * 1024;
            } else {
                this.log("cloudBackupJob.usingSysPropBlockSize", new Object[0]);
            }
            this.log("cloudBackupJob.blockSize", blockSizeInBytes / 1024);
            CipherStreams.Encrypter encrypter = CipherStreams.makeEncrypter();
            try (SecretChars passphrase = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getSystemPassword());){
                passkey = new SecretBytes(encrypter.makePasskey(passphrase.get()), false);
                backupSrv.zip((BJob)this, new BufferedOutputStream(encrypter.makeOutputStream(new SlicedOutputStream(blockSizeInBytes, () -> {
                    try {
                        return AccessController.doPrivileged(() -> {
                            final HttpURLConnection conn = HttpUtils.makeConnection((URI)new URI(backupUri));
                            conn.setUseCaches(false);
                            conn.setDoOutput(true);
                            conn.setRequestMethod("PUT");
                            conn.setRequestProperty("Content-Type", "application/octet-stream");
                            conn.setRequestProperty("Authorization", "Bearer " + backupSrv.getBearerToken());
                            return new FilterOutputStream(conn.getOutputStream()){
                                private boolean closed;

                                @Override
                                public void write(byte[] b, int off, int len) throws IOException {
                                    this.out.write(b, off, len);
                                }

                                @Override
                                public void close() throws IOException {
                                    if (this.closed) {
                                        return;
                                    }
                                    super.close();
                                    this.closed = true;
                                    try (InputStreamReader reader = new InputStreamReader(conn.getInputStream());){
                                        JSONObject obj = new JSONObject(new JSONTokener((Reader)reader));
                                        String bid = obj.getString("id");
                                        BCloudCreateBackupJob.this.log("cloudBackupJob.writtenBlockId", new Object[]{bid});
                                        blockIds.add(bid);
                                    }
                                }
                            };
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Exception inner = e.getException();
                        if (inner instanceof RuntimeException) {
                            throw (RuntimeException)inner;
                        }
                        throw new RuntimeException(e);
                    }
                }), passkey.get())), true);
            }
            this.log("cloudBackupJob.blocksWritten", new Object[0]);
            BEnum shareMode = backupSrv.getShareMode();
            if (shareMode.getOrdinal() == 0) {
                try (SecretBytes publicKeyBytes = new SecretBytes(Base64.getDecoder().decode(ncPubKey), true);){
                    encryptedPasskey = Base64.getEncoder().encodeToString(CipherStreams.encryptPasskeyUsingPublicKey(publicKeyBytes.get(), ncPubKeyAlg, passkey.get()));
                }
            } else {
                encryptedPasskey = "private";
                ncKeyId = "private";
                ncPubKeyAlg = "private";
            }
            passkey.close();
            JSONObject commitInfo = new JSONObject();
            commitInfo.put(MIME_TYPE_KEY, (Object)"application/vnd.tridium.baja.v0+edist");
            commitInfo.put(REMOTE_USER_KEY, (Object)this.userName);
            commitInfo.put("notes", (Object)this.notes);
            commitInfo.put(RETENTION_KEY, (Object)this.retention);
            commitInfo.put(SYSTEM_GUID_KEY, (Object)systemGuid);
            commitInfo.put(FILE_NAME_KEY, (Object)BCloudCreateBackupJob.createBackupFileName());
            commitInfo.put("timestamp", (Object)this.timestamp.encodeToString());
            commitInfo.put(TIME_ZONE_KEY, (Object)this.timestamp.getTimeZone().getId());
            commitInfo.put(ALG_KEY, (Object)encrypter.toString());
            commitInfo.put(ENCRYPTED_KEY_KEY, (Object)encryptedPasskey);
            commitInfo.put(KEK_ID_KEY, (Object)ncKeyId);
            commitInfo.put(KEK_ALG_KEY, (Object)ncPubKeyAlg);
            commitInfo.put(BLOCK_IDS_KEY, (Object)new JSONArray(blockIds));
            JSONObject response = (JSONObject)this.httpUtils.post(backupUri, "application/json; charset=UTF-8", HttpUtils.makeAuthHeaderMap((String)backupSrv.getBearerToken()), -1L, Optional.of(HttpUtils.fromStringToOutputStreamFunc((Object)commitInfo)), Optional.of(HttpUtils::fromInputStreamToJsonObject), Optional.empty());
            this.log("cloudBackupJob.committedBackup", new Object[0]);
            JSONArray addedBackups = response.getJSONArray(jsonKeyAdded);
            JSONArray removedBackups = response.getJSONArray(jsonKeyRemoved);
            this.log("cloudBackupJob.addedBackups", addedBackups.length(), BCloudCreateBackupJob.extractBackupInfo(addedBackups));
            this.log("cloudBackupJob.removedBackups", removedBackups.length(), BCloudCreateBackupJob.extractBackupInfo(removedBackups));
            BBackupRecord rec = new BBackupRecord();
            rec.setTimestamp(BAbsTime.make());
            rec.setHost(this.remoteAddr);
            rec.setPath("cloud:" + this.userName);
            rec.setUser(this.userName);
            rec.append((BBackupService)backupSrv);
            this.log("cloudBackupJob.encryptedBackup", new Object[0]);
            this.log("cloudBackupJob.backupSuccess", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (passkey != null) {
                passkey.close();
            }
            backupRunning.set(false);
        }
    }

    public static String convertUrlHostName(String url, String newHostName) throws URISyntaxException, UnknownHostException {
        return url.replace(new URI(url).getHost(), newHostName);
    }

    private static String createBackupFileName() {
        String stationName = Sys.getStation().getStationName();
        String timestamp = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYYYMMDD_HHmmss");
        return NOT_ALPHANUMERIC_DOT_DASH.matcher(String.format("backup_%s_%s.edist", stationName, timestamp)).replaceAll("_");
    }

    private static String extractBackupInfo(JSONArray arr) {
        return IntStream.range(0, arr.length()).boxed().map(arg_0 -> ((JSONArray)arr).optJSONObject(arg_0)).filter(Objects::nonNull).map(jo -> String.format("{'id':'%s', 'notes':'%s', 'timestamp':'%s'}", jo.getString(jsonKeyBackupId), jo.getString("notes"), jo.getString("timestamp"))).collect(Collectors.joining("; ", "[", "]"));
    }

    public void failed(Throwable cause) {
        super.failed(cause);
        String causeStr = Objects.toString(cause.getMessage());
        BCloudBackupService.getBackupService().backupFailed(causeStr, this.remoteAddr, this.userName, this.timestamp);
    }

    static boolean isBackupRunning() {
        return backupRunning.get();
    }

    private void log(String lexKey, Object ... args) {
        String[] lexArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            lexArgs[i] = args[i].toString();
        }
        String moduleName = this.getType().getModule().getModuleName();
        this.log().message(moduleName, lexKey, lexArgs);
    }
}

