/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup;

import com.tridium.cloud.client.backup.BCloudBackupService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BCloudBackupJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BCloudBackupJob.class);
    protected static final AtomicBoolean backupRunning = new AtomicBoolean();

    public Type getType() {
        return TYPE;
    }

    public void doRun(Context cx) {
        BCloudBackupService backupSrv = BCloudBackupService.getBackupService();
        if (backupRunning.getAndSet(true)) {
            this.failed((Throwable)new LocalizableException(this.getType().getModule().getModuleName(), "cloudJob.alreadyRunning"));
            return;
        }
        try {
            backupSrv.checkHealth();
            super.doRun(cx);
        }
        finally {
            backupRunning.getAndSet(false);
        }
    }
}

