/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.ui;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnDeviceFolder;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnControllerEntry;
import com.tridium.ccn.components.BCcnControllerList;
import com.tridium.ccn.enums.BCcnDeviceTypeEnum;
import com.tridium.ccn.job.BCcnLearnDevicesJob;
import java.util.Vector;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"ccn:CcnNetwork", "ccn:CcnDeviceFolder"}, requiredPermissions="r")})
public class BCcnDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BCcnDeviceManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colBusAddress = new MgrColumn.Prop(BCcnDevice.busNo, 1);
    MgrColumn colElemAddress = new MgrColumn.Prop(BCcnDevice.elemNo, 1);
    MgrColumn colDeviceStatus = new MgrColumn.Prop(BCcnDevice.deviceStatus, 1);
    MgrColumn colDeviceType = new MgrColumn.Prop(BCcnDevice.deviceType, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colName, new DeviceExtsColumn((BDevice)new BCcnDevice()), this.colBusAddress, this.colElemAddress, this.colDeviceType, this.colStatus, this.colHealth, this.colDeviceStatus};
    BCcnNetwork ccnNetwork;
    private static final Lexicon lex = Lexicon.make(BCcnDeviceManager.class);
    private static final BImage ccnDeviceIcon = BImage.make((String)"module://icons/x16/device.png");
    private static final Log ccnLog = Log.getLog((String)"CCNNetworkLog");

    public Type getType() {
        return TYPE;
    }

    public BCcnNetwork getNetwork() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BCcnDeviceFolder) {
            return (BCcnNetwork)((BCcnDeviceFolder)owner).getNetwork();
        }
        if (owner instanceof BCcnNetwork) {
            return (BCcnNetwork)owner;
        }
        return null;
    }

    public BCcnDeviceFolder getDeviceFolder() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BCcnDeviceFolder) {
            return (BCcnDeviceFolder)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    void updateLearnData() {
        try {
            Object[] devices = (BCcnControllerEntry[])this.getNetwork().getLearnedDevices().getChildren(BCcnControllerEntry.class);
            if (devices != null && devices.length > 0) {
                for (int i = 0; i < devices.length; ++i) {
                    devices[i].lease();
                }
            }
            this.getLearn().updateRoots(devices);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected MgrModel makeModel() {
        return new TridiumCCNModel(this);
    }

    protected MgrController makeController() {
        return new TridiumCCNController(this);
    }

    protected MgrLearn makeLearn() {
        return new TridiumCCNLearn(this);
    }

    class TridiumCCNController
    extends DeviceController {
        TridiumCCNController(BDeviceManager mgr) {
            super(mgr);
            this.newCommand.setEnabled(true);
        }

        public CommandArtifact doCancel(Context cx) throws Exception {
            return super.doCancel(cx);
        }

        public CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            try {
                BCcnControllerList controllerList = null;
                Object[] disSelRows = this.getLearnTable().getSelectedObjects();
                int notExistDeviceCOunt = 0;
                Vector<BCcnControllerEntry> vec = new Vector<BCcnControllerEntry>(0);
                Object[] createList = null;
                for (int i = 0; i < disSelRows.length; ++i) {
                    boolean isExisting = false;
                    if (BCcnDeviceManager.this.getLearn().getExisting(disSelRows[i]) != null) {
                        isExisting = true;
                        continue;
                    }
                    if (isExisting) continue;
                    ++notExistDeviceCOunt;
                    vec.addElement((BCcnControllerEntry)discovery[i]);
                }
                createList = new BCcnControllerEntry[vec.size()];
                vec.copyInto(createList);
                controllerList = new BCcnControllerList((BCcnControllerEntry[])createList);
                if (BCcnDeviceManager.this.getCurrentValue() instanceof BCcnNetwork) {
                    BCcnNetwork network = BCcnDeviceManager.this.getNetwork();
                    if (network == null) {
                        throw new Exception("Network is null, can not add devices");
                    }
                    if (controllerList.getControllerList().length > 0) {
                        BOrd ordToAddDevicesJob = network.submitAddDevicesJob(controllerList);
                        BCcnDeviceManager.this.getLearn().setJob(ordToAddDevicesJob);
                    } else {
                        BDialog.message(null, (Object)"The selected device/s are already added to station database");
                    }
                } else if (BCcnDeviceManager.this.getCurrentValue() instanceof BCcnDeviceFolder) {
                    BCcnDeviceFolder deviceFolder = BCcnDeviceManager.this.getDeviceFolder();
                    if (deviceFolder == null) {
                        throw new Exception("DeviceFolder is null, can not add devices");
                    }
                    if (controllerList.getControllerList().length > 0) {
                        BOrd ordToAddDevicesJob = deviceFolder.submitAddDevicesJob(controllerList);
                        BCcnDeviceManager.this.getLearn().setJob(ordToAddDevicesJob);
                    }
                }
                return null;
            }
            catch (Exception e) {
                ccnLog.error("Exception occurred while adding device", (Throwable)e);
                return null;
            }
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BCcnControllerEntry[] learnedDevices = (BCcnControllerEntry[])BCcnDeviceManager.this.getNetwork().getLearnedDevices().getChildren(BCcnControllerEntry.class);
            if (learnedDevices.length > 0) {
                BCcnDeviceManager.this.getNetwork().getLearnedDevices().removeAll();
            }
            BCcnDeviceManager.this.ccnNetwork = BCcnDeviceManager.this.getNetwork();
            if (BCcnDeviceManager.this.ccnNetwork == null) {
                throw new Exception("Network null, can not discover devices");
            }
            this.discover.setEnabled(false);
            BOrd ordToDiscoveryJob = BCcnDeviceManager.this.ccnNetwork.submitDeviceDiscoveryJob();
            BCcnDeviceManager.this.getLearn().setJob(ordToDiscoveryJob);
            return null;
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            super.cellDoubleClicked(table, event, row, col);
        }

        public void updateCommands() {
            super.updateCommands();
            BObject owner = BCcnDeviceManager.this.getCurrentValue();
            if (owner instanceof BCcnDeviceFolder) {
                this.newFolder.setEnabled(false);
            } else {
                this.newFolder.setEnabled(true);
            }
        }
    }

    class TridiumCCNLearn
    extends MgrLearn {
        TridiumCCNLearn(BDeviceManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BCcnControllerEntry.devName), new MgrColumn.Prop(BCcnControllerEntry.busNo), new MgrColumn.Prop(BCcnControllerEntry.elemNo), new MgrColumn.Prop(BCcnControllerEntry.devType)};
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return MgrTypeInfo.makeArray((Type)BCcnDeviceManager.this.getNetwork().getDeviceType());
        }

        public final BImage getIcon(Object d) {
            return ccnDeviceIcon;
        }

        public final boolean isExisting(Object discovered, BComponent db) {
            if (!(db instanceof BCcnDevice)) {
                return false;
            }
            BCcnControllerEntry res = (BCcnControllerEntry)discovered;
            BCcnDevice dev = (BCcnDevice)db;
            boolean exists = false;
            if (res.getBusNo() == dev.getBusNo() && res.getElemNo() == dev.getElemNo()) {
                exists = true;
            }
            return exists;
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BCcnControllerEntry learnEntry = (BCcnControllerEntry)discovery;
            BCcnDevice device = (BCcnDevice)row.getTarget();
            device.setDeviceName(learnEntry.getDevName().trim());
            if (learnEntry.getDevType() == 1) {
                device.setDeviceType(BCcnDeviceTypeEnum.NonBridge);
            } else if (learnEntry.getDevType() == 2) {
                device.setDeviceType(BCcnDeviceTypeEnum.Bridge);
            } else {
                device.setDeviceType(BCcnDeviceTypeEnum.Unknown);
            }
            row.setDefaultName(learnEntry.getDevName());
            row.setCell(BCcnDeviceManager.this.colBusAddress, (BValue)BInteger.make((int)learnEntry.getBusNo()));
            row.setCell(BCcnDeviceManager.this.colElemAddress, (BValue)BInteger.make((int)learnEntry.getElemNo()));
            int busNum = learnEntry.getBusNo();
            int controllerNum = learnEntry.getElemNo();
            device.setBusNo(busNum);
            device.setElemNo(controllerNum);
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BCcnLearnDevicesJob) {
                BCcnDeviceManager.this.updateLearnData();
            }
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return true;
        }
    }

    class TridiumCCNModel
    extends DeviceModel {
        TridiumCCNModel(BDeviceManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BCcnDeviceManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BCcnDeviceManager.this.getNetwork().getDeviceType());
        }
    }
}

