/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obixMigrator;

import com.tridium.authn.BAuthenticationSchemeFolder;
import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.BHTTPBasicAuthenticationScheme;
import com.tridium.migrator.MigrationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Version;

@NiagaraType
@NiagaraSlots
public class BObixServerConverter
extends BComponent
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BObixServerConverter.class);
    private static final List<String> convertTypes;
    private static final String HTTP_BASIC_SCHEME_NAME = "HTTPBasicScheme";

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) {
        String httpBasicAuthSchemeName = this.addHttpBasicScheme(root);
        if (httpBasicAuthSchemeName != null) {
            this.addObixUser(root, httpBasicAuthSchemeName);
        }
    }

    private void addObixUser(BComponent root, String httpBasicAuthSchemeName) {
        BUserService userSvc = null;
        BServiceContainer[] services = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (services != null && services.length > 0) {
            BUserService[] userServices = (BUserService[])services[0].getChildren(BUserService.class);
            if (userServices == null || userServices.length <= 0) {
                log.info("Creating a new UserService");
                userSvc = new BUserService();
                services[0].add(userSvc.getType().getTypeName(), (BValue)userSvc);
            } else {
                userSvc = userServices[0];
                log.fine("Found existing UserService: " + userSvc);
            }
        }
        if (userSvc != null) {
            BUser obixUser = new BUser();
            obixUser.setFullName("User for OBIX Client access");
            obixUser.setAuthenticationSchemeName(httpBasicAuthSchemeName);
            Property p = userSvc.add("obix?", (BValue)obixUser);
            MigrationUtils.logSevereByModule((String)"obixMigrator", (String)"obixMig.createdUser", (Object[])new Object[]{p.getName()});
            MigrationUtils.logSevereByModule((String)"obixMigrator", (String)"obixMig.setPassAndRole", (Object[])new Object[0]);
            MigrationUtils.logSevereByModule((String)"obixMigrator", (String)"obixMig.seeUserDoc", (Object[])new Object[0]);
        }
    }

    private String addHttpBasicScheme(BComponent root) {
        BAuthenticationService authService = null;
        BServiceContainer[] services = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (services != null && services.length > 0) {
            BAuthenticationService[] authServices = (BAuthenticationService[])services[0].getChildren(BAuthenticationService.class);
            if (authServices == null || authServices.length <= 0) {
                log.info("Creating a new AuthenticationService.");
                authService = new BAuthenticationService();
                services[0].add(authService.getType().getTypeName(), (BValue)authService);
            } else {
                authService = authServices[0];
                log.fine("Found existing AuthenticationService: " + authService);
            }
        }
        if (authService != null) {
            BAuthenticationSchemeFolder authSchemes = authService.getAuthenticationSchemes();
            BHTTPBasicAuthenticationScheme[] httpBasicSchemes = (BHTTPBasicAuthenticationScheme[])authSchemes.getChildren(BHTTPBasicAuthenticationScheme.class);
            if (httpBasicSchemes.length == 0) {
                BHTTPBasicAuthenticationScheme httpBasicScheme = new BHTTPBasicAuthenticationScheme();
                log.info("Adding HTTP Basic authentication scheme for obix user");
                authSchemes.add(HTTP_BASIC_SCHEME_NAME, (BValue)httpBasicScheme);
                return HTTP_BASIC_SCHEME_NAME;
            }
            return httpBasicSchemes[0].getName();
        }
        log.severe("Could not find or add HTTPBasicScheme in AuthenticationService");
        return null;
    }

    static {
        ArrayList mutableConvertTypes = new ArrayList();
        Collections.addAll(mutableConvertTypes, "obixDriver:ObixExportFolder");
        convertTypes = Collections.unmodifiableList(mutableConvertTypes);
    }
}

