/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.sys.schema.ComponentSlotMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.baja.category.BCategoryMask;
import javax.baja.io.BIContextEncodable;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.xml.XWriter;

public class BogEncoderCopy
extends XWriter {
    static final int SECURITY_INACCESSIBLE = 1;
    static final int SECURITY_READONLY = 2;
    static final Log log = Log.getLog((String)"sys.xml");
    static TypeInfo nullProxyExt = null;
    protected int indent = 0;
    private boolean encodeTransients;
    private boolean encodeComments = true;
    private HashMap<String, String> modules = new HashMap(33);
    private HashMap<String, String> keys = new HashMap(33);
    private Context context;
    private HashMap<BComponent, BPermissions> permissionsCache;

    public String marshal(BValue value) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)out, this.getContext());
        encoder.encode(value);
        encoder.close();
        return new String(out.toByteArray());
    }

    public BogEncoderCopy(File file) throws IOException {
        super(file);
    }

    public BogEncoderCopy(OutputStream out) throws IOException {
        super(out);
    }

    public BogEncoderCopy(File file, Context context) throws IOException {
        super(file);
        this.context = context;
    }

    public BogEncoderCopy(OutputStream out, Context context) throws IOException {
        super(out);
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isSyncEncoder() {
        return false;
    }

    public boolean isEncodeTransients() {
        return this.encodeTransients;
    }

    public boolean setEncodeTransients(boolean encodeTransients) {
        boolean old = this.encodeTransients;
        this.encodeTransients = encodeTransients;
        return old;
    }

    public boolean isEncodeComments() {
        return this.encodeComments;
    }

    public boolean setEncodeComments(boolean encodeComments) {
        boolean old = this.encodeComments;
        this.encodeComments = encodeComments;
        return old;
    }

    public void encodeDocument(BValue value) throws IOException {
        this.w("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.w("<bajaObjectGraph version=\"1.0\">\n");
        this.encode(value);
        this.w("</bajaObjectGraph>\n");
        this.flush();
    }

    public void encode(BValue value) throws IOException {
        this.encode(null, value, Integer.MAX_VALUE);
    }

    public void encode(String name, BValue value, int depth) throws IOException {
        BPermissions permissions = BPermissions.all;
        if (this.context != null && value.isComponent() && !(permissions = this.getPermissionsFor(value.asComponent())).hasOperatorRead()) {
            throw new SecurityException("Missing op read permission on value");
        }
        this.w("<p");
        if (name != null) {
            this.wname(name);
        }
        if (value.isComponent()) {
            BCategoryMask cats;
            BComponent comp = (BComponent)value;
            Object handle = comp.getHandle();
            if (handle != null) {
                this.whandle(handle);
            }
            if (!(cats = comp.getCategoryMask()).isNull()) {
                this.wcategories(cats);
            }
            if (comp.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded()) {
                this.w(" stub=\"true\"");
            }
        }
        this.wtype((BObject)value);
        this.encodeValue(value, depth, permissions);
    }

    protected void encodingComponent(BComponent c) throws IOException {
    }

    protected void encodingComponentStub(BComponent c) throws IOException {
    }

    protected boolean shouldSkip(BComplex parent, Property prop, int flags) throws IOException {
        return false;
    }

    private void encodeSlot(BComplex parent, Slot slot, boolean forceType, int depth, BPermissions permissions) throws IOException {
        SlotPath path;
        if (slot == null) {
            return;
        }
        int flags = parent.getFlags(slot);
        boolean flagsOnly = false;
        if (!this.encodeTransients && (flags & 2) != 0) {
            if (slot.isProperty() && slot.isFrozen() && flags != slot.getDefaultFlags()) {
                flagsOnly = true;
            } else {
                return;
            }
        }
        Property prop = null;
        BValue value = null;
        boolean skipValue = false;
        if (slot.isProperty() && !flagsOnly) {
            prop = (Property)slot;
            if (this.encodePrimitive(parent, prop, flags)) {
                return;
            }
            if (this.shouldSkip(parent, prop, flags)) {
                return;
            }
            value = parent.get(prop);
            skipValue = slot.isFrozen() ? (value.isComponent() ? !this.isSyncEncoder() && value.getType().getTypeInfo() == nullProxyExt : prop.isEquivalentToDefaultValue(value)) : false;
        } else {
            skipValue = true;
        }
        if (this.context != null) {
            int security = this.getSecurityMask(permissions, slot, value, flags);
            if ((security & 1) != 0) {
                if (slot.isFrozen()) {
                    flags |= 4;
                } else {
                    return;
                }
            }
            if ((security & 2) != 0) {
                flags |= 1;
            }
        }
        if (flags == slot.getDefaultFlags() && skipValue) {
            return;
        }
        boolean isDynamicComponent = slot.isDynamic() && value instanceof BComponent;
        this.indent(this.indent);
        if (isDynamicComponent && this.encodeComments && (path = ((BComponent)value).getSlotPath()) != null) {
            this.w("<!-- ").w((Object)path.getBody()).w((Object)" -->\n");
            this.indent(this.indent);
        }
        if (slot.isProperty()) {
            this.w("<p");
        } else if (slot.isAction()) {
            this.w("<a");
        } else if (slot.isTopic()) {
            this.w("<t");
        } else {
            throw new IllegalStateException();
        }
        this.wname(slot.getName());
        if ((slot.isDynamic() && flags != 0 || flags != slot.getDefaultFlags()) && parent.isComponent()) {
            this.wflags(flags);
        }
        BFacets facets = slot.getFacets();
        if (slot.isDynamic() && !facets.isNull()) {
            this.wfacets(facets);
        }
        if (value instanceof BComponent) {
            BCategoryMask cats;
            BComponent comp = (BComponent)value;
            Object handle = comp.getHandle();
            if (handle != null) {
                this.whandle(handle);
            }
            if (!(cats = comp.getCategoryMask()).isNull()) {
                this.wcategories(cats);
            }
            if (depth == 0 || comp.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded()) {
                this.w(" stub=\"true\"");
            }
        }
        if (prop != null && !skipValue) {
            if (prop.isDynamic() || forceType || !prop.isTypeFinal()) {
                this.wtype((BObject)value);
            }
            this.encodeValue(value, depth - 1, permissions);
        } else {
            this.w("/>\n");
        }
    }

    private boolean encodePrimitive(BComplex parent, Property prop, int flags) throws IOException {
        if (prop.isDynamic() || flags != prop.getDefaultFlags()) {
            return false;
        }
        if (prop.getTypeAccess() == 7) {
            return false;
        }
        if (this.isSyncEncoder()) {
            return false;
        }
        String s = null;
        boolean safe = false;
        switch (prop.getTypeAccess()) {
            case 0: {
                boolean b = parent.getBoolean(prop);
                if (b == ((BBoolean)prop.getDefaultValue()).getBoolean()) {
                    return true;
                }
                s = BBoolean.encode((boolean)b);
                break;
            }
            case 2: {
                int i = parent.getInt(prop);
                if (i == ((BInteger)prop.getDefaultValue()).getInt()) {
                    return true;
                }
                s = BInteger.encode((int)i);
                break;
            }
            case 3: {
                long l = parent.getLong(prop);
                if (l == ((BLong)prop.getDefaultValue()).getLong()) {
                    return true;
                }
                s = BLong.encode((long)l);
                break;
            }
            case 4: {
                float f = parent.getFloat(prop);
                if (f == ((BFloat)prop.getDefaultValue()).getFloat()) {
                    return true;
                }
                s = BFloat.encode((float)f);
                break;
            }
            case 5: {
                double d = parent.getDouble(prop);
                if (d == ((BDouble)prop.getDefaultValue()).getDouble()) {
                    return true;
                }
                s = BDouble.encode((double)d);
                break;
            }
            case 6: {
                s = parent.getString(prop);
                safe = true;
                if (s != ((BString)prop.getDefaultValue()).getString()) break;
                return true;
            }
            default: {
                throw new IllegalStateException("" + prop.getTypeAccess());
            }
        }
        this.indent(this.indent);
        this.w("<p");
        this.wname(prop.getName());
        this.w(" v=\"");
        if (safe) {
            this.safe(s);
        } else {
            this.w(s);
        }
        this.w("\"/>\n");
        return true;
    }

    private void encodeValue(BValue value, int depth, BPermissions permissions) throws IOException {
        if (value.isSimple()) {
            this.wvalue((BSimple)value).w("/>\n");
        } else if (value.isComponent() && depth < 0) {
            this.w(">");
            this.encodingComponentStub((BComponent)value);
            this.w("</p>\n");
        } else {
            if (value.isComponent()) {
                permissions = this.getPermissionsFor(value.asComponent());
            }
            if (this.encodeStructValue(value)) {
                return;
            }
            this.w(">\n");
            ++this.indent;
            BComplex complex = (BComplex)value;
            SlotCursor c = complex.getSlots();
            while (c.next()) {
                this.encodeSlot(complex, c.slot(), false, depth, permissions);
            }
            if (complex.isComponent()) {
                this.encodingComponent(complex.asComponent());
            }
            --this.indent;
            this.indent(this.indent);
            this.w("</p>\n");
        }
    }

    private boolean encodeStructValue(BValue value) throws IOException {
        if (value instanceof BStatusValue) {
            return this.encodeStatusValue(value);
        }
        if (value instanceof BLink) {
            return this.encodeLink(value);
        }
        return false;
    }

    private boolean encodeLink(BValue value) throws IOException {
        if (value.getType() != BLink.TYPE) {
            return false;
        }
        BLink link = (BLink)value;
        this.w("><p n=\"sourceOrd\" v=\"").safe(link.getSourceOrd().encodeToString()).w((Object)"\"/><p n=\"sourceSlotName\" v=\"").safe(link.getSourceSlotName()).w((Object)"\"/><p n=\"targetSlotName\" v=\"").safe(link.getTargetSlotName()).w((Object)"\"/>");
        if (!link.getEnabled()) {
            this.w("<p n=\"enabled\" v=\"false\"/>");
        }
        this.w("</p>\n");
        return true;
    }

    private boolean encodeStatusValue(BValue value) throws IOException {
        BStatus status = null;
        if (value.getType() == BStatusNumeric.TYPE) {
            BStatusNumeric x = (BStatusNumeric)value;
            this.w("><p n=\"value\" v=\"").w((Object)BDouble.encode((double)x.getValue())).w((Object)"\"/>");
            status = x.getStatus();
        } else if (value.getType() == BStatusBoolean.TYPE) {
            BStatusBoolean x = (BStatusBoolean)value;
            this.w("><p n=\"value\" v=\"").w((Object)BBoolean.encode((boolean)x.getValue())).w((Object)"\"/>");
            status = x.getStatus();
        } else if (value.getType() == BStatusEnum.TYPE) {
            BStatusEnum x = (BStatusEnum)value;
            this.w("><p n=\"value\" v=\"").w((Object)x.getValue().encodeToString()).w((Object)"\"/>");
            status = x.getStatus();
        } else if (value.getType() == BStatusString.TYPE) {
            BStatusString x = (BStatusString)value;
            this.w("><p n=\"value\" v=\"").safe(x.getValue()).w((Object)"\"/>");
            status = x.getStatus();
        } else {
            return false;
        }
        if (!status.equals((Object)BStatus.DEFAULT)) {
            this.w("<p n=\"status\" v=\"").safe(status.encodeToString()).w((Object)"\"/>");
        }
        this.w("</p>\n");
        return true;
    }

    public BPermissions getPermissionsFor(BComponent c) {
        BPermissions p;
        if (this.context == null) {
            return BPermissions.all;
        }
        BUser user = this.context.getUser();
        if (user == null) {
            return BPermissions.all;
        }
        if (this.permissionsCache == null) {
            this.permissionsCache = new HashMap();
        }
        if ((p = this.permissionsCache.get(c)) == null) {
            p = c.getPermissions(this.context);
            this.permissionsCache.put(c, p);
        }
        return p;
    }

    private int getSecurityMask(BPermissions permissions, Slot slot, BValue value, int flags) {
        boolean inaccessible = false;
        boolean readonly = false;
        if (slot.isProperty() && value.isComponent()) {
            if (!this.getPermissionsFor(value.asComponent()).has(BPermissions.operatorRead)) {
                inaccessible = true;
            }
        } else if (slot.isAction()) {
            if ((flags & 0x100) != 0) {
                if (!permissions.has(BPermissions.operatorInvoke)) {
                    inaccessible = true;
                }
            } else if (!permissions.has(BPermissions.adminInvoke)) {
                inaccessible = true;
            }
        } else if ((flags & 0x100) != 0) {
            if (!permissions.has(BPermissions.operatorRead)) {
                inaccessible = true;
            } else if (!permissions.has(BPermissions.operatorWrite)) {
                readonly = true;
            }
        } else if (!permissions.has(BPermissions.adminRead)) {
            inaccessible = true;
        } else if (!permissions.has(BPermissions.adminWrite)) {
            readonly = true;
        }
        int mask = 0;
        if (inaccessible) {
            mask |= 1;
        }
        if (readonly) {
            mask |= 2;
        }
        return mask;
    }

    private BogEncoderCopy wname(String name) throws IOException {
        this.w(" n=\"").w((Object)name).w('\"');
        return this;
    }

    private BogEncoderCopy wtype(BObject object) throws IOException {
        Type type = object.getType();
        BModule module = type.getModule();
        String key = this.getModuleKey(module);
        if (key == null) {
            key = this.newModuleKey(module);
            this.w(" m=\"").w((Object)key).w('=').w((Object)module.getModuleName()).w('\"');
        }
        this.w(" t=\"").w((Object)key).w(':').w((Object)type.getTypeName()).w('\"');
        return this;
    }

    private BogEncoderCopy wflags(int flags) throws IOException {
        this.w(" f=\"").w((Object)Flags.encodeToString((int)flags)).w('\"');
        return this;
    }

    private BogEncoderCopy whandle(Object handle) throws IOException {
        this.w(" h=\"").w(handle).w('\"');
        return this;
    }

    private BogEncoderCopy wcategories(BCategoryMask cats) throws IOException {
        this.w(" c=\"").w((Object)cats.encodeToString()).w('\"');
        return this;
    }

    private BogEncoderCopy wfacets(BFacets facets) throws IOException {
        this.w(" x=\"").safe(facets.encodeToString()).w('\"');
        return this;
    }

    private BogEncoderCopy wvalue(BSimple simple) throws IOException {
        try {
            String s = "";
            s = simple instanceof BIContextEncodable ? ((BIContextEncodable)simple).encodeToString(this.getContext()) : simple.encodeToString();
            this.w(" v=\"").safe(s).w('\"');
        }
        catch (Exception e) {
            String s = "?";
            try {
                s = simple.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.error("Encoding " + simple.getType() + " \"" + s + "\"", (Throwable)e);
            this.w(" err=\"" + simple.getType() + ".encodeToString()\"");
        }
        return this;
    }

    private String getModuleKey(BModule module) {
        return this.modules.get(module.getModuleName());
    }

    private String newModuleKey(BModule module) {
        String key = module.getPreferredSymbol();
        int i = 0;
        while (this.keys.get(key) != null) {
            key = "" + key.charAt(0) + i;
            ++i;
        }
        this.keys.put(key, key);
        this.modules.put(module.getModuleName(), key);
        return key;
    }

    static {
        try {
            nullProxyExt = Sys.getRegistry().getType("control:NullProxyExt");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

