/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.remoteVideo.BRemoteVideoChannel;
import com.tridium.remoteVideo.BRemoteVideoSource;
import com.tridium.remoteVideo.RemoteFoxVideoStream;
import com.tridium.videoDriver.event.BRetrieveActionParam;
import com.tridium.videoDriver.event.BVideoEventRecall;
import javax.baja.fox.BFoxProxySession;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRemoteVideoEventRecall
extends BVideoEventRecall {
    public static final Type TYPE = Sys.loadType(BRemoteVideoEventRecall.class);
    protected BRemoteVideoSource remoteVideoSource;
    public static final String VIDEO_EVENT_RECALL_INTEREST = "VideoEventRecall";
    public static final BFoxClientConnection.StringInterest GET_VIDEO_EVENT_RECALL_ORD_INTEREST = new BFoxClientConnection.StringInterest("GetVideoEventRecallerOrd");
    public static Log log = Log.getLog((String)"remoteVideo.eventRecall");

    public Type getType() {
        return TYPE;
    }

    public BRemoteVideoSource getRemoteVideoSource() {
        if (this.remoteVideoSource == null) {
            this.remoteVideoSource = (BRemoteVideoSource)this.getParent();
        }
        return this.remoteVideoSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRetrieveEvents(BRetrieveActionParam param) {
        BOrd remoteEventRecallOrd;
        String remoteStationName;
        BFoxClientConnection foxConnectionToNiagaraStation;
        BNiagaraStation niagaraStation;
        block23: {
            if (log.isTraceOn()) {
                log.trace("RetrieveEvents slotpath = " + this.getSlotPathOrd());
            }
            BNiagaraNetwork niagaraNet = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            niagaraStation = (BNiagaraStation)niagaraNet.getStation(this.getRemoteVideoSource().getNiagaraStation());
            foxConnectionToNiagaraStation = niagaraStation.getClientConnection();
            remoteStationName = niagaraStation.getStationName();
            remoteEventRecallOrd = null;
            try {
                if (log.isTraceOn()) {
                    log.trace("Engaging interest to remote station: " + remoteStationName + " Interest = GET_VIDEO_EVENT_RECALL_ORD_INTEREST");
                }
                foxConnectionToNiagaraStation.engageNoRetry((BFoxClientConnection.Interest)GET_VIDEO_EVENT_RECALL_ORD_INTEREST);
                if (foxConnectionToNiagaraStation.isConnected()) {
                    if (log.isTraceOn()) {
                        log.trace("Connected to remote station: " + remoteStationName + " Interest = GET_VIDEO_EVENT_RECALL_ORD_INTEREST");
                    }
                    BRemoteVideoChannel remoteVideoChannel = (BRemoteVideoChannel)foxConnectionToNiagaraStation.getChannels().get("remoteVideo", BRemoteVideoChannel.TYPE);
                    if (log.isTraceOn()) {
                        log.trace("Getting event recaller ord in remote station: " + remoteStationName + " Interest = GET_VIDEO_EVENT_RECALL_ORD_INTEREST");
                    }
                    remoteEventRecallOrd = remoteVideoChannel.doGetEventRecaller(this.getRemoteVideoSource().getCameraOrd());
                    if (log.isTraceOn()) {
                        log.trace("Remote recaller ord = " + remoteEventRecallOrd);
                    }
                    break block23;
                }
                String msg = "Unable to connect to remote station [" + niagaraStation.getStationName() + "]. Interest = GET_VIDEO_EVENT_RECALL_ORD_INTEREST";
                log.error(msg);
                throw new BajaRuntimeException(msg);
            }
            catch (BajaRuntimeException bre) {
                throw bre;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            finally {
                if (log.isTraceOn()) {
                    log.trace("Disengaging interest to remote station: " + remoteStationName + " Interest = GET_VIDEO_EVENT_RECALL_ORD_INTEREST");
                }
                foxConnectionToNiagaraStation.disengage((BFoxClientConnection.Interest)RemoteFoxVideoStream.REMOTE_VIDEO_INTEREST);
            }
        }
        if (remoteEventRecallOrd == null) return;
        if (log.isTraceOn()) {
            log.trace("Creating BFoxProxySession to remote station: " + remoteStationName);
        }
        BFoxProxySession foxProxySessionToRemoteStation = BFoxProxySession.make((BHost)foxConnectionToNiagaraStation.getRemoteHost(), (int)foxConnectionToNiagaraStation.getPort(), (boolean)foxConnectionToNiagaraStation.getUseFoxs(), (BIUserCredentials)foxConnectionToNiagaraStation.getCredentials());
        try {
            BObject remoteEventRecallObject;
            if (log.isTraceOn()) {
                log.trace("Engaging interest to remote station: " + remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
            }
            foxProxySessionToRemoteStation.engageNoRetry(VIDEO_EVENT_RECALL_INTEREST);
            if (!foxProxySessionToRemoteStation.isConnected()) throw new BajaRuntimeException("Unable to connect to remote station [" + niagaraStation.getStationName() + "]. Interest = VIDEO_EVENT_RECALL_INTEREST");
            if (log.isTraceOn()) {
                log.trace("Connected to remote station: " + remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
                log.trace("Resolving video event recaller in remote station: " + remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
            }
            if (!((remoteEventRecallObject = remoteEventRecallOrd.get((BObject)foxProxySessionToRemoteStation)) instanceof BVideoEventRecall)) throw new BajaRuntimeException("The remote video event recall component does not implement BVideoEventRecall.");
            if (log.isTraceOn()) {
                log.trace("Resolved video event recaller! Good! Remote station: " + remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
            }
            BVideoEventRecall remoteVideoEventRecall = (BVideoEventRecall)remoteEventRecallObject;
            if (log.isTraceOn()) {
                log.trace("Requesting a list of events from the remote video event recaller. Remote station: " + remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
            }
            remoteVideoEventRecall.retrieveEvents(param);
            if (log.isTraceOn()) {
                log.trace("Successfully requested a list of events from the remote video event recaller. Remote station: " + remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
                log.trace("Listening for list on events to be retrieved from video device. Remote station: " + remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
            }
            RemoteVideoEventSubscriber remoteVideoEventSubscriber = new RemoteVideoEventSubscriber(foxProxySessionToRemoteStation, remoteVideoEventRecall, remoteStationName);
            remoteVideoEventSubscriber.listenForVideoEventTopics();
            return;
        }
        catch (BajaRuntimeException bre) {
            throw bre;
        }
        catch (Exception e) {
            if (log.isTraceOn()) {
                log.trace("Caught exception during VIDEO_EVENT_RECALL_INTEREST interest. Disengaging interest.", (Throwable)e);
            }
            foxProxySessionToRemoteStation.disengage(VIDEO_EVENT_RECALL_INTEREST);
            if (!(e instanceof BajaRuntimeException)) throw new BajaRuntimeException((Throwable)e);
            throw (BajaRuntimeException)((Object)e);
        }
    }

    public class RemoteVideoEventSubscriber
    extends Subscriber
    implements Runnable {
        Thread watchDogThread;
        BVideoEventRecall remoteProxyVideoEventRecall;
        BFoxProxySession foxProxySession;
        String remoteStationName;

        public RemoteVideoEventSubscriber(BFoxProxySession foxProxySession, BVideoEventRecall remoteProxyVideoEventRecall, String remoteStationName) {
            this.foxProxySession = foxProxySession;
            this.remoteProxyVideoEventRecall = remoteProxyVideoEventRecall;
            this.remoteStationName = remoteStationName;
        }

        public void listenForVideoEventTopics() {
            this.launchWatchdog();
            this.subscribe((BComponent)this.remoteProxyVideoEventRecall);
        }

        public void launchWatchdog() {
            try {
                if (log.isTraceOn()) {
                    log.trace("Spawning watchdog thread. Remote station: " + this.remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
                }
                this.watchDogThread = new Thread((Runnable)this, "RemoteVideoEventRecall:Watchdog:" + BRemoteVideoEventRecall.this.getHandle());
                this.watchDogThread.start();
            }
            catch (Throwable t) {
                if (log.isTraceOn()) {
                    log.trace("Error spawning watchdog thread. Remote station: " + this.remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST. Unsubscribing and disengaging interest.");
                }
                this.unsubscribeAll();
                this.foxProxySession.disengage(BRemoteVideoEventRecall.VIDEO_EVENT_RECALL_INTEREST);
            }
        }

        @Override
        public void run() {
            try {
                if (log.isTraceOn()) {
                    log.trace("Watchdog thread running. Remote station: " + this.remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
                }
                Thread.sleep(600000L);
            }
            catch (InterruptedException ie) {
                if (log.isTraceOn()) {
                    log.trace("Watchdog thread interrupted. Remote station: " + this.remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
                }
            }
            finally {
                if (log.isTraceOn()) {
                    log.trace("Watchdog disengaging interest and unsubscribing. Remote station: " + this.remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
                }
                this.disengageAndUnsubscribe();
            }
        }

        public void disengageAndUnsubscribe() {
            this.unsubscribeAll();
            this.foxProxySession.disengage(BRemoteVideoEventRecall.VIDEO_EVENT_RECALL_INTEREST);
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 5) {
                if (event.getSlot().equals((Object)BVideoEventRecall.retrieveOk)) {
                    if (log.isTraceOn()) {
                        log.trace("Remote 'retrieveOk' topic detected. Remote station: " + this.remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
                    }
                    BRemoteVideoEventRecall.this.fire(BVideoEventRecall.retrieveOk, event.getValue());
                    if (this.watchDogThread == null) {
                        this.disengageAndUnsubscribe();
                    } else {
                        this.watchDogThread.interrupt();
                    }
                } else if (event.getSlot().equals((Object)BVideoEventRecall.retrieveFailed)) {
                    if (log.isTraceOn()) {
                        log.trace("Remote 'retrieveFailed' topic detected. Remote station: " + this.remoteStationName + " Interest = VIDEO_EVENT_RECALL_INTEREST");
                    }
                    BRemoteVideoEventRecall.this.fire(BVideoEventRecall.retrieveFailed, event.getValue());
                    if (this.watchDogThread == null) {
                        this.disengageAndUnsubscribe();
                    } else {
                        this.watchDogThread.interrupt();
                    }
                }
            }
        }
    }
}

