/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.net;

import com.tridium.crypto.core.io.CryptoCoreClientSocketFactory;
import com.tridium.net.BProxyAuthenticationType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.BHttpProxyService;
import javax.baja.net.BInternetAddress;
import javax.baja.net.HttpConnection;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.status.BStatus;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class HttpsConnection
extends HttpConnection {
    private SocketFactory socketFactory = null;

    public HttpsConnection(BHost host, int port, String uri, SocketFactory socketFactory) {
        super(host, port, uri);
        this.initSocketFactory(socketFactory);
    }

    public HttpsConnection(BHost host, int port, String uri) {
        super(host, port, uri);
        this.createSocketFactory(null);
    }

    public HttpsConnection(BHost host, int port, String uri, String clientAlias) throws Exception {
        super(host, port, uri);
        this.createSocketFactory(clientAlias);
    }

    private HttpsConnection(BHost host, int port) {
        super(host, port);
        this.initSocketFactory(null);
    }

    private void createSocketFactory(String clientAlias) {
        try {
            this.socketFactory = HttpsConnection.getDefaultSocketFactory(clientAlias);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void initSocketFactory(SocketFactory socketFactory) {
        try {
            if (socketFactory == null) {
                socketFactory = HttpsConnection.getDefaultSocketFactory(null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socketFactory = socketFactory;
    }

    public static int post(BHost host, int port, String uri, String contentType, byte[] buf) throws IOException {
        HttpsConnection conn = new HttpsConnection(host, port, uri);
        conn.setRequestMethod("POST");
        if (contentType != null) {
            conn.setRequestHeader("content-type", contentType);
        }
        while (conn.getRequestHeader("content-length") != null) {
            conn.removeRequestHeader("content-length");
        }
        conn.setRequestHeader("content-length", buf.length);
        int rc = ((HttpConnection)conn).connect(buf.length, new ByteArrayInputStream(buf));
        try {
            conn.readContent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public synchronized int connect(long contentLength, InputStream stream) throws IOException {
        if (this.hostHeader == null) {
            BInternetAddress addr = new BInternetAddress(this.host.getHostname(), this.port != 443 ? this.port : -1);
            this.hostHeader = addr.getAuthority();
            addr = null;
        }
        this.proxy = BHttpProxyService.get(this.host);
        this.s = this.proxy != null ? this.createSocket(this.proxy, this.host.getHostname(), this.port, this.timeout) : this.createSocket(((BIpHost)this.host).getInetAddress(), this.port, this.timeout);
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        if (this.timeout > 0) {
            this.s.setSoTimeout(this.timeout);
        }
        return this.newRequest(this.startUri, contentLength, stream);
    }

    @Override
    public synchronized int connect(int timeout) throws IOException {
        if (this.hostHeader == null) {
            BInternetAddress addr = new BInternetAddress(this.host.getHostname(), this.port != 80 ? this.port : -1);
            this.hostHeader = addr.getAuthority();
            Object var2_2 = null;
        }
        this.proxy = BHttpProxyService.get(this.host);
        this.s = this.proxy != null ? this.createSocket(this.proxy, this.host.getHostname(), this.port, timeout) : this.createSocket(((BIpHost)this.host).getInetAddress(), this.port, timeout);
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        if (timeout > 0) {
            this.s.setSoTimeout(timeout);
        }
        return this.newRequest(this.startUri);
    }

    private Socket createSocket(InetAddress host, int port, int timeout) throws IOException {
        if (this.socketFactory instanceof CryptoCoreClientSocketFactory) {
            return ((CryptoCoreClientSocketFactory)this.socketFactory).createSocket(host, port, timeout);
        }
        return this.socketFactory.createSocket(host, port);
    }

    private Socket createSocket(BHttpProxyService proxy, String host, int port, int timeout) throws IOException {
        this.s = proxy.openSocket(this.connectionTimeout);
        this.s.setSoTimeout(timeout);
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        this.sendConnect();
        this.in = this.s.getInputStream();
        int statusCode = this.readResponse(this.in);
        if (statusCode < 200 || statusCode >= 300) {
            String message = this.getStatusMessage();
            proxy.setStatus(BStatus.makeFault((BStatus)proxy.getStatus(), (boolean)true));
            proxy.setFaultCause(message);
            BHttpProxyService.log.severe(message + " (HTTP " + statusCode + ")");
            throw new IOException("Failed to establish proxy connection: " + statusCode + ": " + message);
        }
        SSLSocket socket = (SSLSocket)((SSLSocketFactory)this.socketFactory).createSocket(this.s, host, port, true);
        socket.startHandshake();
        return socket;
    }

    @Override
    protected void handleProxyAuth(long contentLength) throws IOException {
        this.sendConnect();
    }

    private void sendConnect() throws IOException {
        String ua;
        String authorizationHeader;
        this.pw.print("CONNECT ");
        this.pw.print(this.hostHeader);
        if (this.hostHeader.indexOf(58) < 0) {
            this.pw.print(':');
            this.pw.print(this.port);
        }
        this.pw.print(' ');
        this.pw.print("HTTP/1.1");
        this.pw.print("\r\n");
        if (!this.proxy.getAuthenticationScheme().equals((Object)BProxyAuthenticationType.none) && (authorizationHeader = this.proxy.getAuthentication(this.proxyChallenge, "CONNECT", "/")) != null) {
            this.pw.print("Proxy-Authorization: ");
            this.pw.print(authorizationHeader);
            this.pw.print("\r\n");
        }
        String string = ua = this.userAgent != null ? this.userAgent : defUserAgent;
        if (ua != null) {
            this.pw.print("user-agent: ");
            this.pw.print(ua);
            this.pw.print("\r\n");
        }
        this.pw.print("\r\n");
        this.pw.flush();
    }

    @Override
    public synchronized int newRequest(String uri, long contentLength, InputStream stream) throws IOException {
        if (!this.allowMultipleRequests) {
            throw new IOException("This connection doesn't allow multiple requests.");
        }
        if (!this.isOpen()) {
            this.startUri = uri;
            return this.connect(contentLength, stream);
        }
        this.writeRequest(uri, contentLength, stream);
        return this.readResponse(this.in);
    }

    public static SocketFactory getDefaultSocketFactory() throws IOException {
        return HttpsConnection.getDefaultSocketFactory(null);
    }

    public static SocketFactory getDefaultSocketFactory(String clientAlias) throws IOException {
        SocketFactory socketFactory;
        try {
            ICryptoManager service = CertManagerFactory.getInstance();
            socketFactory = service.getClientSocketFactory(ClientTlsParameters.DEFAULT);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return socketFactory;
    }
}

