/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class HttpDateFormat {
    private static Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);

    public static String format(long dateTime, char dateSep) {
        return HttpDateFormat.formatDate(new Date(dateTime), dateSep);
    }

    public static String format(long dateTime) {
        return HttpDateFormat.formatDate(new Date(dateTime), ' ');
    }

    public static String formatDate(Date date) {
        return HttpDateFormat.formatDate(date, ' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date, char dateSep) {
        DateTimeInfo dt = new DateTimeInfo();
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.setTime(date);
            dt.dayOfWeek = cal.get(7);
            dt.dayOfMonth = cal.get(5);
            dt.month = cal.get(2);
            dt.year = cal.get(1);
            dt.hour = cal.get(11);
            dt.minute = cal.get(12);
            dt.second = cal.get(13);
        }
        return HttpDateFormat.formatDateTimeInfo(dt, dateSep);
    }

    private static String formatDateTimeInfo(DateTimeInfo dt, char dateSep) {
        StringBuffer sbuf = new StringBuffer(30);
        sbuf.append(HttpDateFormat.getDayOfWeekString(dt.dayOfWeek));
        sbuf.append(", ");
        if (dt.dayOfMonth < 10) {
            sbuf.append('0');
        }
        sbuf.append(dt.dayOfMonth);
        sbuf.append(dateSep);
        sbuf.append(HttpDateFormat.getMonthString(dt.month));
        sbuf.append(dateSep);
        sbuf.append(dt.year).append(' ');
        if (dt.hour < 10) {
            sbuf.append('0');
        }
        sbuf.append(dt.hour).append(':');
        if (dt.minute < 10) {
            sbuf.append('0');
        }
        sbuf.append(dt.minute).append(':');
        if (dt.second < 10) {
            sbuf.append('0');
        }
        sbuf.append(dt.second);
        sbuf.append(" GMT");
        return sbuf.toString();
    }

    public static String getDayOfWeekString(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return "Sun";
            }
            case 2: {
                return "Mon";
            }
            case 3: {
                return "Tue";
            }
            case 4: {
                return "Wed";
            }
            case 5: {
                return "Thu";
            }
            case 6: {
                return "Fri";
            }
            case 7: {
                return "Sat";
            }
        }
        throw new IllegalArgumentException("Invalid weekday index: " + dayOfWeek);
    }

    public static String getMonthString(int month) {
        switch (month) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Feb";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Apr";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Aug";
            }
            case 8: {
                return "Sep";
            }
            case 9: {
                return "Oct";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dec";
            }
        }
        throw new IllegalArgumentException("Invalid month index: " + month);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parse(String dateString) throws IllegalArgumentException {
        try {
            long dt;
            DateTimeInfo d = new DateTimeInfo();
            StringTokenizer st = new StringTokenizer(dateString, " ,");
            String token = st.nextToken();
            d.dayOfWeek = HttpDateFormat.getWeekday(token);
            if (d.dayOfWeek != -1) {
                token = st.nextToken(" ,-");
            }
            d.dayOfMonth = HttpDateFormat.getDayOfMonth(token);
            boolean asctime = false;
            if (d.dayOfMonth != -1) {
                HttpDateFormat.parseDate1OrDate2(d, st);
            } else {
                asctime = true;
                d.month = HttpDateFormat.getMonth(token);
                if (d.month == -1) {
                    throw new IllegalArgumentException("Invalid date string: " + dateString);
                }
                HttpDateFormat.parseAsctimeDate(d, st);
            }
            HttpDateFormat.parseTime(d, st);
            if (asctime) {
                d.year = Integer.parseInt(st.nextToken());
            }
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.set(d.year, d.month, d.dayOfMonth, d.hour, d.minute, d.second);
                dt = cal.getTime().getTime();
            }
            return dt;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid date string: " + dateString);
        }
    }

    public static int getWeekday(String wdStr) {
        char ch = wdStr.charAt(0);
        switch (ch) {
            case 'M': 
            case 'm': {
                return 2;
            }
            case 'T': 
            case 't': {
                char ch2 = wdStr.charAt(1);
                if (ch2 == 'u' || ch2 == 'U') {
                    return 3;
                }
                return 5;
            }
            case 'W': 
            case 'w': {
                return 4;
            }
            case 'F': 
            case 'f': {
                return 6;
            }
            case 'S': 
            case 's': {
                char ch2 = wdStr.charAt(1);
                if (ch2 == 'u' || ch2 == 'U') {
                    return 1;
                }
                return 7;
            }
        }
        return -1;
    }

    public static int getDayOfMonth(String dayStr) {
        if (Character.isDigit(dayStr.charAt(0))) {
            try {
                return Integer.parseInt(dayStr);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static int getMonth(String monthStr) {
        char ch1 = monthStr.charAt(0);
        switch (ch1) {
            case 'J': 
            case 'j': {
                char ch2 = monthStr.charAt(1);
                if (ch2 == 'a' || ch2 == 'A') {
                    return 0;
                }
                char ch3 = monthStr.charAt(2);
                if (ch3 == 'n' || ch3 == 'N') {
                    return 5;
                }
                return 6;
            }
            case 'F': 
            case 'f': {
                return 1;
            }
            case 'M': 
            case 'm': {
                char ch2 = monthStr.charAt(2);
                if (ch2 == 'r' || ch2 == 'R') {
                    return 2;
                }
                return 4;
            }
            case 'A': 
            case 'a': {
                char ch2 = monthStr.charAt(1);
                if (ch2 == 'p' || ch2 == 'P') {
                    return 3;
                }
                return 7;
            }
            case 'S': 
            case 's': {
                return 8;
            }
            case 'O': 
            case 'o': {
                return 9;
            }
            case 'N': 
            case 'n': {
                return 10;
            }
            case 'D': 
            case 'd': {
                return 11;
            }
        }
        return -1;
    }

    private static void parseDate1OrDate2(DateTimeInfo d, StringTokenizer st) {
        String token = st.nextToken(" -");
        d.month = HttpDateFormat.getMonth(token);
        if (d.month == -1) {
            throw new IllegalArgumentException("Invalid month string: " + token);
        }
        token = st.nextToken();
        d.year = Integer.parseInt(token);
        if (d.year < 100) {
            d.year = d.year < 60 ? (d.year += 2000) : (d.year += 1900);
        }
    }

    private static void parseAsctimeDate(DateTimeInfo d, StringTokenizer st) {
        d.dayOfMonth = Integer.parseInt(st.nextToken());
    }

    private static void parseTime(DateTimeInfo d, StringTokenizer st) {
        d.hour = Integer.parseInt(st.nextToken(" :"));
        d.minute = Integer.parseInt(st.nextToken());
        d.second = Integer.parseInt(st.nextToken());
    }

    private static class DateTimeInfo {
        public int dayOfWeek = -1;
        public int dayOfMonth = -1;
        public int month = -1;
        public int year = -1;
        public int hour = -1;
        public int minute = -1;
        public int second = -1;

        private DateTimeInfo() {
        }

        public void printAttributes() {
            System.out.println("DateTimeInfo:");
            System.out.println("  dayOfWeek : " + this.dayOfWeek);
            System.out.println("  dayOfMonth: " + this.dayOfMonth);
            System.out.println("  month     : " + this.month);
            System.out.println("  year      : " + this.year);
            System.out.println("  hour      : " + this.hour);
            System.out.println("  minute    : " + this.minute);
            System.out.println("  second    : " + this.second);
        }
    }
}

