/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class ChunkedOutputStream
extends OutputStream {
    private OutputStream out;
    private PrintWriter pw;
    private boolean closed = false;
    private byte[] chunkBuf;
    private int byteCount = 0;
    private Vector<String[]> entityHeaders;

    public ChunkedOutputStream(OutputStream out, int maxChunkSize) {
        this.out = out;
        this.chunkBuf = new byte[maxChunkSize];
        this.pw = new PrintWriter(out, false);
    }

    public void setHeader(String name, String value) {
        if (this.entityHeaders == null) {
            this.entityHeaders = new Vector(2);
        }
        String[] nv = new String[]{name, value};
        this.entityHeaders.addElement(nv);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("The output stream has been closed.");
        }
        this.chunkBuf[this.byteCount++] = (byte)(0xFF & b);
        if (this.byteCount == this.chunkBuf.length) {
            this.writeChunk();
        }
    }

    private void writeChunk() throws IOException {
        if (this.byteCount == 0) {
            return;
        }
        String sizeStr = Integer.toHexString(this.byteCount);
        this.pw.print(sizeStr);
        this.pw.print("\r\n");
        this.pw.flush();
        this.out.write(this.chunkBuf, 0, this.byteCount);
        this.out.flush();
        this.pw.print("\r\n");
        this.pw.flush();
        this.byteCount = 0;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.writeChunk();
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.pw.print("0");
        this.pw.print("\r\n");
        if (this.entityHeaders != null) {
            for (int i = 0; i < this.entityHeaders.size(); ++i) {
                String[] nv = this.entityHeaders.elementAt(i);
                this.pw.print(nv[0]);
                this.pw.print(": ");
                this.pw.print(nv[1]);
                this.pw.print("\r\n");
            }
        }
        this.pw.print("\r\n");
        this.pw.flush();
        this.closed = true;
        this.entityHeaders = null;
        this.chunkBuf = null;
    }

    public int getChunkSize() {
        return this.chunkBuf.length;
    }
}

