/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import com.tridium.net.BHttpObject;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHttpsScheme
extends BOrdScheme {
    public static final BHttpsScheme INSTANCE = new BHttpsScheme();
    public static final Type TYPE = Sys.loadType(BHttpsScheme.class);

    private BHttpsScheme() {
        super("https");
    }

    public OrdQuery parse(String queryBody) {
        return new HttpsQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        return new OrdTarget(base, (BObject)new BHttpObject(query.toString()));
    }

    public Type getType() {
        return TYPE;
    }

    static class HttpsQuery
    implements OrdQuery {
        final String body;

        HttpsQuery(String body) {
            this.body = body;
        }

        public boolean isHost() {
            return true;
        }

        public boolean isSession() {
            return false;
        }

        public void normalize(OrdQueryList list, int index) {
            list.trim(index);
        }

        public String getScheme() {
            return "https";
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return "https:" + this.body;
        }
    }
}

