/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.migration;

import com.tridium.install.installable.DistributionManifest;
import com.tridium.util.CommandLineArguments;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.migration.BIFileMigrator;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BFileMigrator
extends BObject
implements BIFileMigrator {
    public static final Type TYPE = Sys.loadType(BFileMigrator.class);
    public final Logger log = Logger.getLogger("migration");
    protected File source;
    protected File target;
    protected DistributionManifest distManifest;
    protected CommandLineArguments args;

    public Type getType() {
        return TYPE;
    }

    @Override
    public void initialize(File source, File target, Supplier<BPassword> passwordSupplier, DistributionManifest distManifest) {
        Objects.requireNonNull(source);
        this.source = source;
        this.target = target == null ? new File(source.getParentFile(), "migrated_" + source.getName()) : target;
        this.distManifest = distManifest;
        this.log.config(this.getClass().getSimpleName() + " initialized with source=" + source + "; target=" + this.target);
    }

    @Override
    public Optional<String> migrate() throws Exception {
        try {
            File tgtdir;
            File file = tgtdir = this.target.isDirectory() ? this.target : this.target.getParentFile();
            if (tgtdir != null && !tgtdir.exists() && !tgtdir.mkdirs()) {
                throw new IOException("Could not create parent directories for target");
            }
            FileUtil.copy((File)this.source, (File)this.target);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of("Error migrating " + this.source + " to " + this.target + ":" + e.toString());
        }
    }

    @Override
    public void setLogLevel(Level level) {
        this.log.setLevel(level);
    }

    public void setArgs(CommandLineArguments args) {
        this.args = args;
    }
}

