/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;

public final class Log {
    private static final String logPrefix = "jsonToolkit";
    private static final String DEFAULT_AUDIT_USERNAME = "json";
    public static final Logger log = Logger.getLogger("jsonToolkit");

    private Log() {
    }

    public static Logger child(String name) {
        return Logger.getLogger("jsonToolkit." + name);
    }

    public static void debugStack() {
        if (log.isLoggable(Level.FINEST)) {
            Log.debugStack(log, new Exception());
        }
    }

    public static void debugStack(Logger log, Exception e) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Stack Trace: ", e);
        }
    }

    public static void audit(Context cx, String event, String target, String slotName, String old, BValue value) {
        Auditor auditor = Sys.getAuditor();
        if (auditor != null) {
            if (value == null) {
                value = BString.make((String)"null");
            }
            if (old == null) {
                old = "null";
            }
            String username = cx != null && cx.getUser() != null ? cx.getUser().getUsername() : DEFAULT_AUDIT_USERNAME;
            AuditEvent auditEvent = new AuditEvent(event, target, slotName, old, value.toString(), username);
            auditor.audit(auditEvent);
        }
    }
}

